/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.LPC;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenDigitaxVariator
extends CanOpenDevice {
    protected DigitaxMode mode;
    private final Map<String, Integer> paramsForVelocity;
    private final Map<String, Integer> paramsForTorque_Profile;
    private final Lock lock = new ReentrantLock();
    private final Condition enablingCompleted = this.lock.newCondition();
    protected volatile boolean enabling = false;

    public CanOpenDigitaxVariator(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForVelocity, Map<String, Integer> paramsForTorque_Profile) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.paramsForVelocity = paramsForVelocity;
        this.paramsForTorque_Profile = paramsForTorque_Profile;
    }

    @Override
    public void initModule() {
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change Digitax variator mode .")
    public String changeMode(String modeInString) throws SDORequestException, FcsHardwareException {
        DigitaxMode newMode = DigitaxMode.valueOf(modeInString.trim().toUpperCase());
        return this.changeMode(newMode);
    }

    public String changeMode(DigitaxMode newMode) throws SDORequestException, FcsHardwareException {
        this.writeSDO("6060", "0", "1", newMode.modeInHexa);
        this.mode = newMode;
        return this.name + " mode has been changed to: " + newMode.toString() + ". Please check parameters associated with this mode.";
    }

    public String readMode() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        DigitaxMode readMode;
        String modeInHexa = this.readSDO("6061", "0").trim().toUpperCase();
        this.mode = readMode = DigitaxMode.getMode(modeInHexa);
        return readMode.toString();
    }

    public static String displayListParameters(String modeInString) {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters for mode: ");
        sb.append(modeInString);
        sb.append("\n");
        for (Parameter param : params = DigitaxMode.valueOf(modeInString).parameters) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String displayListParameters() {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters : ");
        sb.append("\n");
        for (Parameter param : params = Parameter.values()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public int readTorque_actual_value() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        return this.readParameter("torque_actual_value");
    }

    public String writeTorque(int value) throws SDORequestException, FcsHardwareException {
        return this.writeParameter(Parameter.target_torque, value);
    }

    public String readParameters(String modeInString) throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("Value set for the parameters for the mode : ");
        sb.append(modeInString);
        sb.append("\n");
        for (Parameter param : params = DigitaxMode.valueOf(modeInString).parameters) {
            String valueInHexa = this.readSDO(param.index, param.subindex);
            int valueInt = Integer.parseInt(valueInHexa, 16);
            sb.append(param.toString());
            sb.append("=");
            sb.append(valueInt);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String readParameters() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        String modeInString = this.readMode();
        return this.readParameters(modeInString);
    }

    public int readParameter(String parameterName) throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        Parameter param = Parameter.valueOf(parameterName);
        return this.readParameter(param);
    }

    public int readParameter(Parameter param) throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        String valueInHexa = this.readSDO(param.index, param.subindex);
        return new BigInteger(valueInHexa, 16).intValue();
    }

    public String printParameters(String modeInString) {
        Map<String, Integer> paramsMap;
        DigitaxMode aMode = DigitaxMode.valueOf(modeInString.trim().toUpperCase());
        switch (aMode) {
            case VELOCITY: {
                paramsMap = this.paramsForVelocity;
                break;
            }
            case TORQUE_PROFILE: {
                paramsMap = this.paramsForTorque_Profile;
                break;
            }
            default: {
                throw new IllegalArgumentException(modeInString + " is a bad value for Digitax mode.");
            }
        }
        return this.printParameters(paramsMap);
    }

    public String printParameters(Map<String, Integer> paramMap) {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("Parameters in configuration file:\n");
        if (paramMap == null) {
            return "Empty Parameters List";
        }
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            sb.append("key=");
            sb.append(paramName);
            sb.append("/value=");
            sb.append(value);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void writeParameters(String modeInString) throws SDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        DigitaxMode aMode = DigitaxMode.valueOf(modeInString);
        this.writeParameters(aMode);
    }

    public void writeParameters(DigitaxMode mode) throws SDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        String modeInString = mode.toString();
        Map<String, Integer> paramsMap = null;
        switch (mode) {
            case VELOCITY: {
                paramsMap = this.paramsForVelocity;
                break;
            }
            case TORQUE_PROFILE: {
                paramsMap = this.paramsForTorque_Profile;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (paramsMap == null) {
            throw new ErrorInCommandExecutionException(this.name + "parameters for mode :" + modeInString + "are NULL");
        }
        if (paramsMap.isEmpty()) {
            throw new ErrorInCommandExecutionException(this.name + "parameters for mode :" + modeInString + "are not defined.");
        }
        this.writeParameters(paramsMap);
    }

    public void writeParameters(Map<String, Integer> paramMap) throws SDORequestException, FcsHardwareException {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(paramName, value);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set Digitax Variator parameter with the value given as argument.")
    public String writeParameter(String parameterName, int value) throws SDORequestException, FcsHardwareException {
        Parameter param = Parameter.valueOf(parameterName);
        return this.writeParameter(param, value);
    }

    public String writeParameter(Parameter param, int value) throws SDORequestException, FcsHardwareException {
        this.writeSDO(param.index, param.subindex, param.size, Integer.toHexString(value));
        return String.format("%s has been written to the Digitax Variator CPU, value=%d", param.toString(), value);
    }

    @Override
    public String initializeAndCheckHardware() throws FcsHardwareException {
        return this.getName() + ": no hardware initialization for this device to be done.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnable() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        this.lock.lock();
        try {
            while (this.enabling) {
                try {
                    this.enablingCompleted.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.debug((Object)(this.getName() + " INTERRUPTED during waiting for the actuator beeing enable"));
                }
            }
            String controlWordInHexa = this.readControlWord();
            int controlWord = Integer.parseInt(controlWordInHexa, 16);
            boolean bl = controlWord == 15;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void faultReset() throws SDORequestException, FcsHardwareException {
        this.writeControlWord("80");
    }

    public String enable() throws SDORequestException, FcsHardwareException {
        this.lock.lock();
        try {
            this.enabling = true;
            this.shutdown();
            this.switchOnEnableOperation();
            String string = this.name + " ENABLE";
            return string;
        }
        finally {
            this.enabling = false;
            this.enablingCompleted.signal();
            this.lock.unlock();
        }
    }

    public String shutdown() throws SDORequestException, FcsHardwareException {
        this.writeControlWord("6");
        return this.name + " DISABLE";
    }

    public void switchOnEnableOperation() throws SDORequestException, FcsHardwareException {
        this.writeControlWord("F");
    }

    @Override
    public Object saveParameters() throws SDORequestException, FcsHardwareException {
        return this.writeSDO("1010", "1", "4", "65766173");
    }

    public Object restoreParameters() throws SDORequestException, FcsHardwareException {
        return this.writeSDO("1011", "1", "4", "64616F6C");
    }

    public void writeControlWord(String value) throws SDORequestException, FcsHardwareException {
        this.writeSDO("6040", "0", "2", value);
    }

    public String readControlWord() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        return this.readSDO("6040", "0");
    }

    public String readStatusWord() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        return this.readSDO("6041", "0");
    }

    public void quickStop() throws SDORequestException, FcsHardwareException {
        switch (this.mode) {
            case VELOCITY: {
                this.writeControlWord("B");
                break;
            }
            case TORQUE_PROFILE: {
                this.writeControlWord("B");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(CanOpenDigitaxVariator.displayListParameters("VELOCITY"));
        System.out.println(CanOpenDigitaxVariator.displayListParameters("TORQUE_PROFILE"));
        System.out.println(CanOpenDigitaxVariator.displayListParameters());
    }

    public static enum DigitaxMode {
        VELOCITY("2", Parameter.vl_target_velocity, Parameter.vl_velocity_demand, Parameter.vl_control_effort, Parameter.vl_velocity_min_max_amount, Parameter.vl_velocity_acceleration, Parameter.vl_velocity_deceleration, Parameter.vl_dimension_factor, Parameter.vl_pole_number),
        TORQUE_PROFILE("4", Parameter.target_torque, Parameter.torque_actual_value, Parameter.motor_rated_current, Parameter.torque_slope, Parameter.torque_profile_type);

        private final String modeInHexa;
        private final Parameter[] parameters;

        private DigitaxMode(String modeToHexa, Parameter ... params) {
            this.modeInHexa = modeToHexa;
            this.parameters = (Parameter[])params.clone();
        }

        String getModeInHexa() {
            return this.modeInHexa;
        }

        public static DigitaxMode getMode(String hexa) {
            DigitaxMode[] modes = DigitaxMode.values();
            DigitaxMode digitaxMode = null;
            for (DigitaxMode mode : modes) {
                if (!mode.getModeInHexa().equals(hexa.toUpperCase())) continue;
                digitaxMode = mode;
            }
            if (digitaxMode == null) {
                throw new IllegalArgumentException(hexa + ": this mode doesn't exist in DigitaxVariator.DigitaxMode ENUM");
            }
            return digitaxMode;
        }
    }

    public static enum Parameter {
        target_torque("6071", "00", "2", true),
        torque_actual_value("6077", "00", "2", true),
        motor_rated_current("6075", "00", "4", false),
        torque_slope("6087", "00", "4", true),
        torque_profile_type("6088", "00", "1", true),
        vl_target_velocity("6042", "00", "2", true),
        vl_velocity_demand("6043", "00", "2", true),
        vl_control_effort("6044", "00", "2", true),
        vl_velocity_min_max_amount("6046", "00", "4", false),
        vl_velocity_acceleration("6048", "01", "4", true),
        vl_velocity_deceleration("6049", "02", "4", true),
        vl_dimension_factor("604C", "00", "4", true),
        vl_pole_number("604D", "00", "1", false);

        private final String index;
        private final String subindex;
        private final String size;
        private final boolean signed;

        private Parameter(String index, String subindex, String size, boolean signed) {
            this.index = index;
            this.subindex = subindex;
            this.size = size;
            this.signed = signed;
        }

        public String display() {
            StringBuilder sb = new StringBuilder(this.toString());
            sb.append("/index=").append(this.index);
            sb.append("/subindex=").append(this.subindex);
            sb.append("/size=").append(this.size).append(" bytes");
            if (this.signed) {
                sb.append("/SIGNED");
            } else {
                sb.append("/UNSIGNED");
            }
            return sb.toString();
        }
    }
}

