/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.Led;

public class CanOpenLED
extends Module
implements Led {
    private CanOpenDAC dac;
    private String dacName;
    private int outputNumero;

    public CanOpenDAC getDac() {
        return this.dac;
    }

    public void setDac(CanOpenDAC dac) {
        this.dac = dac;
    }

    public String getDacName() {
        return this.dacName;
    }

    public void setDacName(String dacName) {
        this.dacName = dacName;
    }

    public int getOutputNumero() {
        return this.outputNumero;
    }

    public void setOutputNumero(int outputNumero) {
        this.outputNumero = outputNumero;
    }

    public void initModule() {
        this.dac = (CanOpenDAC)this.getComponentByName(this.dacName);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Turn on LED to please Emmanuel.")
    public String turnON() throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        this.dac.writeAnalogOutput(this.outputNumero, 14000);
        return "LED is turn ON";
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Turn off LED to please Emmanuel.")
    public String turnOFF() throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        this.dac.writeAnalogOutput(this.outputNumero, 0);
        return "LED is turn OFF";
    }

    public String sentCurrent(String hexa) throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        this.dac.writeAnalogOutput(this.outputNumero, Integer.parseInt(hexa, 16));
        return "LED is turn ON";
    }
}

