/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.LoaderDisconnectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;

public class APCTestBench2CanBusMain
extends MainModule {
    protected BridgeToHardware bridgeToLoader;
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;
    public double temperature;
    private boolean ledOn;

    public APCTestBench2CanBusMain(String aName, int aTickMillis, BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(aName, aTickMillis, bridge);
        this.bridgeToLoader = bridgeToLoader;
    }

    public APCTestBench2CanBusMain(String aName, int aTickMillis, BridgeToHardware bridge, BridgeToHardware bridgeToLoader, Thermometer thermometer, CanOpenLED led, CanOpenLED fakeLed, Thermometer fakeSensor) {
        super(aName, aTickMillis, bridge);
        this.bridgeToLoader = bridgeToLoader;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
        this.ledOn = false;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the changer is connected.")
    public boolean isChangerConnected() {
        return this.bridge.isCWrapperConnected();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isCWrapperConnected();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the changer is ready.")
    public boolean isChangerReady() {
        return this.bridge.isHardwareReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the loader is ready.")
    public boolean isLoaderReady() {
        return this.bridgeToLoader.isHardwareReady();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Disconnect the (fake) loader.")
    public void disconnectLoader() throws InterruptedException {
        this.bridgeToLoader.getTcpProxy().disconnectHardware();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Connect the (fake) loader.")
    public void connectLoader() throws BadCommandException, HardwareException {
        this.bridgeToLoader.getTcpProxy().connectHardware();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read temperature.")
    public double readTemperature() throws FcsHardwareException, LoaderDisconnectedException {
        try {
            return this.thermometer.readTemperature();
        }
        catch (FcsHardwareException ex) {
            if (ex instanceof HardwareNotDetectedException) {
                throw new LoaderDisconnectedException(ex.getMessage());
            }
            return 0.0;
        }
    }

    public void tick() {
        try {
            if (this.ledOn) {
                this.turnOffLED();
            } else {
                this.turnOnLED();
            }
        }
        catch (SDORequestException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + (Object)((Object)ex)));
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + (Object)((Object)ex)));
            this.getSubsystem().raiseAlert(new Alert(this.name, ex.toString()), AlertState.ALARM);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Turn ON the Led.")
    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        this.led.turnON();
        this.ledOn = true;
        return "LED is turned ON";
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Turn OFF the Led.")
    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException, FcsHardwareException {
        this.led.turnOFF();
        this.ledOn = false;
        return "LED is turned OFF";
    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
    }
}

