/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.AutochangerHandler;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;

public class SftMainModule
extends MainModule
implements AutochangerHandler {
    private final Filter dummyFilter;
    private SftCarouselModule carousel;
    private SftAutoChangerModule autochanger;
    private boolean filterLocated;

    public SftMainModule(String aName, int aTickMillis, BridgeToHardware bridge, Filter dummyFilter) {
        super(aName, aTickMillis, bridge);
        this.dummyFilter = dummyFilter;
    }

    public Filter getDummyFilter() {
        return this.dummyFilter;
    }

    @Override
    public boolean isAutochangerHoldingFilterAtSTANDBY() {
        return this.autochanger.isHoldingFilterAtStandby();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (SftCarouselModule)((Object)this.getComponentByName("carousel"));
        this.autochanger = (SftAutoChangerModule)((Object)this.getComponentByName("autochanger"));
        this.hardwareReady = false;
        this.filterLocated = false;
    }

    public void start() {
        if (this.isHardwareReady() && !this.filterLocated) {
            try {
                this.locateFilter();
                this.filterLocated = true;
                FCSCst.FCSLOG.info((Object)"Filter has been located. Hardware is ready to receive commands.");
                FCSCst.FCSLOG.debug((Object)"DEBUGGING");
            }
            catch (BadCommandException | ErrorInCommandExecutionException | FcsHardwareException ex) {
                this.filterLocated = false;
                FCSCst.FCSLOG.error((Object)ex);
                String errorMsg = ": couldn't locate filters.";
                this.getSubsystem().raiseAlert(new Alert("FCS005:" + this.name, errorMsg), AlertState.ALARM);
            }
        }
    }

    @Command(level=0, description="Read the sensors and update location of the filter and state of Carousel and Autochanger.", type=Command.CommandType.QUERY)
    public void locateFilter() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        FCSCst.FCSLOG.debug((Object)"MODE DEBUG");
        this.carousel.updateClampsStateWithSensors();
        if (this.carousel.getClampXminus().getClampState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER) || this.carousel.getClampXminus().getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            this.carousel.getSocketByName("socket1").putFilterOnSocket(this.dummyFilter);
        }
        this.autochanger.updateLatchesStateWithSensors();
        if (!this.autochanger.isTrucksEmpty()) {
            this.autochanger.setFilterOnTrucks(this.dummyFilter);
        }
        this.autochanger.updateTrucksLocationWithSensors();
    }

    @Command(level=1, description="Check if the carousel is ready to unlock the clamps in a safe way for the filter.", type=Command.CommandType.QUERY, alias="checkUnlock")
    public void checkPreConditionsForUnlockClamps() throws FcsHardwareException, BadCommandException, ErrorInCommandExecutionException {
        this.updateStateWithSensors();
        if (this.carousel.isHoldingFilterAtStandby() && !this.autochanger.isHoldingFilterAtStandby()) {
            throw new ErrorInCommandExecutionException("Can't unlock clamps if filter is not held by autochanger.");
        }
    }

    @Command(level=1, description="To display at a console the status of the hardware.", type=Command.CommandType.QUERY)
    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getSubsystem().getName()).append("\n  ");
        FCSCst.FCSLOG.info((Object)("Carousel status=" + this.carousel.toString()));
        sb.append(this.carousel.toString());
        sb.append("\n  ");
        sb.append("clampXminus status=");
        sb.append(this.carousel.getClampXminus().toString());
        sb.append("\n  ");
        sb.append("clampXplus status=");
        sb.append(this.carousel.getClampXplus().toString());
        sb.append("\n  ");
        FCSCst.FCSLOG.info((Object)("autochanger status=" + this.autochanger.toString()));
        sb.append(this.autochanger.toString());
        sb.append("\n  ");
        sb.append("latchXminus status=");
        sb.append(this.autochanger.getLatchXminus().toString());
        sb.append("\n  ");
        sb.append("latchXplus status=");
        sb.append(this.autochanger.getLatchXplus().toString());
        sb.append("\n  ");
        return sb.toString();
    }

    @Command(level=1, description="Move the hardware to the initial state : ", type=Command.CommandType.ACTION)
    public String goToInitialState() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.updateStateWithSensors();
        String ack = "Hardware is at initial state and ready for a sequence1";
        if (this.carousel.isHoldingFilterAtStandby()) {
            if (this.autochanger.isAtStandback()) {
                return ack;
            }
            if (this.autochanger.isAtStandby()) {
                FCSCst.FCSLOG.info((Object)"=======> Autochanger moving back empty to online position.");
                this.autochanger.ungrabFilterAtStandby();
                return ack;
            }
            if (this.autochanger.isTrucksEmpty()) {
                return this.autochanger.goToStandback();
            }
            return "Autochanger trucks are in the midle, but not empty, I don't know what to do.";
        }
        if (this.autochanger.isHoldingFilterAtStandback()) {
            if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
                this.carousel.releaseClamps();
            }
            FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
            this.autochanger.moveFilterToStandby(this.dummyFilter);
            FCSCst.FCSLOG.info((Object)"=======> Carousel is grabbing filter at standby position.");
            this.carousel.grabFilterAtStandby(this.getDummyFilter());
            FCSCst.FCSLOG.info((Object)"=======> Autochanger moving back empty to online position.");
            this.autochanger.ungrabFilterAtStandby();
            return ack;
        }
        if (this.autochanger.isHoldingFilterAtStandby()) {
            FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move loaded with the filter to standback position.");
            this.autochanger.moveFilterToStandback(this.dummyFilter);
            FCSCst.FCSLOG.info((Object)"=======> Carousel about to release Clamps.");
            this.carousel.releaseClamps();
            FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
            this.autochanger.moveFilterToStandby(this.dummyFilter);
            FCSCst.FCSLOG.info((Object)"=======> Carousel is grabbing filter at standby position.");
            this.carousel.grabFilterAtStandby(this.getDummyFilter());
            FCSCst.FCSLOG.info((Object)"=======> Autochanger moving back empty to online position.");
            this.autochanger.ungrabFilterAtStandby();
            return ack;
        }
        if (!this.autochanger.isAtStandback() && !this.autochanger.isAtStandby()) {
            return "Autochanger trucks are in the midle, I don't know what to do.";
        }
        return "Nobody holds the filter : I don't know how to go to initial state.";
    }

    @Command(level=0, description="The world famous sequence 1", type=Command.CommandType.ACTION, alias="es1")
    public String executeSequence1() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move empty to standby position.");
        this.autochanger.grabFilterAtStandby(this.dummyFilter);
        if (this.haltRequired.get()) {
            return this.getName() + " Execution of Sequence1 HALTED at step 1";
        }
        FCSCst.FCSLOG.info((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.ungrabFilterAtStandby(this.dummyFilter);
        if (this.haltRequired.get()) {
            return this.getName() + " Execution of Sequence1 HALTED at step 2";
        }
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move loaded with the filter to standback position.");
        this.autochanger.moveFilterToStandback(this.dummyFilter);
        FCSCst.FCSLOG.info((Object)"=======> Carousel about to release Clamps.");
        this.carousel.releaseClamps();
        if (this.haltRequired.get()) {
            return this.getName() + " Execution of Sequence1 HALTED at step 3";
        }
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
        this.autochanger.moveFilterToStandby(this.dummyFilter);
        FCSCst.FCSLOG.info((Object)"=======> Carousel is grabbing filter at standby position.");
        this.carousel.grabFilterAtStandby(this.getDummyFilter());
        if (this.haltRequired.get()) {
            return this.name + " Execution of Sequence1 HALTED at step 4";
        }
        FCSCst.FCSLOG.info((Object)"=======> Autochanger moving back empty to online position.");
        this.autochanger.ungrabFilterAtStandby();
        FCSCst.FCSLOG.info((Object)"=======> Execution of Sequence1 completed.");
        return "Execution of Sequence1 completed";
    }

    @Command(level=0, description="The world famous sequence 1 (with number of repetitions)", type=Command.CommandType.ACTION, alias="es1")
    public String executeSequence1(@Argument(name="nExecutions", description="Number of executions") int nb) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        if (nb < 1 || nb > 20000) {
            throw new IllegalArgumentException("nb has to be comprise between 1 and 20000");
        }
        for (int i = 1; i < nb + 1; ++i) {
            FCSCst.FCSLOG.info((Object)("===========================BEGIN execution Sequence1 nb=" + i + " ================"));
            this.executeSequence1();
            FCSCst.FCSLOG.info((Object)("===========================END execution Sequence1 nb=" + i + " ================"));
        }
        return this.getName() + ":" + nb + " executions of Sequence1 completed";
    }

    boolean autochangerLatchesAreLocked() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n").append(this.carousel.toString());
        sb.append("\n").append(this.autochanger.toString());
        return sb.toString();
    }

    @Override
    @Command(level=1, description="Read the sensors and update the state of the carousel and the autochanger.", type=Command.CommandType.QUERY)
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        super.updateStateWithSensors();
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    public SftCarouselModule getCarouselModule() {
        return this.carousel;
    }

    public SftAutoChangerModule getAutoChangerModule() {
        return this.autochanger;
    }
}

