/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftFilterLatchModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.TruckModule;

public class SftAutoChangerModule
extends BasicAutoChangerModule {
    protected SftTruckMotor sftTrucksMotor;
    private long timeToConfortAPosition;
    private long timeToGoToStandby;
    private long timeToGoToStandback;

    public SftAutoChangerModule(String moduleName, int aTickMillis, SftFilterLatchModule latchXminus, SftFilterLatchModule latchXplus, TruckModule truckXminus, TruckModule truckXplus, String railsSensorsDIOName, String filterSensorsDIOName, SftTruckMotor sftTrucksMotor, long timeToConfortAPosition, long timeToGoToStandby, long timeToGoToStandback) {
        super(moduleName, aTickMillis, latchXminus, latchXplus, truckXminus, truckXplus, railsSensorsDIOName, filterSensorsDIOName);
        this.sftTrucksMotor = sftTrucksMotor;
        this.timeToConfortAPosition = timeToConfortAPosition;
        this.timeToGoToStandby = timeToGoToStandby;
        this.timeToGoToStandback = timeToGoToStandback;
    }

    public SftTruckMotor getSftTrucksMotor() {
        return this.sftTrucksMotor;
    }

    public void setSftTrucksMotor(SftTruckMotor sftTrucksMotor) {
        this.sftTrucksMotor = sftTrucksMotor;
    }

    public long getTimeToConfortAPosition() {
        return this.timeToConfortAPosition;
    }

    public long getTimeToGoToStandback() {
        return this.timeToGoToStandback;
    }

    public long getTimeToGoToStandby() {
        return this.timeToGoToStandby;
    }

    @ConfigChanger
    public void setTimeToConfortAPosition(long timeToConfortAPosition) {
        this.timeToConfortAPosition = timeToConfortAPosition;
    }

    @ConfigChanger
    public void setTimeToGoToStandby(long timeToGoToStandby) {
        this.timeToGoToStandby = timeToGoToStandby;
    }

    @ConfigChanger
    public void setTimeToGoToStandback(long timeToGoToStandback) {
        this.timeToGoToStandback = timeToGoToStandback;
    }

    @Override
    public boolean isMovingToStandback() {
        return this.sftTrucksMotor.isMovingToStandback();
    }

    @Override
    public boolean isMovingToStandby() {
        return this.sftTrucksMotor.isMovingToStandby();
    }

    @Override
    public boolean isMoving() {
        return this.isMovingToStandback() || this.isMovingToStandby();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void locateTrucks() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Command(level=1, description="Go to STANDBACK", type=Command.CommandType.ACTION)
    public String goToStandback() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        this.checkPreConditionsForTrucksMotion();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            return this.getName() + " trucks already at standback location";
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.ERROR)) {
            FCSLOG.error((Object)(this.getName() + " Cannot execute goToStandback : ERROR in reading rails sensors"));
            throw new BadCommandException(this.getName() + " Cannot execute goToStandback : ERROR in reading rails sensors.");
        }
        if (this.isAtStandby()) {
            if (!this.isTrucksEmpty() && this.getLatchesState() == FcsEnumerations.LockStatus.LOCKED) {
                this.carousel.updateClampsStateWithSensors();
                if (this.carousel.isHoldingFilterAtStandby()) {
                    throw new BadCommandException(this.getName() + " can't move filter to standback because the carousel is holding the filter at standby.");
                }
            }
            FCSLOG.debug((Object)(this.getName() + ": The position is being conforted"));
            this.sftTrucksMotor.moveToStandby();
            try {
                Thread.sleep(this.timeToConfortAPosition);
            }
            catch (InterruptedException ex) {
                FCSLOG.debug((Object)ex);
            }
        }
        FCSLOG.info((Object)(this.getName() + " IS GOING TO STANDBACK POSITION"));
        this.sftTrucksMotor.moveToStandback();
        try {
            Thread.sleep(this.timeToGoToStandback);
        }
        catch (InterruptedException ex) {
            FCSLOG.debug((Object)ex);
        }
        this.sftTrucksMotor.off();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            FCSLOG.debug((Object)("====> " + this.getName() + "  IS AT STANDBACK POSITION"));
            return this.getName() + " IS AT STANDBACK POSITION";
        }
        throw new ErrorInCommandExecutionException(this.getName() + "could not go to STANDBACK POSITION");
    }

    @Override
    @Command(level=1, description="Go to STANDBY.", type=Command.CommandType.ACTION)
    public String goToStandby() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        this.checkPreConditionsForTrucksMotion();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandby()) {
            return this.getName() + "trucks already at standby position";
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN)) {
            FCSLOG.error((Object)(this.getName() + " Cannot execute goToStandby : Trucks are between standback and standby location."));
            throw new BadCommandException(this.getName() + " Cannot execute goToStandby : Trucks are between standback and standby location.");
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.ERROR)) {
            FCSLOG.error((Object)(this.getName() + " Cannot execute goToStandby : ERROR in reading rails sensors"));
            throw new BadCommandException(this.getName() + " Cannot execute goToStandby : ERROR in reading rails sensors.");
        }
        if (this.isAtStandback()) {
            this.sftTrucksMotor.moveToStandback();
            try {
                FCSLOG.debug((Object)(this.getName() + ": Waiting for the position to be conforted"));
                Thread.sleep(this.timeToConfortAPosition);
            }
            catch (InterruptedException ex) {
                FCSLOG.error((Object)ex);
            }
        }
        FCSLOG.info((Object)(this.getName() + " IS GOING TO STANDBY POSITION"));
        this.sftTrucksMotor.moveToStandby();
        try {
            FCSLOG.debug((Object)(this.getName() + ": Waiting for the trucks to go to STANDBY"));
            Thread.sleep(this.timeToGoToStandby);
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)ex);
        }
        this.sftTrucksMotor.off();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandby()) {
            FCSLOG.debug((Object)("====> " + this.getName() + "  IS AT STANDBY POSITION"));
            return this.getName() + " IS AT STANDBY POSITION";
        }
        throw new ErrorInCommandExecutionException(this.getName() + " could not go to STANDBY POSITION");
    }

    @Override
    public String moveFilterToStandback(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        if (this.isTrucksEmpty()) {
            throw new BadCommandException(this.getName() + " unable to moveFilterToStandback: Autochanger is empty");
        }
        this.goToStandback();
        this.updateLatchesStateWithSensors();
        this.publishDataAndNotifyObservers();
        return this.getName() + ": " + aFilter.getName() + " is at standback position.";
    }

    @Override
    public String moveFilterToStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        if (this.isTrucksEmpty()) {
            throw new BadCommandException(this.getName() + "/moveFilterToStandby: Autochanger is empty");
        }
        this.carousel.updateClampsStateWithSensors();
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new BadCommandException(this.getName() + "can't move a filter to STANDBY because carousel is not ready to grab a filter.");
        }
        this.goToStandby();
        this.updateLatchesStateWithSensors();
        this.publishDataAndNotifyObservers();
        return this.getName() + ": " + aFilter.getName() + " is at standby position.";
    }

    public String goToPosition(double trucksPositionOnline) throws BadCommandException {
        throw new UnsupportedOperationException("Not in single-filter-test.");
    }

    public double getTrucksPosition() {
        throw new UnsupportedOperationException("Not supported in single-filter-test.");
    }

    public String moveFilterToOnline(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        return this.moveFilterToStandback(filter);
    }

    @Override
    @Command(level=1, description="Read sensors and update latches and trucks state", type=Command.CommandType.QUERY)
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException {
        this.updateLatchesStateWithSensors();
        this.updateTrucksLocationWithSensors();
        this.publishData();
        if (this.getLatchXminus().getPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceInLatchStatus.NOFILTER) && this.getLatchXplus().getPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceInLatchStatus.NOFILTER)) {
            this.setTrucksEmpty(true);
            this.setFilterOnTrucks(null);
        }
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

