/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClamp;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampFilterPresenceSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCompactIOModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

public class SimuTruckMotorModule
extends SftTruckMotor {
    private SftAutoChangerModule autochanger;
    private SimuCarouselClamp clampXminus;
    private SimuCarouselClamp clampXplus;

    public SimuTruckMotorModule(String name, int tickMillis) {
        super(name, tickMillis);
    }

    public void initModule() {
        this.autochanger = (SftAutoChangerModule)((Object)this.getComponentByName("autochanger"));
        this.clampXminus = (SimuCarouselClamp)((Object)this.getComponentByName("clampXminus"));
        this.clampXplus = (SimuCarouselClamp)((Object)this.getComponentByName("clampXplus"));
    }

    @Override
    public String moveToStandback() throws CanOpenException {
        if (this.autochanger.isAtStandby()) {
            this.setMovingToStandback(true);
            long timeToGo = this.autochanger.getTimeToGoToStandback() / 10L;
            try {
                FCSCst.FCSLOG.debug((Object)(this.getName() + ": Waiting for the motor to go to STANDBACK"));
                Thread.sleep(timeToGo);
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.debug((Object)ex);
            }
            this.setMovingToStandback(false);
            SimuCompactIOModule simuRailsSensors = (SimuCompactIOModule)this.autochanger.getRailsSensorsDIO();
            simuRailsSensors.setHexaValue("50");
            SimuCompactIOModule simuFilterSensors = (SimuCompactIOModule)this.autochanger.getFilterSensorsDIO();
            if (this.autochanger.isTrucksEmpty()) {
                simuFilterSensors.simulateFilterPresenceInLatches("0");
            } else {
                ((SimuClampFilterPresenceSensor)this.clampXminus.getFilterPresenceSensor()).simulateNoFilter(this.clampXminus);
                ((SimuClampFilterPresenceSensor)this.clampXplus.getFilterPresenceSensor()).simulateNoFilter(this.clampXplus);
                FCSCst.FCSLOG.debug((Object)"====> END OF moveToStandback");
            }
        }
        return "Trucks are At Standback.";
    }

    @Override
    public String moveToStandby() throws CanOpenException {
        if (this.autochanger.isAtStandback()) {
            this.setMovingToStandby(true);
            long timeToGo = this.autochanger.getTimeToGoToStandby();
            try {
                FCSCst.FCSLOG.debug((Object)(this.getName() + ": Waiting for the motor to go to STANDBY"));
                Thread.sleep(timeToGo);
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.debug((Object)ex);
            }
            this.setMovingToStandby(false);
            SimuCompactIOModule simuRailsSensor = (SimuCompactIOModule)this.autochanger.getRailsSensorsDIO();
            simuRailsSensor.setHexaValue("A0");
            SimuCompactIOModule simuFilterSensors = (SimuCompactIOModule)this.autochanger.getFilterSensorsDIO();
            if (this.autochanger.isTrucksEmpty()) {
                simuFilterSensors.simulateFilterPresenceInLatches("1");
            } else {
                ((SimuClampFilterPresenceSensor)this.clampXminus.getFilterPresenceSensor()).simulateFilterIsLockable(this.clampXminus);
                ((SimuClampFilterPresenceSensor)this.clampXplus.getFilterPresenceSensor()).simulateFilterIsLockable(this.clampXplus);
                ((SimuClampLockSensor)this.clampXminus.getLockSensor()).simulateClampIsLOCKED(this.clampXminus);
                ((SimuClampLockSensor)this.clampXplus.getLockSensor()).simulateClampIsLOCKED(this.clampXplus);
            }
        }
        return "Trucks are At Standby.";
    }

    @Override
    public String off() throws CanOpenException {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return "Trucks motor is OFF";
    }
}

