/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.security.SecureRandom;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;

public class SimuSensor14bits
extends Sensor14bits {
    private int value1 = 0;
    private int value2 = Short.MAX_VALUE;
    private final SecureRandom randomGenerator = new SecureRandom();

    public SimuSensor14bits(String moduleName, int aTickMillis, int aValue) {
        super(moduleName, aTickMillis);
        this.value = aValue;
    }

    SimuSensor14bits(String moduleName, int aTickMillis, int aValue1, int aValue2) {
        super(moduleName, aTickMillis);
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    void setNewRange(int aValue1, int aValue2) {
        if (aValue2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException(this.name + "aValue2=" + aValue2 + " Can't be >" + Short.MAX_VALUE);
        }
        if (aValue1 < 0) {
            throw new IllegalArgumentException(this.name + " aValue1=" + aValue1 + " Can't be <" + 0);
        }
        if (aValue2 < aValue1) {
            throw new IllegalArgumentException(this.name + " aValue1=" + aValue1 + " aValue2=" + aValue2 + "we must have: aValue1<aValue2");
        }
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    @Override
    public int readNewValue() {
        if (this.value2 > 0) {
            int n = this.randomGenerator.nextInt(this.value2);
            if (n > this.value1) {
                return n;
            }
            BigDecimal bd = new BigDecimal(this.value1 + n * (this.value2 - this.value1) / this.value2);
            return bd.intValue();
        }
        String msg = this.getName() + ": ERROR in readNewValue: value2 should be positive";
        throw new IllegalArgumentException(msg);
    }

    @Override
    public int updateValue(PDOStorage pdoStorage) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

