/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderCarrierController
extends SimuEPOSControllerModule {
    private LoaderCarrierModule carrier;
    private SimuLoaderPlutoGateway plutoGateway;

    public SimuLoaderCarrierController(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carrier = (LoaderCarrierModule)((Object)this.getComponentByName("carrier"));
        this.plutoGateway = (SimuLoaderPlutoGateway)this.getComponentByName("plutoGateway");
    }

    @Override
    public void writeTargetPosition(int positionToReached) throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.debug((Object)"loader carrier is moving.");
        FCSCst.FCSLOG.debug((Object)(this.name + "=>position intitiale=" + this.position));
        int stepsNB = 20;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            try {
                this.position = positionInitiale + i * step;
                this.carrier.updatePosition();
                if (this.position == this.carrier.getHandoffPosition()) {
                    FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (this.position == this.carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                this.carrier.updateStateWithSensors();
                this.carrier.publishData();
                FCSCst.FCSLOG.debug((Object)(this.name + "i=" + i + ",position=" + this.position));
                try {
                    Thread.sleep(500L);
                    if (!this.carrier.getHaltRequired().get()) continue;
                    FCSCst.FCSLOG.debug((Object)(this.name + " STOP simulated carrrier motion."));
                    return;
                }
                catch (InterruptedException ex) {
                    throw new BadCommandException(this.name + " sleep was interrupted.");
                }
            }
            catch (FcsHardwareException ex) {
                FCSCst.FCSLOG.error((Object)ex);
                throw new BadCommandException(ex.getMessage());
            }
        }
        this.position = this.targetPosition;
        if (this.position == this.carrier.getHandoffPosition()) {
            FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (this.position == this.carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }
    }
}

