/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCompactIOModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuNumericSensor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuatorModule;

public class SimuLatchActuatorModule
extends LatchActuatorModule {
    private SimuCompactIOModule simuDIO;
    private final String filterSensorsDIOName;

    public SimuLatchActuatorModule(String aName, int aTickMillis, double currentLimitInVolt, double speedVoltageInVolt, int speedVoltageMinValue, int speedVoltageMaxValue, String filterSensorsDIOName) {
        super(aName, aTickMillis, currentLimitInVolt, speedVoltageInVolt, speedVoltageMinValue, speedVoltageMaxValue);
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public void initModule() {
        this.simuDIO = (SimuCompactIOModule)this.getComponentByName(this.filterSensorsDIOName);
    }

    @Override
    public String open() throws BadCommandException, ErrorInCommandExecutionException {
        int unlockSensorInputNumero;
        int lockSensorInputNumero;
        if (this.getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((SimuNumericSensor)((Object)this.getComponentByName("lockSensorLatchXminus"))).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor)((Object)this.getComponentByName("unlockSensorLatchXminus"))).getInputNumero();
        } else if (this.getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((SimuNumericSensor)((Object)this.getComponentByName("lockSensorLatchXplus"))).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor)((Object)this.getComponentByName("unlockSensorLatchXplus"))).getInputNumero();
        } else {
            throw new ErrorInCommandExecutionException(this.getName() + " Can't retrieve the latch for which I work.");
        }
        this.simuDIO.replaceDigitalValues(lockSensorInputNumero, "0", unlockSensorInputNumero, "1");
        FCSCst.FCSLOG.debug((Object)(this.getName() + " is OPEN"));
        return this.getName() + " is OPEN";
    }

    @Override
    public String close() throws BadCommandException, ErrorInCommandExecutionException {
        int unlockSensorInputNumero;
        int lockSensorInputNumero;
        if (this.getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((SimuNumericSensor)((Object)this.getComponentByName("lockSensorLatchXminus"))).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor)((Object)this.getComponentByName("unlockSensorLatchXminus"))).getInputNumero();
        } else if (this.getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((SimuNumericSensor)((Object)this.getComponentByName("lockSensorLatchXplus"))).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor)((Object)this.getComponentByName("unlockSensorLatchXplus"))).getInputNumero();
        } else {
            throw new ErrorInCommandExecutionException(this.getName() + " Can't retrieve the latch for which I work.");
        }
        this.simuDIO.replaceDigitalValues(lockSensorInputNumero, "1", unlockSensorInputNumero, "0");
        return this.getName() + " is CLOSED";
    }

    @Override
    public String powerOff() throws BadCommandException, ErrorInCommandExecutionException {
        return this.getName() + " is OFF";
    }
}

