/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.io.Serializable;
import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public abstract class SimuEPOSControllerModule
extends CanOpenDevice
implements EPOSController {
    protected boolean turnedOff;
    private boolean enabled;
    private boolean enabledToPublish;
    protected EPOSEnumerations.EposMode mode;
    protected int targetPosition;
    protected int position;
    protected int ssiPosition;
    protected int targetCurrent;
    protected int actualCurrent;
    private final Map<String, Integer> paramsForHoming;
    private final Map<String, Integer> paramsForProfilePosition;
    private final Map<String, Integer> paramsForCurrent;
    private boolean inError;
    private String[] errorHistory;
    private String errorRegister;

    public SimuEPOSControllerModule(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.paramsForHoming = paramsForHoming;
        this.paramsForProfilePosition = paramsForProfilePosition;
        this.paramsForCurrent = paramsForCurrent;
        this.position = 0;
        this.inError = false;
        this.turnedOff = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new String[0];
        this.mode = EPOSEnumerations.EposMode.PROFILE_POSITION;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="For simulator only : Update position with a position given as argument.")
    public void setPosition(int actualPosition) {
        this.position = actualPosition;
    }

    public void setActualCurrent(int actualCurrent) {
        this.actualCurrent = actualCurrent;
    }

    @Override
    public boolean isEnabledToPublish() {
        return this.enabledToPublish;
    }

    @Override
    public boolean isTurnedOff() {
        return this.turnedOff;
    }

    @Override
    public Map<String, Integer> getParamsForHoming() {
        return this.paramsForHoming;
    }

    @Override
    public Map<String, Integer> getParamsForProfilePosition() {
        return this.paramsForProfilePosition;
    }

    @Override
    public Map<String, Integer> getParamsForCurrent() {
        return this.paramsForCurrent;
    }

    @Override
    public boolean isInError() {
        return this.inError;
    }

    @Override
    public String getErrorRegister() {
        return this.errorRegister;
    }

    @Override
    public String[] getErrorHistory() {
        if (this.errorHistory == null) {
            return new String[0];
        }
        return (String[])this.errorHistory.clone();
    }

    @Override
    public String getModeInString() {
        return this.mode.toString();
    }

    @Override
    public boolean isParametersOK() {
        return true;
    }

    @Override
    public String initializeAndCheckHardware() throws FcsHardwareException {
        super.initializeAndCheckHardware();
        this.publishData();
        return this.name + " is INITIALIZED.";
    }

    public String changeMode(String modeInString) throws SDORequestException {
        EPOSEnumerations.EposMode newMode = EPOSEnumerations.EposMode.valueOf((String)modeInString.trim().toUpperCase());
        return this.changeMode(newMode);
    }

    @Override
    public String changeMode(EPOSEnumerations.EposMode newMode) throws SDORequestException {
        this.mode = newMode;
        return this.getName() + " mode changed to=" + newMode.toString();
    }

    @Override
    public void defineAbsolutePosition(int position) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        this.position = position;
    }

    @Override
    public void disable() throws SDORequestException, ShortResponseToSDORequestException {
        this.enabled = true;
        this.enabledToPublish = true;
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) throws SDORequestException, ErrorInCommandExecutionException {
    }

    @Override
    public String writeParameterInHexa(EPOSEnumerations.Parameter parameter, String string) throws SDORequestException {
        return this.name + " " + parameter.toString() + " set to value in HEXA=" + string;
    }

    @Override
    public void writeTargetPosition(int position) throws BadCommandException, SDORequestException, FcsHardwareException {
        this.position = position;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) throws SDORequestException {
    }

    @Override
    public void writeCurrent(int aValue) throws BadCommandException, SDORequestException, FcsHardwareException {
        this.turnedOff = false;
        this.actualCurrent = aValue;
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.turnedOff = true;
        return this.name + " is OFF";
    }

    @Override
    public boolean isTargetPositionReached(int targetPosition) {
        return this.position == targetPosition;
    }

    @Override
    public int readPosition() throws SDORequestException {
        return this.position;
    }

    @Override
    public int readSSIPosition() throws SDORequestException, ShortResponseToSDORequestException {
        return this.ssiPosition;
    }

    @Override
    public String enable() throws SDORequestException {
        this.enabled = true;
        return this.name + "IS ENABLED";
    }

    @Override
    public int readCurrent() throws BadCommandException, SDORequestException {
        return this.actualCurrent;
    }

    @Override
    public EPOSEnumerations.EposMode readMode() throws SDORequestException {
        return this.mode;
    }

    @Override
    public int getMaxCurrent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMinCurrent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxSpeed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMinPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void quickStop() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int readNumberOfErrors() throws SDORequestException, ShortResponseToSDORequestException {
        return 0;
    }

    @Override
    public String displayErrorHistory() throws SDORequestException, ShortResponseToSDORequestException {
        return "No ERROR";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clear faults on the controller.")
    public void faultReset() throws SDORequestException {
        this.writeControlWord("80");
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)"faultReset"));
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new String[0];
        this.publishData();
    }

    @Override
    public int readProfileVelocity() throws SDORequestException, ShortResponseToSDORequestException {
        return 0;
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode mode) throws SDORequestException, ShortResponseToSDORequestException {
        return this.name + ":no parameter to read.";
    }

    @Override
    public void checkParameters(String modeInString) throws HardwareException, SDORequestException, ShortResponseToSDORequestException {
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) throws HardwareException, SDORequestException, ShortResponseToSDORequestException {
    }

    @Override
    public void writeControlWord(String f) throws SDORequestException {
        FCSCst.FCSLOG.debug((Object)(this.name + "writeControlWord :" + f));
    }

    @Override
    public String shutdown() throws SDORequestException {
        FCSCst.FCSLOG.debug((Object)(this.name + " is SHUTDOWN"));
        return this.name + " is SHUTDOWN";
    }

    @Override
    public boolean isEnabled() throws SDORequestException {
        return this.enabled;
    }

    @Override
    public boolean checkTargetReached() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void releaseBrake() throws SDORequestException, ShortResponseToSDORequestException {
        FCSCst.FCSLOG.debug((Object)(this.name + " brake is released."));
    }

    @Override
    public void switchOnEnableOperation() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void activateBrake() throws SDORequestException, ShortResponseToSDORequestException {
        FCSCst.FCSLOG.debug((Object)(this.name + " brake is activated."));
    }

    public StatusDataPublishedByEPOSController getStatusData() {
        StatusDataPublishedByEPOSController status = FcsUtils.createStatusDataPublishedByEPOSController(this);
        return status;
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="refreshGUI", description="Publish data for the controller on the status bus.")
    public void publishData() {
        StatusDataPublishedByEPOSController status = this.getStatusData();
        KeyValueData kvd = new KeyValueData(this.name, (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

