/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClamp;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuCarouselClampController
extends SimuEPOSControllerModule {
    private CarouselModule carousel;

    public SimuCarouselClampController(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (CarouselModule)((Object)this.getComponentByName("carousel"));
        this.mode = EPOSEnumerations.EposMode.CURRENT;
    }

    @Override
    public void writeCurrent(int currentValue) throws BadCommandException, SDORequestException {
        SimuCarouselClamp clamp;
        FCSCst.FCSLOG.debug((Object)(this.getName() + "==========> ACTUATOR ON"));
        if (this.name.contains("Xminus")) {
            clamp = (SimuCarouselClamp)this.carousel.getClampXminus();
        } else if (this.name.contains("Xplus")) {
            clamp = (SimuCarouselClamp)this.carousel.getClampXplus();
        } else {
            throw new BadCommandException(this.name + ":couldn't find the clamp to unlock");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        this.publishData();
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        SimuCarouselClamp clamp;
        FCSCst.FCSLOG.debug((Object)(this.getName() + "==========> ACTUATOR OFF"));
        if (this.getName().contains("Xminus")) {
            clamp = (SimuCarouselClamp)this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = (SimuCarouselClamp)this.carousel.getClampXplus();
        } else {
            throw new ErrorInCommandExecutionException(this.getName() + ": unable to find the clamp to unlock.");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsLOCKED(clamp);
        this.turnedOff = true;
        this.publishData();
        return this.getName() + " is turned OFF.";
    }
}

