/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLatchController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerOnlineClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGWSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuAutochangerPlutoGateway
extends SimuPlutoGateway {
    private AutoChangerTrucksModule trucks;
    private SimuAutochangerLinearRailController trucksController;
    private SimuAutochangerLatchController latchXminusController;
    private SimuAutochangerLatchController latchXplusController;
    private SimuAutochangerOnlineClampController onlineClampXminusController;
    private SimuAutochangerOnlineClampController onlineClampXplusController;
    private SimuAutochangerOnlineClampController onlineClampYminusController;
    private SimuPlutoGWSensor handoffPositionSensor0;
    private SimuPlutoGWSensor handoffPositionSensor1;
    private SimuPlutoGWSensor onlinePositionSensor0;
    private SimuPlutoGWSensor onlinePositionSensor1;
    private SimuPlutoGWSensor standbyPositionSensor0;
    private SimuPlutoGWSensor standbyPositionSensor1;
    private SimuPlutoGWSensor loaderConnectedSensor0;
    private SimuPlutoGWSensor loaderConnectedSensor1;
    private SimuPlutoGWSensor lockSensorLatchXminus;
    private SimuPlutoGWSensor unlockSensorLatchXminus;
    private SimuPlutoGWSensor filterPresenceSensorLatchXminus;
    private SimuPlutoGWSensor lockSensorLatchXplus;
    private SimuPlutoGWSensor unlockSensorLatchXplus;
    private SimuPlutoGWSensor filterPresenceSensorLatchXplus;
    private SimuPlutoGWSensor lockSensorClampXminus;
    private SimuPlutoGWSensor lockSensorCClampXminus;
    private SimuPlutoGWSensor unlockSensorClampXminus;
    private SimuPlutoGWSensor unlockSensorCClampXminus;
    private SimuPlutoGWSensor lockSensorClampXplus;
    private SimuPlutoGWSensor lockSensorCClampXplus;
    private SimuPlutoGWSensor unlockSensorClampXplus;
    private SimuPlutoGWSensor unlockSensorCClampXplus;
    private SimuPlutoGWSensor lockSensorClampYminus;
    private SimuPlutoGWSensor lockSensorCClampYminus;
    private SimuPlutoGWSensor unlockSensorClampYminus;
    private SimuPlutoGWSensor unlockSensorCClampYminus;

    public SimuAutochangerPlutoGateway(String name, int tickMillis, String nodeID, String serialNB) {
        super(name, tickMillis, nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        this.handoffPositionSensor0 = (SimuPlutoGWSensor)((Object)this.getComponentByName("handoffPositionSensor0"));
        this.handoffPositionSensor1 = (SimuPlutoGWSensor)((Object)this.getComponentByName("handoffPositionSensor1"));
        this.onlinePositionSensor0 = (SimuPlutoGWSensor)((Object)this.getComponentByName("onlinePositionSensor0"));
        this.onlinePositionSensor1 = (SimuPlutoGWSensor)((Object)this.getComponentByName("onlinePositionSensor1"));
        this.standbyPositionSensor0 = (SimuPlutoGWSensor)((Object)this.getComponentByName("standbyPositionSensor0"));
        this.standbyPositionSensor1 = (SimuPlutoGWSensor)((Object)this.getComponentByName("standbyPositionSensor1"));
        this.loaderConnectedSensor0 = (SimuPlutoGWSensor)((Object)this.getComponentByName("loaderConnectedSensor0"));
        this.loaderConnectedSensor1 = (SimuPlutoGWSensor)((Object)this.getComponentByName("loaderConnectedSensor1"));
        this.trucksController = (SimuAutochangerLinearRailController)this.getComponentByName("linearRailMasterController");
        this.trucks = (AutoChangerTrucksModule)((Object)this.getComponentByName("trucks"));
        this.simulateAutochangerTrucksIsAtStandby();
        this.lockSensorLatchXminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("lockSensorLatchXminus"));
        this.unlockSensorLatchXminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("unlockSensorLatchXminus"));
        this.filterPresenceSensorLatchXminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("filterPresenceSensorLatchXminus"));
        this.lockSensorLatchXplus = (SimuPlutoGWSensor)((Object)this.getComponentByName("lockSensorLatchXplus"));
        this.unlockSensorLatchXplus = (SimuPlutoGWSensor)((Object)this.getComponentByName("unlockSensorLatchXplus"));
        this.filterPresenceSensorLatchXplus = (SimuPlutoGWSensor)((Object)this.getComponentByName("filterPresenceSensorLatchXplus"));
        this.latchXminusController = (SimuAutochangerLatchController)this.getComponentByName("latchXminusController");
        this.latchXplusController = (SimuAutochangerLatchController)this.getComponentByName("latchXplusController");
        this.lockSensorClampXminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("lockSensorClampXminus"));
        this.lockSensorCClampXminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("lockSensorCClampXminus"));
        this.unlockSensorClampXminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("unlockSensorClampXminus"));
        this.unlockSensorCClampXminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("unlockSensorCClampXminus"));
        this.lockSensorClampXplus = (SimuPlutoGWSensor)((Object)this.getComponentByName("lockSensorClampXplus"));
        this.lockSensorCClampXplus = (SimuPlutoGWSensor)((Object)this.getComponentByName("lockSensorCClampXplus"));
        this.unlockSensorClampXplus = (SimuPlutoGWSensor)((Object)this.getComponentByName("unlockSensorClampXplus"));
        this.unlockSensorCClampXplus = (SimuPlutoGWSensor)((Object)this.getComponentByName("unlockSensorCClampXplus"));
        this.lockSensorClampYminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("lockSensorClampYminus"));
        this.lockSensorCClampYminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("lockSensorCClampYminus"));
        this.unlockSensorClampYminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("unlockSensorClampYminus"));
        this.unlockSensorCClampYminus = (SimuPlutoGWSensor)((Object)this.getComponentByName("unlockSensorCClampYminus"));
        this.simulateFilterIsOnAutochanger();
        this.simulateAutochangerLatchesAreLocked();
        this.simulateAutochangerOnlineClampsAreUnlocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtHandoff() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "1");
        this.replaceDigitalValues(this.handoffPositionSensor1, "1");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
        this.trucksController.setPosition(this.trucks.getHandoffPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsOnline() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "1");
        this.replaceDigitalValues(this.onlinePositionSensor1, "1");
        this.trucksController.setPosition(this.trucks.getOnlinePosition());
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getOnlinePosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtStandby() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "1");
        this.replaceDigitalValues(this.standbyPositionSensor1, "1");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
        this.trucksController.setPosition(this.trucks.getStandbyPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsInTravel() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "1");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsDisconnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "0");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnAutochanger() {
        this.replaceDigitalValues(this.filterPresenceSensorLatchXminus, "1");
        this.replaceDigitalValues(this.filterPresenceSensorLatchXplus, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerIsEmpty() {
        this.replaceDigitalValues(this.filterPresenceSensorLatchXminus, "0");
        this.replaceDigitalValues(this.filterPresenceSensorLatchXplus, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreLocked() {
        this.replaceDigitalValues(this.lockSensorLatchXminus, "1");
        this.replaceDigitalValues(this.unlockSensorLatchXminus, "0");
        this.replaceDigitalValues(this.lockSensorLatchXplus, "1");
        this.replaceDigitalValues(this.unlockSensorLatchXplus, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsLocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.replaceDigitalValues(this.lockSensorLatchXminus, "1");
            this.replaceDigitalValues(this.unlockSensorLatchXminus, "0");
        } else if (latchName.contains("Xplus")) {
            this.replaceDigitalValues(this.lockSensorLatchXplus, "1");
            this.replaceDigitalValues(this.unlockSensorLatchXplus, "0");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsUnlocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.replaceDigitalValues(this.lockSensorLatchXminus, "0");
            this.replaceDigitalValues(this.unlockSensorLatchXminus, "1");
        } else if (latchName.contains("Xplus")) {
            this.replaceDigitalValues(this.lockSensorLatchXplus, "0");
            this.replaceDigitalValues(this.unlockSensorLatchXplus, "1");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreLocked() {
        this.simulateAutochangerOnlineClampXminusIsLocked();
        this.simulateAutochangerOnlineClampXplusIsLocked();
        this.simulateAutochangerOnlineClampYminusIsLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreUnlocked() {
        this.simulateAutochangerOnlineClampXminusIsUnlocked();
        this.simulateAutochangerOnlineClampXplusIsUnlocked();
        this.simulateAutochangerOnlineClampYminusIsUnlocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsLocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor lockSensorC, SimuPlutoGWSensor unlockSensor, SimuPlutoGWSensor unlockSensorC) {
        this.replaceDigitalValues(lockSensor, "1");
        this.replaceDigitalValues(lockSensorC, "0");
        this.replaceDigitalValues(unlockSensor, "0");
        this.replaceDigitalValues(unlockSensorC, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsUnlocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor lockSensorC, SimuPlutoGWSensor unlockSensor, SimuPlutoGWSensor unlockSensorC) {
        this.replaceDigitalValues(lockSensor, "0");
        this.replaceDigitalValues(lockSensorC, "1");
        this.replaceDigitalValues(unlockSensor, "1");
        this.replaceDigitalValues(unlockSensorC, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXminusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.lockSensorClampXminus, this.lockSensorCClampXminus, this.unlockSensorClampXminus, this.unlockSensorCClampXminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXminusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.lockSensorClampXminus, this.lockSensorCClampXminus, this.unlockSensorClampXminus, this.unlockSensorCClampXminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXplusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.lockSensorClampXplus, this.lockSensorCClampXplus, this.unlockSensorClampXplus, this.unlockSensorCClampXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXplusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.lockSensorClampXplus, this.lockSensorCClampXplus, this.unlockSensorClampXplus, this.unlockSensorCClampXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampYminusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.lockSensorClampYminus, this.lockSensorCClampYminus, this.unlockSensorClampYminus, this.unlockSensorCClampYminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampYminusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.lockSensorClampYminus, this.lockSensorCClampYminus, this.unlockSensorClampYminus, this.unlockSensorCClampYminus);
    }
}

