/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuAutochangerLinearRailController
extends SimuEPOSControllerModule {
    private AutoChangerTrucksModule trucks;
    private SimuAutochangerPlutoGateway plutoGateway;

    public SimuAutochangerLinearRailController(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
    }

    @Override
    public void initModule() {
        this.trucks = (AutoChangerTrucksModule)((Object)this.getComponentByName("autochangerTrucks"));
        this.plutoGateway = (SimuAutochangerPlutoGateway)this.getComponentByName("plutoGateway");
    }

    @Override
    public void writeTargetPosition(int positionToReached) throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.debug((Object)"loader trucks is moving.");
        FCSCst.FCSLOG.debug((Object)(this.name + "=>position intitiale=" + this.position));
        int stepsNB = Math.abs(this.targetPosition - this.position) > 10000 ? 20 : 5;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            try {
                this.position = positionInitiale + i * step;
                this.trucks.updatePosition();
                if (this.position == this.trucks.getHandoffPosition()) {
                    log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                    this.plutoGateway.simulateAutochangerTrucksIsAtHandoff();
                } else if (this.position == this.trucks.getStandbyPosition()) {
                    this.plutoGateway.simulateAutochangerTrucksIsAtStandby();
                } else if (this.position == this.trucks.getOnlinePosition()) {
                    this.plutoGateway.simulateAutochangerTrucksIsOnline();
                } else {
                    this.plutoGateway.simulateAutochangerTrucksIsInTravel();
                }
                this.trucks.updateStateWithSensors();
                this.trucks.publishData();
                FCSCst.FCSLOG.debug((Object)(this.name + "i=" + i + ",position=" + this.position));
                try {
                    Thread.sleep(500L);
                    if (!this.trucks.getHaltRequired().get()) continue;
                    log.debug((Object)(this.name + " STOP simulated trucks motion."));
                    return;
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)ex);
                    throw new BadCommandException(this.name + " sleep was interrupted.");
                }
            }
            catch (FcsHardwareException ex) {
                FCSCst.FCSLOG.error((Object)ex);
                throw new BadCommandException(ex.getMessage());
            }
        }
        this.position = this.targetPosition;
        if (this.position == this.trucks.getHandoffPosition()) {
            log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        } else if (this.position == this.trucks.getStandbyPosition()) {
            this.plutoGateway.simulateAutochangerTrucksIsAtStandby();
        } else if (this.position == this.trucks.getOnlinePosition()) {
            this.plutoGateway.simulateAutochangerTrucksIsOnline();
        } else {
            this.plutoGateway.simulateAutochangerTrucksIsInTravel();
        }
    }
}

