/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuAutochangerLatchController
extends SimuEPOSControllerModule {
    private final String latchName;
    private AutochangerLatchModule latch;
    private SimuAutochangerPlutoGateway plutoGateway;

    public SimuAutochangerLatchController(String aName, int aTickMillis, String nodeID, String serialNB, String latchName, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.mode = EPOSEnumerations.EposMode.CURRENT;
        this.latchName = latchName;
    }

    @Override
    public void initModule() {
        FCSCst.FCSLOG.debug((Object)(this.name + ":latchName=" + this.latchName));
        this.latch = (AutochangerLatchModule)((Object)this.getComponentByName(this.latchName));
        this.plutoGateway = (SimuAutochangerPlutoGateway)this.getComponentByName("plutoGateway");
    }

    @Override
    public void writeCurrent(int aValue) throws BadCommandException, SDORequestException, FcsHardwareException {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        FCSCst.FCSLOG.debug((Object)("=>initial current=" + this.actualCurrent));
        int stepsNB = 10;
        int step = (this.targetCurrent - this.actualCurrent) / stepsNB;
        for (int i = 1; i <= stepsNB; ++i) {
            this.actualCurrent = i < stepsNB ? currentInitial + i * step : aValue;
            this.latch.updateCurrent();
            if (this.actualCurrent == this.latch.getCurrentToOpen()) {
                FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                this.plutoGateway.simulateAutochangerLatchIsUnlocked(this.latchName);
            } else if (this.actualCurrent == -this.latch.getCurrentToOpen()) {
                this.plutoGateway.simulateAutochangerLatchIsLocked(this.latchName);
            }
            this.latch.publishData();
            FCSCst.FCSLOG.debug((Object)("i=" + i + ",actualCurrent=" + this.actualCurrent));
            try {
                Thread.sleep(200L);
                if (!this.latch.getHaltRequired().get()) continue;
                FCSCst.FCSLOG.debug((Object)(this.name + " STOP simulated latch motion."));
                return;
            }
            catch (InterruptedException ex) {
                throw new BadCommandException(this.name + " sleep was interrupted.");
            }
        }
    }

    @Override
    public String off() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.writeCurrent(0);
        return this.name + " is OFF";
    }
}

