/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class LoaderCanOpenProxy
extends CanOpenProxy {
    public LoaderCanOpenProxy(String aName, int aTickMillis, int portNumber, String aClientName, long hardwareBootTimeout) {
        super(aName, aTickMillis, portNumber, aClientName, hardwareBootTimeout);
    }

    @Override
    public void start() {
        FCSCst.FCSLOG.debug((Object)(this.name + ": START DU TCP PROXY DU LOADER"));
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Override
    public void connectHardware() throws HardwareException {
        super.connectHardware();
        try {
            super.checkHardware();
        }
        catch (HardwareException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + ": ERROR in connecting hardware"));
            throw ex;
        }
    }

    @Override
    public void publishHardwareData(PieceOfHardware device) {
        StatusDataPublishedByHardware status = FcsUtils.createStatusDataPublishedByHardware(device);
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("loaderTcpProxy", (Serializable)status));
    }
}

