/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;

public class CommandDispenser {
    private final HashMap<String, CommandToRegister> map = new HashMap();

    public synchronized String register(String command) {
        String key;
        if (command == null) {
            throw new IllegalArgumentException("null Command");
        }
        String[] words = command.split(",");
        String commandWord = words[0];
        if (words.length > 1) {
            String nodeID = words[1];
            key = commandWord + nodeID;
        } else {
            key = commandWord;
        }
        FCSCst.FCSLOG.finest((Object)("command word:" + commandWord));
        FCSCst.FCSLOG.finest((Object)("key: " + key));
        FCSCst.FCSLOG.finest((Object)("Command to register: " + command));
        this.map.put(key, new CommandToRegister(command));
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerResponse(String token, String response) {
        CommandToRegister commandToRegister;
        FCSCst.FCSLOG.finest((Object)("Registering token response: " + token + " " + response));
        if (response == null) {
            throw new IllegalArgumentException("null Response");
        }
        if (!this.isTokenUsed(token)) {
            throw new IllegalArgumentException("invalid Token: " + token);
        }
        CommandDispenser commandDispenser = this;
        synchronized (commandDispenser) {
            commandToRegister = this.map.get(token);
        }
        commandToRegister.updateResponse(response);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommandResponse(String token, long timeout) throws CanOpenCallTimeoutException {
        CommandToRegister commandToRegister;
        if (!this.isTokenUsed(token)) {
            throw new IllegalArgumentException("invalid Token: " + token);
        }
        CommandDispenser commandDispenser = this;
        synchronized (commandDispenser) {
            commandToRegister = this.map.get(token);
        }
        String responseToSend = commandToRegister.getResponse(timeout);
        return responseToSend;
    }

    public synchronized void remove(String token) {
        FCSCst.FCSLOG.finest((Object)("removing token = " + token));
        this.map.remove(token);
    }

    public synchronized boolean isTokenUsed(String token) {
        if (token == null) {
            return false;
        }
        return this.map.containsKey(token);
    }

    protected static class CommandToRegister {
        private final String initialCommand;
        private volatile String response;
        private final Lock lock = new ReentrantLock();
        private final Condition responseArrived = this.lock.newCondition();

        public CommandToRegister(String aTextCommand) {
            this.initialCommand = aTextCommand;
            this.response = null;
        }

        public void updateResponse(String theResponse) {
            this.lock.lock();
            try {
                this.response = theResponse;
                this.responseArrived.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getResponse(long timeout) throws CanOpenCallTimeoutException {
            this.lock.lock();
            try {
                while (this.response == null) {
                    try {
                        boolean responseOK = this.responseArrived.await(timeout, TimeUnit.MILLISECONDS);
                        if (!responseOK) {
                            throw new CanOpenCallTimeoutException("timeout expired for command:" + this.initialCommand);
                        }
                        if (this.response != null) continue;
                        FCSCst.FCSLOG.error((Object)("no response for " + this.initialCommand));
                        throw new CanOpenCallTimeoutException("response=null for command:" + this.initialCommand);
                    }
                    catch (InterruptedException ex) {
                        FCSCst.FCSLOG.error((Object)("Interrupted while waiting for a response for command :  " + this.initialCommand), (Throwable)ex);
                    }
                }
                FCSCst.FCSLOG.finest((Object)("Return response: " + this.response + " for command: " + this.toString()));
                String string = this.response;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return this.initialCommand + "/" + this.response;
        }
    }

    public static class TokenLostException
    extends Exception {
        private static final long serialVersionUID = -2198073301435975779L;
        public final String token;

        public TokenLostException(String token) {
            this.token = token;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.token;
        }
    }
}

