/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

public class CanOpenTruckMotor
extends SftTruckMotor {
    private CompactIOModule dio;
    private final String dioName;
    private final int outputNumeroToStandby;
    private final int outputNumeroToStandback;

    public CanOpenTruckMotor(String name, int tickMillis, String dioName, int outputNumeroToStandby, int outputNumeroToStandback) {
        super(name, tickMillis);
        this.dioName = dioName;
        this.outputNumeroToStandby = outputNumeroToStandby;
        this.outputNumeroToStandback = outputNumeroToStandback;
    }

    public void initModule() {
        this.dio = (CompactIOModule)this.getComponentByName(this.dioName);
    }

    @Override
    public String moveToStandback() throws CanOpenException, FcsHardwareException {
        this.setMovingToStandback(true);
        return this.dio.tcpProxy.writeSDO(this.dio.nodeID, "6200", "1", "1", "1");
    }

    @Override
    public String moveToStandby() throws CanOpenException, FcsHardwareException {
        this.setMovingToStandby(true);
        return this.dio.tcpProxy.writeSDO(this.dio.nodeID, "6200", "1", "1", "2");
    }

    @Override
    public String off() throws CanOpenException, FcsHardwareException {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return this.dio.tcpProxy.writeSDO(this.dio.nodeID, "6200", "1", "1", "0");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\noutputNumeroToStandby=");
        sb.append(this.outputNumeroToStandby);
        sb.append("\noutputNumeroToStandback=");
        sb.append(this.outputNumeroToStandback);
        return sb.toString();
    }
}

