/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenThermometer
extends CanOpenSensor14bits
implements Thermometer {
    private double temperature;

    public CanOpenThermometer(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput) {
        super(moduleName, aTickMillis, adcName, numOfAnalogInput);
    }

    public static double getDoubleValue(String valueInHexa) {
        double temp = 0.0;
        FCSCst.FCSLOG.debug((Object)("Value in HEXA=" + valueInHexa));
        int valueInt = Integer.parseInt(valueInHexa, 16);
        double voltage = (double)valueInt * 0.3125;
        FCSCst.FCSLOG.debug((Object)("Input Value read on the ADC:" + valueInt));
        FCSCst.FCSLOG.debug((Object)("Voltage = " + voltage + " volts"));
        temp = voltage / 10.0 - 273.15;
        return temp;
    }

    @Override
    public double readTemperature() throws HardwareNotDetectedException, SDORequestException, FcsHardwareException {
        try {
            double voltage = this.adc.readVoltage(this.numOfAnalogInput);
            this.temperature = voltage / 10.0 - 273.15;
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.warning((Object)(this.name + ": could'nt read temperature:" + (Object)((Object)ex)));
        }
        return this.temperature;
    }

    public double readTemperatureWithPDO(PDOStorage pdo) throws BadCommandException {
        if (!this.adc.isInitialized()) {
            throw new BadCommandException("Can't read temperature from PDO if Can Open device is not initialized.");
        }
        if (!this.adc.transmissionType.equals("1")) {
            throw new BadCommandException("Transmission type for Can Open device must be 1");
        }
        String hexa = pdo.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        return CanOpenThermometer.getDoubleValue(hexa);
    }
}

