/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class CanOpenSensor14bits
extends Sensor14bits {
    protected CanOpenADC adc;
    private String adcName;
    protected int numOfAnalogInput;

    public CanOpenSensor14bits(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput) {
        super(moduleName, aTickMillis);
        this.adcName = adcName;
        this.numOfAnalogInput = numOfAnalogInput;
    }

    public void setAdcName(String adcName) {
        this.adcName = adcName;
    }

    public void setNumOfAnalogInput(int numOfAnalogInput) {
        this.numOfAnalogInput = numOfAnalogInput;
    }

    public CanOpenADC getAdc() {
        return this.adc;
    }

    public int getNumOfAnalogInput() {
        return this.numOfAnalogInput;
    }

    @Override
    public void initModule() {
        this.adc = (CanOpenADC)this.getComponentByName(this.adcName);
    }

    @Override
    public int readNewValue() throws FcsHardwareException {
        String valueInHexa = this.adc.readAnalogInput(this.numOfAnalogInput);
        this.value = Integer.parseInt(valueInHexa, 16);
        return this.value;
    }

    @Override
    public int updateValue(PDOStorage pdoStorage) {
        String hexaValue = pdoStorage.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        this.value = Integer.parseInt(hexaValue, 16);
        return this.value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/adcName=");
        sb.append(this.adcName);
        sb.append("/inputNumero=");
        sb.append(this.numOfAnalogInput);
        return sb.toString();
    }
}

