/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.common.TcpProxyInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.PDOBadResponseException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenProxy
extends FcsTcpProxy
implements HardwareController,
ClearAlertHandler,
TcpProxyInterface {
    private final String myClientName;
    private Map<String, CanOpenNode> bootedNodes;
    private boolean hardwareBootProcessEnded = false;
    private boolean hardwareIdentified = false;
    private long hardwareBootTimeout;
    protected PieceOfHardware[] hardwareList;
    private boolean canOpenNodeNumbersOK = false;
    private StringBuilder errorMessageSB;
    private boolean hardwareIDError;
    private PDOStorage pdoStorage;
    private ScheduledFuture<?> checkDevicesHandle;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    protected final Condition bootingCompleted = this.lock.newCondition();

    public CanOpenProxy(String aName, int aTickMillis, int portNumber, String aClientName, long hardwareBootTimeout) {
        super(aName, aTickMillis, portNumber);
        this.myClientName = aClientName;
        this.hardwareBootTimeout = hardwareBootTimeout;
        this.bootedNodes = new HashMap<String, CanOpenNode>();
    }

    public int getExpectedNodesNB() {
        return this.hardwareList.length;
    }

    public long getHardwareBootTimeout() {
        return this.hardwareBootTimeout;
    }

    @ConfigChanger
    public void setHardwareBootTimeout(long hardwareBootTimeout) {
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    @ConfigChanger
    public void setHardwareBootTimeout(int hardwareBootTimeout) {
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    public PieceOfHardware[] getHardwareList() {
        return (PieceOfHardware[])this.hardwareList.clone();
    }

    protected void setHardwareList(PieceOfHardware[] hardwareList) {
        this.hardwareList = (PieceOfHardware[])hardwareList.clone();
    }

    public String getMyClientName() {
        return this.myClientName;
    }

    public PDOStorage getPdoStorage() {
        return this.pdoStorage;
    }

    public boolean isHardwareIdentified() {
        return this.hardwareIdentified;
    }

    @Override
    public void disconnectHardware() {
        this.stopServer();
        this.bootedNodes = new HashMap<String, CanOpenNode>();
        this.hardwareBootProcessEnded = false;
        this.hardwareIdentified = false;
        this.canOpenNodeNumbersOK = false;
        this.hardwareIDError = false;
        this.pdoStorage = new PDOStorage();
    }

    @Override
    public void connectHardware() throws HardwareException {
        this.startServer();
        this.startThreadReader();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hardwareBootProcessEnded = false;
        this.hardwareIdentified = false;
        this.canOpenNodeNumbersOK = false;
        this.hardwareIDError = false;
        this.pdoStorage = new PDOStorage();
        this.getSubsystem().addClearAlertHandler((ClearAlertHandler)this);
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.hardwareBootProcessEnded = false;
        FCSCst.FCSLOG.debug((Object)(this.name + ": BEGIN CHECKHARDWARE"));
        this.lock.lock();
        try {
            this.readDevicesInfo(System.currentTimeMillis(), this.hardwareBootTimeout);
            this.waitForEndOfBooting();
        }
        finally {
            this.lock.unlock();
        }
        FCSCst.FCSLOG.debug((Object)(this.name + ": END OF BOOT PROCESS"));
        FCSCst.FCSLOG.info((Object)(this.name + "=>" + this.listNodes()));
        this.checkCanOpenNodes();
        FCSCst.FCSLOG.debug((Object)(this.name + ": END CHECKHARDWARE"));
        this.publishData();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void readDevicesInfo(long beginTime, long timeout) {
        Runnable checkDevices = () -> {
            try {
                this.identifyHardware();
                this.publishData();
                long duration = System.currentTimeMillis() - beginTime;
                if (duration > timeout || this.bootedNodes.size() == this.hardwareList.length) {
                    this.hardwareBootProcessEnded = true;
                    this.cancelReadDevicesInfo();
                }
            }
            catch (HardwareException ex) {
                FCSCst.FCSLOG.error((Object)ex);
                Alert alert = new Alert("FCS001", " couln't read devices info because:" + ex.getMessage());
                this.getSubsystem().raiseAlert(alert, AlertState.ALARM);
            }
        };
        this.checkDevicesHandle = this.scheduler.scheduleAtFixedRate(checkDevices, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void cancelReadDevicesInfo() {
        this.lock.lock();
        try {
            FCSCst.FCSLOG.debug((Object)(this.getName() + " => stop waiting for devices info."));
            this.bootingCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.checkDevicesHandle.cancel(true);
        FCSCst.FCSLOG.debug((Object)(this.getName() + " => readDevicesInfo canceled"));
    }

    private void waitForEndOfBooting() {
        while (!this.hardwareBootProcessEnded) {
            try {
                FCSCst.FCSLOG.info((Object)(this.name + " waiting until all pieces of hardware are booted."));
                this.bootingCompleted.await();
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.info((Object)(this.name + ": InterruptedException received=" + ex));
                break;
            }
        }
        FCSCst.FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF BOOTING PROCESS"));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Retrieve information for booted devices and checks if CANopen node ID and serial number match thosein description file .")
    public void checkNewHardware() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN checkStartedToCompleteInitialization"));
        if (!this.isReady(this.myClientName)) {
            throw new HardwareException(true, this.name + ": not yet connected with CWrapper.");
        }
        if (!this.isTcpServerStarted()) {
            throw new HardwareException(true, this.name + ": could not start tcp server.");
        }
        this.identifyHardware();
        this.checkCanOpenNodes();
    }

    public void checkStarted() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN checkStarted"));
    }

    public void checkStopped() throws HardwareException {
    }

    @Override
    public void shutdownNow() {
        super.shutdownNow();
        this.scheduler.shutdown();
    }

    public String getNodeName(String aNodeID) {
        for (PieceOfHardware hardware : this.hardwareList) {
            if (!hardware.getNodeID().equals(aNodeID)) continue;
            return hardware.getName();
        }
        return "Unbooted nodeID:" + aNodeID;
    }

    private boolean isBooted(String aNodeID) {
        if (this.bootedNodes.isEmpty()) {
            return false;
        }
        return this.bootedNodes.containsKey(aNodeID);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Print the list of CANopen nodes which are booted on the CAN bus.")
    public String listNodes() {
        StringBuilder sb = new StringBuilder("List of booted Nodes = (values are in HEXA)\n");
        if (this.bootedNodes.isEmpty()) {
            sb.append(this.name);
            sb.append(": No booted CANopen devices.");
        }
        for (Map.Entry<String, CanOpenNode> entry : this.bootedNodes.entrySet()) {
            CanOpenNode bootedNode = entry.getValue();
            sb.append(bootedNode);
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen command to the Can Bus.")
    public String sendCanOpenCommand(String command) throws FcsHardwareException {
        if (!this.tcpServerStarted) {
            throw new FcsHardwareException(this.name + ": is not started, can't send CanOpen commands.");
        }
        CanOpenProxy.checkCanOpenCommand(command, this.name);
        return this.sendCanOpen(command);
    }

    private String sendCanOpen(String command) throws FcsHardwareException {
        try {
            return (String)this.call(this.getMyClientName(), command);
        }
        catch (CWrapperNotConnected ex) {
            FCSCst.FCSLOG.error((Object)(this.name + ":CWrapper not connected-" + (Object)((Object)ex)));
            Alert alert = new Alert("FCS001", "Can't communicate with hardware because CWrapper is not connected - check ethernet connections.");
            this.getSubsystem().raiseAlert(alert, AlertState.ALARM);
            throw new FcsHardwareException("CWrapper not connected.", (Throwable)ex);
        }
        catch (CanOpenCallTimeoutException ex) {
            String msg = this.name + ": timeout expired while waiting to a response from CANbus " + "to command: " + command + " POWER FAILURE ? ";
            FCSCst.FCSLOG.error((Object)msg);
            Alert alert = new Alert("FCS001", msg);
            this.getSubsystem().raiseAlert(alert, AlertState.ALARM);
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    private static String buildWsdoCommand(String nodeID, String index, String subindex, String size, String data) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("wsdo").append(sep);
        sb.append(nodeID).append(sep);
        sb.append(index).append(sep);
        sb.append(subindex).append(sep);
        sb.append(size).append(sep);
        sb.append(data);
        return sb.toString();
    }

    private static String buildRsdoCommand(String nodeID, String index, String subindex) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("rsdo").append(sep);
        sb.append(nodeID).append(sep);
        sb.append(index).append(sep);
        sb.append(subindex);
        return sb.toString();
    }

    private static void checkCanOpenCommand(String command, String tcpProxyName) {
        String keyWord;
        String[] words = command.split(",");
        switch (keyWord = words[0]) {
            case "rsdo": {
                if (words.length == 4) break;
                throw new IllegalArgumentException("rsdo command must have 3 parameters: nodeID, index, subindex");
            }
            case "wsdo": {
                if (words.length == 6) break;
                throw new IllegalArgumentException("wsdo command must have 5 parameters: nodeID, index, subindex, size, data");
            }
            case "info": {
                if (words.length == 2) break;
                throw new IllegalArgumentException("info command must have only one parameter: nodeID");
            }
            case "sync": {
                if (words.length == 1) break;
                throw new IllegalArgumentException("sync command takes no parameter");
            }
            case "srtr": {
                if (words.length >= 2) break;
                throw new IllegalArgumentException("srtr command takes at least one parameter (cobib)");
            }
            case "quit": {
                if (words.length == 1) break;
                throw new IllegalArgumentException("quit command takes no parameter");
            }
            default: {
                throw new IllegalArgumentException(tcpProxyName + " Invalid CANopen command:" + command);
            }
        }
    }

    public String writeSDO(String nodeID, String index, String subindex, String size, String value) throws FcsHardwareException {
        String errorCode;
        String request = CanOpenProxy.buildWsdoCommand(nodeID, index, subindex, size, value);
        String sdoResponseLine = this.sendCanOpen(request);
        String[] words = sdoResponseLine.split(",");
        switch (errorCode = words[2]) {
            case "0": {
                return "OK";
            }
            case "-1": {
                String msg = this.name + ":wrong writeSDO command : " + sdoResponseLine;
                String deviceName = this.getNodeName(nodeID);
                FCSCst.FCSLOG.error((Object)msg);
                this.getSubsystem().raiseAlert(new Alert(deviceName, msg), AlertState.ALARM);
                throw new SDORequestException(this.name + ":wrong writeSDO command : " + sdoResponseLine);
            }
        }
        String message = this.processSDORequestError(request, sdoResponseLine, nodeID, errorCode, AlertState.ALARM);
        throw new SDORequestException(message);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen writeSDO command to the Can Bus.")
    public String writeSDO(int nodeID, String index, String subindex, int size, int value) throws FcsHardwareException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and <=127");
        }
        if (size < 0 || size > 4) {
            throw new IllegalArgumentException("size must be > 0 and < 4");
        }
        return this.writeSDO(Integer.toHexString(nodeID), index, subindex, Integer.toHexString(size), Integer.toHexString(value));
    }

    public String readSDO(String nodeID, String index, String subindex) throws ShortResponseToSDORequestException, FcsHardwareException {
        String request = CanOpenProxy.buildRsdoCommand(nodeID, index, subindex);
        String sdoLine = this.sendCanOpen(CanOpenProxy.buildRsdoCommand(nodeID, index, subindex));
        String[] words = sdoLine.split(",");
        int responseLength = words.length;
        String errorCode = words[2];
        if ("0".equals(errorCode) && responseLength > 3) {
            return words[3];
        }
        if ("0".equals(errorCode) && responseLength == 3) {
            String msg = this.name + ":readSDO request received a too short response=" + sdoLine;
            FCSCst.FCSLOG.warning((Object)msg);
            String deviceName = this.getNodeName(nodeID);
            this.getSubsystem().raiseAlert(new Alert(deviceName, msg), AlertState.WARNING);
            throw new ShortResponseToSDORequestException(msg);
        }
        if ("-1".equals(errorCode)) {
            String msg = this.name + ":wrong readSDO command : " + sdoLine;
            FCSCst.FCSLOG.error((Object)msg);
            String deviceName = this.getNodeName(nodeID);
            this.getSubsystem().raiseAlert(new Alert(deviceName, msg), AlertState.ALARM);
            throw new SDORequestException(msg);
        }
        String message = this.processSDORequestError(request, sdoLine, nodeID, errorCode, AlertState.ALARM);
        throw new SDORequestException(message);
    }

    public String processSDORequestError(String request, String response, String nodeID, String errorCode, AlertState alertState) {
        String error = String.format("%08d", Integer.parseInt(errorCode));
        String errorName = CanOpenErrorsTable.commErrorCodes.getProperty(error);
        String deviceName = this.getNodeName(nodeID);
        String msg = this.name + ": SDO request was going wrong for device: " + deviceName;
        msg = msg + ",request=" + request + ",received response=" + response;
        msg = msg + ",errorCode=" + errorCode + ",errorName=" + errorName;
        if (alertState.equals((Object)AlertState.WARNING)) {
            FCSCst.FCSLOG.warning((Object)msg);
        } else {
            FCSCst.FCSLOG.error((Object)msg);
        }
        this.getSubsystem().raiseAlert(new Alert(deviceName, msg), alertState);
        return msg;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen readSDO command to the Can Bus.")
    public String readSDO(int nodeID, String index, String subindex) throws SDORequestException, BadCommandException, ShortResponseToSDORequestException, FcsHardwareException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        return this.readSDO(Integer.toHexString(nodeID), index, subindex);
    }

    public PDOStorage readPDOs() throws FcsHardwareException {
        try {
            String replyToSync = this.sendCanOpen("sync");
            FCSCst.FCSLOG.finest((Object)(this.name + ": replyToSync=" + replyToSync));
            this.pdoStorage.updatePDOs(replyToSync);
            return this.pdoStorage;
        }
        catch (PDOBadResponseException ex) {
            String msg = this.name + ": error in response to a sync command.";
            this.getSubsystem().raiseAlert(new Alert("FCS001", msg), AlertState.ALARM);
            FCSCst.FCSLOG.error((Object)ex);
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Identification of the hardware : we want to retrieve the information \n     * stored in the hardware of the booted nodes and update the array of nodes\n     * with this information.")
    public void identifyHardware() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.name + ":Identification of the hardware"));
        for (Map.Entry<String, CanOpenNode> entry : this.bootedNodes.entrySet()) {
            CanOpenNode bootedNode = entry.getValue();
            String bootedNodeID = entry.getKey();
            if (bootedNode == null || bootedNode.isIdentified()) continue;
            this.updateDeviceInfo(bootedNodeID, bootedNode);
        }
        this.hardwareIdentified = true;
        this.publishData();
    }

    public void updateDeviceInfo(String bootedNodeID, CanOpenNode bootedNode) throws HardwareException {
        try {
            FCSCst.FCSLOG.debug((Object)(this.name + ":Sending to can open command : info," + bootedNodeID));
            String result = this.sendCanOpen("info," + bootedNodeID);
            FCSCst.FCSLOG.debug((Object)(this.name + ":Received on socket command = " + result));
            String infoLine = result;
            String[] words = infoLine.split(",");
            String command = words[0];
            String nodeID = words[1];
            if ("info".equals(command) && bootedNodeID.equals(nodeID)) {
                FCSCst.FCSLOG.debug((Object)(this.name + ":updating Node Info for node " + nodeID));
                String type = words[2];
                String vendor = words[3];
                String productCode = words[4];
                String revision = words[5];
                String serialNB = words[6];
                bootedNode.setNodeInfo(type, vendor, productCode, revision, serialNB);
            } else {
                FCSCst.FCSLOG.error((Object)(this.name + ":ERROR for command = " + command + "NodeID = " + nodeID));
            }
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.error((Object)ex);
            throw new HardwareException(true, (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all hardware is booted and identified.")
    public boolean isHardwareReady() {
        FCSCst.FCSLOG.info((Object)(this.name + ":hardwareBootProcessEnded=" + this.hardwareBootProcessEnded));
        FCSCst.FCSLOG.info((Object)(this.name + ":hardwareIdentified=" + this.hardwareIdentified));
        FCSCst.FCSLOG.info((Object)(this.name + ":canOpenNodeNumbersOK=" + this.canOpenNodeNumbersOK));
        FCSCst.FCSLOG.info((Object)(this.name + ":hardwareIDError=" + this.hardwareIDError));
        return this.hardwareBootProcessEnded && this.hardwareIdentified && this.canOpenNodeNumbersOK && !this.hardwareIDError;
    }

    @Override
    void processBootMessage(String nodeID) {
        if (this.isBooted(nodeID)) {
            if (this.hardwareBootProcessEnded) {
                String msg = " An unsynchronous boot message is arrived for node ID = " + nodeID + " Possible power failure?";
                FCSCst.FCSLOG.error((Object)msg);
                this.getSubsystem().raiseAlert(new Alert("FCS003:" + this.name + ":" + nodeID, msg), AlertState.WARNING);
            }
        } else {
            this.bootedNodes.put(nodeID, new CanOpenNode(nodeID));
            FCSCst.FCSLOG.info((Object)("Node " + nodeID + " added"));
            FCSCst.FCSLOG.info((Object)("Number of booted devices=" + this.bootedNodes.size()));
            FCSCst.FCSLOG.info((Object)("Number of expected devices=" + this.hardwareList.length));
            if (this.hardwareBootProcessEnded) {
                String msg = this.name + ": boot message is arrived for node ID:" + nodeID + " when boot process is completed. +" + "Has the device been powered on ?";
                FCSCst.FCSLOG.warning((Object)msg);
                this.getSubsystem().raiseAlert(new Alert("FCS003:" + this.name + ":" + nodeID, msg), AlertState.WARNING);
            }
        }
    }

    @Override
    void processEmcyMessage(String message) {
        String[] words = message.split(",");
        String nodeID = words[1];
        String deviceErrorCode = words[2];
        String errReg = words[3];
        String deviceErrorName = CanOpenErrorsTable.getDeviceErrorNameByCode(deviceErrorCode);
        String errorRegisterName = CanOpenErrorsTable.getErrorRegisterNameByCode(errReg);
        String deviceName = this.getNodeName(nodeID);
        this.setChanged();
        EmergencyMessage emcyMsg = new EmergencyMessage(this.name, nodeID, deviceName, deviceErrorCode, deviceErrorName, errReg, errorRegisterName);
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)emcyMsg));
        FCSCst.FCSLOG.error((Object)(this.name + " received EMERGENCY message=" + message + " for nodeID=" + nodeID));
        if ("00".equals(errReg)) {
            FCSCst.FCSLOG.warning((Object)(this.name + " received EMERGENCY message with no error from nodeID=" + nodeID + ". Is it after a faultReset ?"));
        } else {
            FCSCst.FCSLOG.error((Object)emcyMsg);
            Alert alert = new Alert("FCS002" + this.getName() + nodeID, emcyMsg.toString());
            this.getSubsystem().raiseAlert(alert, AlertState.ALARM);
        }
    }

    @Override
    void processUnknownCommand(String message) {
        String[] words = message.split(",");
        String command = words[1];
        String errorMessage = "Unknown command:" + command;
        FCSCst.FCSLOG.error((Object)errorMessage);
    }

    public void checkCanOpenNodes() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.name + ":CHECKING HARDWARE CONFIGURATION "));
        if (this.bootedNodes.isEmpty()) {
            String msg = String.format(" (hardwareBootTimeout=%02d,expectedNodesNB=%02d)", this.hardwareBootTimeout, this.hardwareList.length);
            FCSCst.FCSLOG.error((Object)(this.name + ":NO HARDWARE DETECTED - POWER FAILURE ?" + msg));
            throw new HardwareException(true, this.name + ":NO HARDWARE DETECTED - POWER FAILURE ?" + msg);
        }
        if (this.bootedNodes.size() == this.hardwareList.length) {
            this.canOpenNodeNumbersOK = true;
        }
        this.errorMessageSB = new StringBuilder(this.name);
        this.hardwareIDError = false;
        for (PieceOfHardware hardware : this.hardwareList) {
            FCSCst.FCSLOG.info((Object)("ABOUT TO CHECK: " + hardware.getName() + " NODE_ID=" + hardware.getNodeID()));
            this.checkHardwareID(hardware);
        }
        if (this.hardwareIDError) {
            throw new HardwareException(true, this.errorMessageSB.toString());
        }
        this.publishData();
    }

    public void checkHardwareID(PieceOfHardware pieceOfHardware) throws HardwareException {
        if (this.bootedNodes.containsKey(pieceOfHardware.getNodeID())) {
            CanOpenNode bootedNode = this.bootedNodes.get(pieceOfHardware.getNodeID());
            if (bootedNode.getSerialNB().equals(pieceOfHardware.getSerialNB())) {
                pieceOfHardware.setBooted(true);
                this.publishHardwareData(pieceOfHardware);
                FCSCst.FCSLOG.info((Object)(pieceOfHardware.getName() + " BOOTED AND SERIAL NUMBER OK:" + pieceOfHardware.toString()));
            } else {
                pieceOfHardware.setBooted(false);
                String msg = pieceOfHardware.getName() + " has a wrong serial number. Serial number found=" + bootedNode.getSerialNB() + ", should be=" + pieceOfHardware.getSerialNB();
                FCSCst.FCSLOG.error((Object)msg);
                this.errorMessageSB.append(msg);
                this.hardwareIDError = true;
            }
        } else if (this.getBootedNodeBySerialNumber(pieceOfHardware.getSerialNB()) == null) {
            String msg = String.format(":HARDWARE NOT DETECTED - Possible power failure for node ID %s ? - (hardware:%s,serial number:%s)", pieceOfHardware.getNodeID(), pieceOfHardware.getName(), pieceOfHardware.getSerialNB());
            FCSCst.FCSLOG.error((Object)msg);
            this.errorMessageSB.append(msg);
            this.hardwareIDError = true;
        } else {
            pieceOfHardware.setBooted(false);
            String msg = pieceOfHardware.getName() + " has a wrong serial number. Serial number found=" + this.getBootedNodeBySerialNumber(pieceOfHardware.getSerialNB()).getSerialNB() + ", should be=" + pieceOfHardware.getSerialNB();
            FCSCst.FCSLOG.error((Object)msg);
            this.errorMessageSB.append(msg);
            this.hardwareIDError = true;
        }
    }

    public CanOpenNode getBootedNodeBySerialNumber(String sn) {
        for (Map.Entry<String, CanOpenNode> entry : this.bootedNodes.entrySet()) {
            CanOpenNode bootedNode = entry.getValue();
            if (!bootedNode.getSerialNB().equalsIgnoreCase(sn)) continue;
            return bootedNode;
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns a String representation of a CANopen node booted on the CANbus for the device which serial number is given as a parameter.")
    public String printBootedNodeBySerialNumber(String sn) {
        if (sn == null) {
            throw new IllegalArgumentException(this.name + " Serial Number must be not null.");
        }
        return String.valueOf(this.getBootedNodeBySerialNumber(sn).toString());
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a String with the list of hardware.")
    public String listHardware() {
        StringBuilder sb = new StringBuilder("List of hardware:\n");
        for (PieceOfHardware pieceOfHardware : this.hardwareList) {
            sb.append(pieceOfHardware).append('\n');
        }
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return an Array containing hardware names handled by this component.")
    public List<String> listHardwareNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (PieceOfHardware pieceOfHardware : this.hardwareList) {
            res.add(pieceOfHardware.getName());
        }
        return res;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        switch (alert.getAlertId()) {
            case "FCS001": {
                if (this.clientContext.socket.isConnected() && !this.clientContext.socket.isClosed()) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            case "FCS002": {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    public String configAsHeartbeatProducer(String nodeID, String heartbeatTime) throws TimeoutException, BadCommandException, FcsHardwareException {
        return this.writeSDO(nodeID, "1017", "0", "2", heartbeatTime);
    }

    public String configAsHeartbeatProducer(int nodeID, int heartbeatTime) throws TimeoutException, BadCommandException, FcsHardwareException {
        if (heartbeatTime < 0 || heartbeatTime > 65535) {
            throw new IllegalArgumentException("heartbeat time is coded on 2 bytes can't be > 65535");
        }
        return this.configAsHeartbeatProducer(Integer.toHexString(nodeID), Integer.toHexString(heartbeatTime));
    }

    public String configAsHeartbeatConsumer(int nodeID, int producerNodeID, int heartbeatTime) throws TimeoutException, BadCommandException, FcsHardwareException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and <=127");
        }
        if (producerNodeID < 0 || producerNodeID > 127) {
            throw new IllegalArgumentException("producerNodeID must be > 0 and <=127");
        }
        if (heartbeatTime < 0 || heartbeatTime > 65535) {
            throw new IllegalArgumentException("heartbeat time is coded on 2 bytes can't be > 65535");
        }
        String value = String.format("%04x", producerNodeID) + String.format("%04x", heartbeatTime);
        return this.writeSDO(Integer.toHexString(nodeID), "1016", "1", "4", value);
    }

    @Override
    public void publishData() {
        for (PieceOfHardware device : this.hardwareList) {
            this.publishHardwareData(device);
        }
    }

    public void publishHardwareData(PieceOfHardware device) {
        StatusDataPublishedByHardware status = FcsUtils.createStatusDataPublishedByHardware(device);
        FCSCst.FCSLOG.debug((Object)(this.name + ":publishHardwareData is publishing:" + status));
        KeyValueData kvd = new KeyValueData("tcpProxy", (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/myClientName=");
        sb.append(this.myClientName);
        return sb.toString();
    }
}

