/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuatorModule;

public class CanOpenLatchActuatorModule
extends LatchActuatorModule {
    private CanOpenDAC dac;
    private final String dacName;
    private int numOfAnalogOutputForSpeedVoltage;
    private int numOfAnalogOutputForCurrentLimit;

    public CanOpenLatchActuatorModule(String aName, int aTickMillis, double currentLimitInVolt, double speedVoltageInVolt, int speedVoltageMinValue, int speedVoltageMaxValue, String dacName, int numOfAnalogOutputForSpeedVoltage, int numOfAnalogOutputForCurrentLimit) {
        super(aName, aTickMillis, currentLimitInVolt, speedVoltageInVolt, speedVoltageMinValue, speedVoltageMaxValue);
        this.dacName = dacName;
        this.numOfAnalogOutputForSpeedVoltage = numOfAnalogOutputForSpeedVoltage;
        this.numOfAnalogOutputForCurrentLimit = numOfAnalogOutputForCurrentLimit;
    }

    public void setNumOfAnalogOutputForSpeedVoltage(int numOfAnalogOutputForSpeedVoltage) {
        this.numOfAnalogOutputForSpeedVoltage = numOfAnalogOutputForSpeedVoltage;
    }

    public void setNumOfAnalogOutputForCurrentLimit(int numOfAnalogOutputForCurrentLimit) {
        this.numOfAnalogOutputForCurrentLimit = numOfAnalogOutputForCurrentLimit;
    }

    public void initModule() {
        this.dac = (CanOpenDAC)this.getComponentByName(this.dacName);
    }

    @Override
    public String open() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        int currentLimitInDecimal = (int)(this.currentLimitInVolt * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
        int speedVoltageInDecimal = (int)(this.speedVoltageInVolt * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, speedVoltageInDecimal);
        return this.getName() + " is OPEN";
    }

    @Override
    public String close() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        int currentLimitInDecimal = (int)(this.getCurrentLimitInVolt() * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
        int speedVoltageInDecimal = (int)(this.getSpeedVoltageInVolt() * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, -speedVoltageInDecimal);
        return this.getName() + " is CLOSED";
    }

    @Override
    public String powerOff() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, 0);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, 0);
        return this.getName() + " is POWER OFF";
    }
}

