/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;

public class CanOpenErrorsTable {
    protected static final Properties deviceErrorCodes = new Properties();
    private static final String DEVICE_ERROR_CODES_FILENAME = "/maxonMotorDeviceErrors.properties";
    protected static final InputStream deviceErrorFile = CanOpenErrorsTable.class.getResourceAsStream("/maxonMotorDeviceErrors.properties");
    protected static final Properties errorRegisterCodes = new Properties();
    private static final String ERROR_REGISTER_CODES_FILENAME = "/errorRegister.properties";
    private static final InputStream errorRegisterFile = CanOpenErrorsTable.class.getResourceAsStream("/errorRegister.properties");
    protected static final Properties commErrorCodes = new Properties();
    private static final String COMM_ERROR_CODES_FILENAME = "/commErrors.properties";
    protected static final InputStream commErrorFile = CanOpenErrorsTable.class.getResourceAsStream("/commErrors.properties");

    public static void loadDeviceErrorTable() throws DeploymentException {
        try {
            FCSCst.FCSLOG.debug((Object)("DEVICE ERROR TABLE= " + deviceErrorFile.toString()));
            deviceErrorCodes.load(deviceErrorFile);
            int size = deviceErrorCodes.size();
            FCSCst.FCSLOG.debug((Object)("Size of the maxon device error codes table = " + size));
        }
        catch (IOException ex) {
            throw new DeploymentException("Error in reading file: /maxonMotorDeviceErrors.properties" + ex);
        }
    }

    public static String getDeviceErrorNameByCode(String aCode) {
        String deviceErrorName = deviceErrorCodes.getProperty(aCode.toUpperCase());
        if (deviceErrorName == null) {
            deviceErrorName = aCode + "=device error code not found in deviceErrorCodes";
        }
        return deviceErrorName;
    }

    public static String getErrorRegisterNameByCode(String aCode) {
        String errorRegisterName = errorRegisterCodes.getProperty(aCode);
        if (errorRegisterName == null) {
            errorRegisterName = aCode + "=error register code not found in errorRegisterCodes";
        }
        return errorRegisterName;
    }

    public static String getCommErrorNameByCode(String aCode) {
        String commErrorName = commErrorCodes.getProperty(aCode);
        if (commErrorName == null) {
            commErrorName = aCode + "=communication error code not found in commErrorCodes";
        }
        return commErrorName;
    }

    public static void loadErrorRegisterTable() throws DeploymentException {
        try {
            FCSCst.FCSLOG.debug((Object)("ERROR REGISTER TABLE=" + errorRegisterFile.toString()));
            errorRegisterCodes.load(errorRegisterFile);
            int size = errorRegisterCodes.size();
            FCSCst.FCSLOG.debug((Object)("Size of the error register codes table = " + size));
        }
        catch (IOException ex) {
            FCSCst.FCSLOG.error((Object)("Error in reading file: /errorRegister.properties" + ex));
            throw new DeploymentException("Error in reading file: /errorRegister.properties" + ex);
        }
    }

    public static void loadCommunicationErrorTable() throws DeploymentException {
        try {
            FCSCst.FCSLOG.debug((Object)("COMMUNICATION ERROR TABLE=" + commErrorFile.toString()));
            commErrorCodes.load(commErrorFile);
            int size = commErrorCodes.size();
            FCSCst.FCSLOG.debug((Object)("Size of the error register codes table = " + size));
        }
        catch (IOException ex) {
            FCSCst.FCSLOG.error((Object)("Error in reading file: /commErrors.properties" + ex));
            throw new DeploymentException("Error in reading file: /commErrors.properties" + ex);
        }
    }

    public static void main(String[] args) throws DeploymentException {
        CanOpenErrorsTable.loadDeviceErrorTable();
        CanOpenErrorsTable.loadErrorRegisterTable();
        CanOpenErrorsTable.loadCommunicationErrorTable();
        String errReg = "10";
        String errorName = errorRegisterCodes.getProperty(errReg);
        System.out.println(errReg + '=' + errorName);
        String errReg2 = "08";
        String errorName2 = CanOpenErrorsTable.getErrorRegisterNameByCode(errReg2);
        System.out.println(errReg2 + '=' + errorName2);
    }
}

