/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import java.util.Observable;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenEPOS
extends CanOpenDevice
implements EPOSController {
    private boolean turnedOff;
    private int actualCurrent;
    private int profileVelocity;
    private boolean parametersOK;
    protected EPOSEnumerations.EposMode mode;
    private String modeInString;
    private final Map<String, Integer> paramsForHoming;
    private final Map<String, Integer> paramsForProfilePosition;
    private final Map<String, Integer> paramsForCurrent;
    private boolean enabledToPublish;
    private boolean inError;
    private String[] errorHistory;
    private String errorRegister;

    public CanOpenEPOS(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.paramsForCurrent = paramsForCurrent;
        this.paramsForProfilePosition = paramsForProfilePosition;
        this.paramsForHoming = paramsForHoming;
        this.actualCurrent = 0;
        this.turnedOff = false;
        this.parametersOK = true;
        this.enabledToPublish = false;
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new String[0];
    }

    @Override
    public boolean isEnabledToPublish() {
        return this.enabledToPublish;
    }

    @Override
    public String getModeInString() {
        return this.modeInString;
    }

    @Override
    public boolean isTurnedOff() {
        return this.turnedOff;
    }

    @Override
    public boolean isParametersOK() {
        return this.parametersOK;
    }

    public void setParametersOK(boolean parametersOK) {
        this.parametersOK = parametersOK;
    }

    @Override
    public String[] getErrorHistory() {
        if (this.errorHistory == null) {
            return new String[0];
        }
        return (String[])this.errorHistory.clone();
    }

    @Override
    public String getErrorRegister() {
        return this.errorRegister;
    }

    @Override
    public boolean isInError() {
        return this.inError;
    }

    @Override
    public Map<String, Integer> getParamsForHoming() {
        return this.paramsForHoming;
    }

    @Override
    public Map<String, Integer> getParamsForProfilePosition() {
        return this.paramsForProfilePosition;
    }

    @Override
    public Map<String, Integer> getParamsForCurrent() {
        return this.paramsForCurrent;
    }

    @Override
    public int getMaxCurrent() throws FcsHardwareException {
        try {
            return this.readParameter(EPOSEnumerations.Parameter.OutputCurrentLimit);
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + ":Error in reading Parameter "));
            FCSCst.FCSLOG.error((Object)ex);
            return 0;
        }
    }

    @Override
    public int getMinCurrent() throws FcsHardwareException {
        try {
            return this.readParameter(EPOSEnumerations.Parameter.OutputCurrentLimit);
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + ":Error in reading Parameter "));
            FCSCst.FCSLOG.error((Object)ex);
            return 0;
        }
    }

    @Override
    public int getMaxSpeed() throws FcsHardwareException {
        try {
            return this.readParameter(EPOSEnumerations.Parameter.MaxProfileVelocity);
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + ":Error in reading Parameter "));
            FCSCst.FCSLOG.error((Object)ex);
            return 0;
        }
    }

    @Override
    public int getMaxPosition() throws FcsHardwareException {
        try {
            return this.readParameter(EPOSEnumerations.Parameter.MaxPositionLimit);
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + ":Error in reading Parameter "));
            FCSCst.FCSLOG.error((Object)ex);
            return 0;
        }
    }

    @Override
    public int getMinPosition() throws FcsHardwareException {
        try {
            return this.readParameter(EPOSEnumerations.Parameter.MinPositionLimit);
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + ":Error in reading Parameter "));
            FCSCst.FCSLOG.error((Object)ex);
            return 0;
        }
    }

    public int getMotorParameterValue(String parameterName) throws EPOSConfigurationException {
        if (this.paramsForCurrent.containsKey(parameterName)) {
            return this.paramsForCurrent.get(parameterName);
        }
        throw new EPOSConfigurationException(parameterName + " :undefined", this.getName());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print the configured parameters for this EPOS for this mode.This command doesn't read the controlle.")
    public String printParameters() throws FcsHardwareException {
        if (this.mode == null) {
            this.mode = this.readMode();
        }
        return this.printConfigurationParameters(this.mode.toString());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print the configured parameters for this EPOS for a mode name given in argument. This command doesn't read the controller.")
    public String printConfigurationParameters(String modeInString) {
        EPOSEnumerations.EposMode aMode = EPOSEnumerations.EposMode.valueOf((String)modeInString.trim().toUpperCase());
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                throw new IllegalArgumentException(modeInString + "  is not a valid EPOS mode");
            }
        }
        return this.printParameters(paramsMap);
    }

    public String printParameters(Map<String, Integer> paramMap) {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("Parameters in this map in configuration file:\n");
        if (paramMap == null) {
            sb.append("NO parameter found in configuration file.");
        } else {
            for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
                String paramName = entry.getKey();
                int value = entry.getValue();
                sb.append("key=");
                sb.append(paramName);
                sb.append("/value=");
                sb.append(value);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Reads the EPOS mode in the CPU of the EPOS device and updates the field mode.")
    public EPOSEnumerations.EposMode readMode() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        EPOSEnumerations.EposMode readMode;
        String modeInHexa = this.readSDO("6061", "0").trim().toUpperCase();
        this.mode = readMode = EPOSEnumerations.EposMode.getMode((String)modeInHexa);
        this.modeInString = readMode.toString();
        return readMode;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print the Epos controller mode without reading controller CPU.")
    public String printMode() {
        return this.mode.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change EPOS mode .")
    public String changeMode(String modeInString) throws FcsHardwareException {
        EPOSEnumerations.EposMode newMode = EPOSEnumerations.EposMode.valueOf((String)modeInString.trim().toUpperCase());
        return this.changeMode(newMode);
    }

    @Override
    public String changeMode(EPOSEnumerations.EposMode newMode) throws FcsHardwareException {
        this.writeSDO("6060", "0", "1", newMode.getModeInHexa());
        this.mode = newMode;
        this.modeInString = newMode.toString();
        this.publishData();
        return this.getName() + " mode has been changed to: " + newMode.toString() + ". Please check parameters associated with this mode.";
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Displays the list of parameters that we have to define for a given mode.")
    public static String displayListParameters(String modeInString) {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters for mode: ");
        sb.append(modeInString);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.EposMode.valueOf((String)modeInString).getParameters()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Displays the list of parameters.")
    public static String displayListParameters() {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters : ");
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.Parameter.values()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="This methods reads in the CPU of the EPOS the values of the parameters for a given mode.")
    public String readParameters(String modeInString) throws FcsHardwareException {
        return this.readParameters(EPOSEnumerations.EposMode.valueOf((String)modeInString));
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode aMode) throws FcsHardwareException {
        EPOSEnumerations.Parameter[] params;
        String modeIS = aMode.toString();
        StringBuilder sb = new StringBuilder(this.name + " parameters VALUES in decimal format for mode ");
        sb.append(modeIS);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = aMode.getParameters()) {
            sb.append(param.toString());
            sb.append("=");
            int valueInt = this.readParameter(param);
            sb.append(valueInt);
            sb.append("\n");
        }
        FCSCst.FCSLOG.debug((Object)(this.name + sb.toString()));
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the parameters for the actual mode.")
    public String readParameters() throws FcsHardwareException {
        String modeStr = this.readMode().toString();
        return this.readParameters(modeStr);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This methods writes in the CPU of the EPOS device the values of the parameters set for the mode.")
    public void writeParameters() throws ErrorInCommandExecutionException, FcsHardwareException {
        this.readMode();
        this.writeParameters(this.mode);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This methods writes in the CPU of the EPOS device the values of the parameters set for the mode given as argument")
    public void writeParameters(String modeInString) throws ErrorInCommandExecutionException, FcsHardwareException {
        EPOSEnumerations.EposMode aMode = EPOSEnumerations.EposMode.valueOf((String)modeInString);
        this.writeParameters(aMode);
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) throws ErrorInCommandExecutionException, FcsHardwareException {
        String modeIS = mode.toString();
        Map<String, Integer> paramsMap = null;
        switch (mode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false) : mode;
                break;
            }
        }
        if (paramsMap == null) {
            throw new ErrorInCommandExecutionException(this.name + "parameters for mode :" + modeIS + "are NULL");
        }
        if (paramsMap.isEmpty()) {
            throw new ErrorInCommandExecutionException(this.name + "parameters for mode :" + modeIS + "are not defined.");
        }
        this.writeParameters(paramsMap);
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) throws FcsHardwareException {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(paramName, value);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the value given as argument.")
    public String writeParameter(String parameterName, int value) throws FcsHardwareException {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.writeParameter(param, value);
    }

    public String writeParameter(EPOSEnumerations.Parameter param, int value) throws FcsHardwareException {
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), Integer.toHexString(value));
        return String.format("%s has been written to the CanEpos CPU, value=%d", param.toString(), value);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the hexadecimal value given as argument.")
    public String writeParameterInHexa(String parameterName, String hexaValue) throws FcsHardwareException {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.writeParameterInHexa(param, hexaValue);
    }

    @Override
    public String writeParameterInHexa(EPOSEnumerations.Parameter param, String hexaValue) throws FcsHardwareException {
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), hexaValue);
        return String.format("%s has been written to the CanEpos CPU, value=%s", param.toString(), hexaValue);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the decimal value of the Parameter which parameter name is given as argument.")
    public int readParameter(String parameterName) throws FcsHardwareException {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.readParameter(param);
    }

    public int readParameter(EPOSEnumerations.Parameter param) throws FcsHardwareException {
        String valueInHexa = this.readSDO(param.getIndex(), param.getSubindex());
        int valueInDecimal = new BigInteger(valueInHexa, 16).intValue();
        FCSCst.FCSLOG.debug((Object)(this.name + " readParameter:" + param.name() + "=" + valueInDecimal + " in decimal format  (valueInHexa=" + valueInHexa + ")"));
        return valueInDecimal;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the hexadecimal value of the Parameter which parameter name is given as argument.")
    public String readParameterInHexa(String parameterName) throws FcsHardwareException {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.readParameterInHexa(param);
    }

    public String readParameterInHexa(EPOSEnumerations.Parameter param) throws FcsHardwareException {
        return this.readSDO(param.getIndex(), param.getSubindex());
    }

    @Override
    public boolean isTargetPositionReached(int position) throws FcsHardwareException {
        return this.readPosition() == position;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.listens(new Observable[]{this.tcpProxy});
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSCst.FCSLOG.debug((Object)(this.name + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (!(source instanceof CanOpenProxy)) {
            return;
        }
        EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
        if (!this.name.equals(emcyMsg.getDeviceName())) {
            return;
        }
        FCSCst.FCSLOG.error((Object)(this.name + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
        this.inError = true;
        try {
            String errorInHexa = this.readErrorRegister();
            this.errorHistory = this.getErrorHistoryNames();
            String errorName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errorInHexa);
            this.errorRegister = errorName == null ? errorInHexa : errorName;
            this.errorHistory = this.getErrorHistoryNames();
            this.publishData();
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + " Error on FCS hardware."), (Throwable)ex);
            this.getSubsystem().raiseAlert(new Alert("FCS001", "Couldn't read EPOS error register for " + this.name), AlertState.ALARM);
        }
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)emcyMsg));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read controller's parameter in the CPU for each mode and warn if a parameter has not the same value as in the configuration.Then publish data.")
    public String initializeAndCheckHardware() throws FcsHardwareException {
        if (!this.isBooted()) {
            throw new FcsHardwareException(this.name + " is not booted - can't be initialized.");
        }
        this.mode = this.readMode();
        this.parametersOK = true;
        this.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        this.checkParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.checkParameters(EPOSEnumerations.EposMode.HOMING);
        this.checkFault();
        this.initialized = true;
        if (!this.parametersOK) {
            FCSCst.FCSLOG.warning((Object)(this.name + " Some parameter values are not" + " the same in CPU and configuration system."));
        }
        this.tcpProxy.publishHardwareData(this);
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.name + ": is INITIALIZED."));
        return this.name + ": is INITIALIZED.";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the controller is enabled.")
    public boolean isEnabled() throws FcsHardwareException {
        try {
            String statusWordInHexa = this.readStatusWord();
            int statusWord = Integer.parseInt(statusWordInHexa, 16);
            int[] statusWordInBinary = FcsUtils.toReverseBinary(statusWord);
            FCSCst.FCSLOG.debug((Object)(this.name + ":statusWordInBinary[0]=" + statusWordInBinary[0]));
            FCSCst.FCSLOG.debug((Object)(this.name + ":statusWordInBinary[1]=" + statusWordInBinary[1]));
            FCSCst.FCSLOG.debug((Object)(this.name + ":statusWordInBinary[2]=" + statusWordInBinary[2]));
            FCSCst.FCSLOG.debug((Object)(this.name + ":statusWordInBinary[3]=" + statusWordInBinary[3]));
            return statusWordInBinary[0] == 1 && statusWordInBinary[1] == 1 && statusWordInBinary[2] == 1 && statusWordInBinary[3] == 0;
        }
        catch (ShortResponseToSDORequestException ex) {
            String msg = this.name + " couldn't read status word because ShortResponseToSDORequestException :" + ex.getMessage();
            FCSCst.FCSLOG.error((Object)msg);
            FCSCst.FCSLOG.error((Object)ex);
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clear faults on the controller.")
    public void faultReset() throws FcsHardwareException {
        this.writeControlWord("80");
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)"faultReset"));
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new String[0];
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="This methods enables the controller : i.e. this makes it able to receive commands.")
    public String enable() throws FcsHardwareException {
        this.shutdown();
        this.switchOnEnableOperation();
        this.enabledToPublish = true;
        FCSCst.FCSLOG.debug((Object)(this.name + ": is ENABLED."));
        return this.name + " ENABLED";
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Shutdown the controller.")
    public String shutdown() throws FcsHardwareException {
        this.writeControlWord("6");
        FCSCst.FCSLOG.debug((Object)(this.name + ": is SHUTDOWN."));
        return this.name + " DISABLED";
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="writeControlWord(\"F\")")
    public void switchOnEnableOperation() throws FcsHardwareException {
        this.writeControlWord("F");
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Restore default parameters. AT YOUR OWN RISK.")
    public Object restoreParameters() throws FcsHardwareException {
        return this.writeSDO("1011", "1", "4", "64616F6C");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Write a value in hexa in the control world (index=6040, subindex=0,size=2)")
    public void writeControlWord(String value) throws FcsHardwareException {
        this.writeSDO("6040", "0", "2", value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the control world (index=6040, subindex=0,size=2)")
    public String readControlWord() throws ShortResponseToSDORequestException, FcsHardwareException {
        return this.readSDO("6040", "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the status world (index=6041, subindex=0,size=2)")
    public String readStatusWord() throws ShortResponseToSDORequestException, FcsHardwareException {
        return this.readSDO("6041", "0");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="QuickStop.")
    public void quickStop() throws FcsHardwareException {
        FCSCst.FCSLOG.debug((Object)(this.name + " running QUICKSTOP command."));
        switch (this.mode) {
            case HOMING: {
                this.writeControlWord("B");
                break;
            }
            case PROFILE_POSITION: {
                this.writeControlWord("B");
                break;
            }
            case PROFILE_VELOCITY: {
                break;
            }
            case POSITION: {
                break;
            }
            case VELOCITY: {
                this.writeControlWord("B");
                break;
            }
            case CURRENT: {
                this.writeControlWord("2");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public String off() throws BadCommandException, FcsHardwareException {
        switch (this.mode) {
            case HOMING: {
                this.writeControlWord("11F");
                break;
            }
            case PROFILE_POSITION: {
                this.writeControlWord("10F");
                break;
            }
            case CURRENT: {
                this.stopCurrent();
                break;
            }
            default: {
                assert (false) : this.mode;
                break;
            }
        }
        this.shutdown();
        this.turnedOff = true;
        FCSCst.FCSLOG.info((Object)(this.name + " is TURNED OFF"));
        return this.name + " OFF";
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Display motor parameters values stored in the EPOS CPU.")
    public String displayMotorParameters() throws FcsHardwareException {
        StringBuilder sb = new StringBuilder("Read decimal values for motor parameters are :");
        int readMotorType = this.readParameter(EPOSEnumerations.Parameter.MotorType);
        int readPositionSensorType = this.readParameter(EPOSEnumerations.Parameter.PositionSensorType);
        int readContinuousCurrentLimit = this.readParameter(EPOSEnumerations.Parameter.ContinuousCurrentLimit);
        int readMaxSpeedInCurrentMode = this.readParameter(EPOSEnumerations.Parameter.MaxSpeedInCurrentMode);
        int readThermalTimeConstantWinding = this.readParameter(EPOSEnumerations.Parameter.ThermalTimeConstantWinding);
        int readOutputCurrentLimit = this.readParameter(EPOSEnumerations.Parameter.OutputCurrentLimit);
        int readPolePairNumber = this.readParameter(EPOSEnumerations.Parameter.PolePairNumber);
        sb.append(" motor type =");
        sb.append(readMotorType);
        sb.append(" position sensor type =");
        sb.append(readPositionSensorType);
        sb.append(" continuousCurrentLimit =");
        sb.append(readContinuousCurrentLimit);
        sb.append(" maxSpeedInCurrentMode =");
        sb.append(readMaxSpeedInCurrentMode);
        sb.append(" thermalTimeConstantWinding =");
        sb.append(readThermalTimeConstantWinding);
        sb.append(" outputCurrentLimit =");
        sb.append(readOutputCurrentLimit);
        sb.append(" polePairNumber =");
        sb.append(readPolePairNumber);
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Set the current value in the EPOS CPU.")
    public void writeCurrent(int aValue) throws BadCommandException, FcsHardwareException {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            throw new BadCommandException(this.name + " is not in CURRENT mode.");
        }
        if (!this.isEnabled()) {
            throw new BadCommandException(this.name + " is not ENABLED.");
        }
        try {
            if (aValue > this.getMotorParameterValue("ContinuousCurrentLimit")) {
                throw new IllegalArgumentException(aValue + " is greater than Continuous Current Limit.");
            }
        }
        catch (EPOSConfigurationException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + " ERROR in command writeCurrent:" + (Object)((Object)ex)));
            throw new BadCommandException(this.name + ": ContinuousCurrentLimit is not defined." + (Object)((Object)ex));
        }
        String currentValueInHexa = Integer.toHexString(aValue);
        this.writeSDO("2030", "0", "2", currentValueInHexa);
        this.turnedOff = false;
        FCSCst.FCSLOG.debug((Object)(this.name + ": sent current to controller=" + aValue));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentActualValue", description="In Current Mode this methods returns the current actualy received by the motor.")
    public int readCurrent() throws BadCommandException, ShortResponseToSDORequestException, FcsHardwareException {
        String currentInHexa = this.readSDO("6078", "0");
        int uns16 = Integer.parseInt(currentInHexa, 16);
        FCSCst.FCSLOG.debug((Object)(this.name + ":readCurrent=" + CanOpenEPOS.convertToInteger16(uns16) + " Unsigned value read=" + uns16));
        this.actualCurrent = CanOpenEPOS.convertToInteger16(uns16);
        return this.actualCurrent;
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentAverage", description="In Current Mode this methods returns the average of the current  received by the motor.")
    public int readCurrentAverageValue() throws BadCommandException, FcsHardwareException {
        String currentInHexa = this.readSDO("2027", "0");
        int uns16 = Integer.parseInt(currentInHexa, 16);
        FCSCst.FCSLOG.debug((Object)(this.name + ":readAverageCurrent=" + CanOpenEPOS.convertToInteger16(uns16) + " Unsigned value read=" + uns16));
        return CanOpenEPOS.convertToInteger16(uns16);
    }

    public void stopCurrent() throws BadCommandException, FcsHardwareException {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            throw new BadCommandException(this.getName() + "is not in CURRENT mode");
        }
        this.writeSDO("2030", "00", "2", "0");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readPositionActualValue", description="In PROFILE_POSITION Mode this methods returns the actual position.")
    public int readPosition() throws ShortResponseToSDORequestException, FcsHardwareException {
        int positionActualValue = this.readParameter(EPOSEnumerations.Parameter.PositionActualValue);
        FCSCst.FCSLOG.debug((Object)(this.name + ":readPosition=" + positionActualValue));
        return positionActualValue;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read the position returned by the absolute encoder (single serial data).")
    public int readSSIPosition() throws ShortResponseToSDORequestException, FcsHardwareException {
        return this.readParameter(EPOSEnumerations.Parameter.SSIEncoderActualPosition);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileVelocity.")
    public int readProfileVelocity() throws ShortResponseToSDORequestException, FcsHardwareException {
        this.profileVelocity = this.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
        FCSCst.FCSLOG.debug((Object)(this.name + ":readProfileVelocity=" + this.profileVelocity));
        return this.profileVelocity;
    }

    public String setHomingMethodActual() throws BadCommandException, FcsHardwareException {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.HOMING)) {
            throw new BadCommandException(this.getName() + "is not in HOMING mode");
        }
        return this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
    }

    public void startHoming() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.HOMING)) {
            throw new BadCommandException(this.getName() + "is not in HOMING mode");
        }
        this.writeControlWord("1F");
    }

    public String setHomePosition(int position) throws BadCommandException, FcsHardwareException {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.HOMING)) {
            throw new BadCommandException(this.getName() + "is not in HOMING mode");
        }
        return this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    public void defineAbsolutePosition(int position) throws ErrorInCommandExecutionException, BadCommandException, FcsHardwareException {
        FCSCst.FCSLOG.debug((Object)(this.name + " Defining Absolute Position:" + position));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameters(EPOSEnumerations.EposMode.HOMING);
        if (!this.isEnabled()) {
            this.enable();
        }
        this.setHomePosition(position);
        this.setHomingMethodActual();
        this.writeControlWord("3F");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position. Target position has to be given in microns.")
    public void writeTargetPosition(int aValue) throws BadCommandException, FcsHardwareException {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new BadCommandException(this.name + "is not in PROFILE_POSITION mode");
        }
        if (!this.isEnabled()) {
            throw new BadCommandException(this.name + "is not ENABLED");
        }
        String targetPositionInHexa = Integer.toHexString(aValue);
        this.writeSDO("607A", "0", "4", targetPositionInHexa);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="In HOMING mode and PROFILE_POSITION mode this indicates that the position is reached.")
    public boolean checkTargetReached() throws FcsHardwareException {
        String statusWordInHexa = this.readStatusWord();
        int statusWord = Integer.parseInt(statusWordInHexa, 16);
        int[] statusWordInBinary = FcsUtils.toReverseBinary(statusWord);
        return statusWordInBinary[10] == 1;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() throws FcsHardwareException {
        if (!this.booted) {
            throw new FcsHardwareException(this.name + " is not booted - can't checkFault.");
        }
        int controllerNbOfErrors = this.readNumberOfErrors();
        if (controllerNbOfErrors > 0) {
            this.inError = true;
            String errorInHexa = this.readErrorRegister();
            String errorName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errorInHexa);
            this.errorRegister = errorName == null ? errorInHexa : errorName;
            this.errorHistory = this.getErrorHistoryNames();
            this.setChanged();
            this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)"checkFault"));
            this.publishData();
            String errorHistoryString = this.displayErrorHistory();
            throw new FcsHardwareException(this.name + " is in fault. " + errorHistoryString);
        }
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new String[0];
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)"checkFault"));
        this.publishData();
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) throws FcsHardwareException {
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (paramsMap == null) {
            throw new FcsHardwareException(this.name + "parameters for mode :" + aMode.toString() + "are NULL in configuration system.");
        }
        if (paramsMap.isEmpty()) {
            throw new FcsHardwareException(this.name + "parameters for mode :" + aMode.toString() + "are not defined in configuration system.");
        }
        this.checkParameters(paramsMap);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="For every parameter to be defined for this mode this method compares the values in configuration with the value stored in controller CPUand throws a HardwareException if these values are not equal.")
    public void checkParameters(String modeInString) throws FcsHardwareException {
        EPOSEnumerations.EposMode aMode = EPOSEnumerations.EposMode.valueOf((String)modeInString.trim().toUpperCase());
        this.checkParameters(aMode);
    }

    public void checkParameters(Map<String, Integer> paramsMap) throws FcsHardwareException {
        boolean errorFound = false;
        StringBuilder sb = new StringBuilder(this.name);
        for (Map.Entry<String, Integer> entry : paramsMap.entrySet()) {
            int controllerValue;
            String paramName = entry.getKey();
            int configValue = entry.getValue();
            if (configValue == (controllerValue = this.readParameter(paramName))) continue;
            String msg = " ERROR in CPU controller for parameter=" + paramName + " value found in configuration=" + configValue + " value read in CPU=" + controllerValue + "\n";
            FCSCst.FCSLOG.warning((Object)(this.name + msg));
            sb.append(msg);
            errorFound = true;
            this.writeParameter(paramName, configValue);
        }
        this.parametersOK = !errorFound;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to CURRENT mode and initialize theCURRENT mode parameters from configuration values.")
    public void activateCurrentMode() throws FcsHardwareException {
        this.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.writeParameters(this.paramsForCurrent);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to HOMING mode and initialize theHOMING mode parameters from configuration values.")
    public void activateHomingMode() throws FcsHardwareException {
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameters(this.paramsForHoming);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change mode to PROFILE_POSITION mode and initialize thePROFILE_POSITION mode parameters from configuration values.")
    public void activateProfilePositionMode() throws FcsHardwareException {
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeParameters(this.paramsForProfilePosition);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Put the brake on to prevent the trucks motion.")
    public void activateBrake() throws FcsHardwareException {
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2zero(hexaValue, 15));
        FCSCst.FCSLOG.debug((Object)(this.name + ": brake activated."));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Release the brake in order to be able to move the trucks.")
    public void releaseBrake() throws FcsHardwareException {
        if (!this.isEnabled()) {
            this.enable();
        }
        String hexaValue = this.readParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2one(hexaValue, 15));
        FCSCst.FCSLOG.debug((Object)(this.name + ": brake released."));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Activate the holding brake and shutdown the controller.")
    public void disable() throws FcsHardwareException {
        this.activateBrake();
        this.shutdown();
        this.enabledToPublish = false;
    }

    public StatusDataPublishedByEPOSController getStatusData() {
        StatusDataPublishedByEPOSController status = FcsUtils.createStatusDataPublishedByEPOSController(this);
        return status;
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="refreshGUI", description="Publish data for the controller on the status bus.")
    public void publishData() {
        StatusDataPublishedByEPOSController status = this.getStatusData();
        KeyValueData kvd = new KeyValueData(this.name, (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }

    public static int convertToInteger16(int unsigned16) {
        if (unsigned16 < 32768) {
            return unsigned16;
        }
        return unsigned16 - 65535;
    }

    public static void main(String[] args) {
        System.out.println(CanOpenEPOS.displayListParameters("HOMING"));
        System.out.println(CanOpenEPOS.displayListParameters("CURRENT"));
        System.out.println(CanOpenEPOS.displayListParameters("PROFILE_POSITION"));
        System.out.println(CanOpenEPOS.displayListParameters());
    }
}

