/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.nio.file.FileSystemNotFoundException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public abstract class BridgeToCanOpenHardware
extends Module
implements BridgeToHardware {
    protected CanOpenProxy tcpProxy;
    protected boolean configurationChecked;
    protected boolean hardwareInitialized;
    protected Map<String, PieceOfHardware> hardwareMap;

    public BridgeToCanOpenHardware(String aName, int aTickMillis, CanOpenProxy tcpProxy) {
        super(aName, aTickMillis);
        this.tcpProxy = tcpProxy;
        this.configurationChecked = false;
        this.hardwareInitialized = false;
    }

    public PieceOfHardware[] listHardware() {
        LinkedHashMap children = this.getChildren(PieceOfHardware.class);
        PieceOfHardware[] list = new PieceOfHardware[children.size()];
        int i = 0;
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            FCSCst.FCSLOG.debug((Object)("key=" + key));
            PieceOfHardware device = (PieceOfHardware)entry.getValue();
            FCSCst.FCSLOG.debug((Object)("hardware=" + device.getName() + "#" + device.toString()));
            list[i] = device;
            ++i;
        }
        return list;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print my children; for tests")
    public void printChildren() {
        LinkedHashMap children = this.getChildren(PieceOfHardware.class);
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            FCSCst.FCSLOG.debug((Object)("key=" + key));
            PieceOfHardware device = (PieceOfHardware)entry.getValue();
            FCSCst.FCSLOG.debug((Object)("hardware=" + device.getName() + "#" + device.toString()));
        }
    }

    @Override
    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    @Override
    public void startServer() {
        this.tcpProxy.startServer();
    }

    @Override
    public void startThreadReader() {
        this.tcpProxy.startThreadReader();
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.tcpProxy.isReady(this.tcpProxy.getMyClientName());
    }

    @Override
    public boolean isHardwareReady() {
        return this.tcpProxy.isHardwareReady();
    }

    @Override
    public boolean isRealHardware() {
        return true;
    }

    public void initModule() {
        FCSCst.FCSLOG.info((Object)(this.name + ": init MODULE BRIDGE TO HARDWARE."));
        this.hardwareMap = this.getChildren(PieceOfHardware.class);
        PieceOfHardware[] hardwareList = this.listHardware();
        this.tcpProxy.setHardwareList(hardwareList);
        FCSCst.FCSLOG.info((Object)(this.name + ":NUMBER OF CAN OPEN DEVICES EXPECTED =" + hardwareList.length));
        FCSCst.FCSLOG.info((Object)this.toString());
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            String msg = (Object)((Object)ex) + ": Could not load CanOpen Error Tables";
            FCSCst.FCSLOG.error((Object)msg);
            throw new FileSystemNotFoundException(msg);
        }
    }

    public Object sendCanOpen(String command) throws InterruptedException, CanOpenCallTimeoutException, BadCommandException, FcsHardwareException {
        return this.tcpProxy.sendCanOpenCommand(command);
    }

    @Override
    public PDOStorage readPDOs() throws FcsHardwareException, BadCommandException {
        FCSCst.FCSLOG.debug((Object)(this.name + "/readPDOS"));
        return this.tcpProxy.readPDOs();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(": tickmillis=");
        sb.append(String.valueOf(this.tickMillis));
        sb.append(", tcpProxy=");
        sb.append(String.valueOf(this.tcpProxy.toString()));
        return sb.toString();
    }
}

