/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;

public abstract class Sensor14bits
extends Module
implements Sensor {
    protected int value;
    private volatile boolean updatingValue = false;
    private final Lock lock = new ReentrantLock();
    private final Condition valueUpdated = this.lock.newCondition();

    public Sensor14bits(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
    }

    public void initModule() {
        this.updatingValue = false;
        this.value = 0;
    }

    @Override
    public int getValue() {
        this.lock.lock();
        try {
            while (this.updatingValue) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ex.getMessage()));
                }
            }
            int n = this.value;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setValue(int aValue) {
        this.value = aValue;
    }

    @Override
    public void updateValue() throws SensorValueOutOfRangeException, FcsHardwareException {
        this.lock.lock();
        try {
            this.updatingValue = true;
            int newValue = this.readNewValue();
            if (newValue < 0 || newValue > Short.MAX_VALUE) {
                throw new SensorValueOutOfRangeException("ERROR in Sensor14bits during updateValue for ", this.getName(), 0, Short.MAX_VALUE, newValue);
            }
            this.value = newValue;
        }
        finally {
            this.updatingValue = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    public abstract int updateValue(PDOStorage var1);

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns the value of the sensor stored in FCS memory.")
    public String printValue() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/value=");
        sb.append(this.value);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/returned value=");
        sb.append(Integer.toString(this.value));
        return sb.toString();
    }
}

