/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.io.Serializable;
import java.util.HashMap;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.PDOBadResponseException;

public class PDOStorage
implements Serializable {
    private static final long serialVersionUID = 2487036147845829605L;
    private final String sep = "_";
    private final String varSuffixe = "ADC";
    private final HashMap<String, String> mapSensorsValues = new HashMap();

    public void updatePDOs(String pdoLine) throws PDOBadResponseException {
        FCSCst.FCSLOG.finest((Object)(": pdoLine=" + pdoLine));
        String[] words = pdoLine.split(",");
        FCSCst.FCSLOG.finest((Object)(": words.length=" + words.length));
        for (int ix = 1; ix < words.length; ++ix) {
            String[] toStore = words[ix].split("=");
            String varName = toStore[0];
            String varValue = toStore[1];
            String[] mots = varName.split("_");
            String nodeID = mots[0].substring(3);
            FCSCst.FCSLOG.finest((Object)String.format("%nwords(%s):%s nodeID=%s", ix, words[ix], nodeID));
            if (mots.length <= 1) {
                FCSCst.FCSLOG.error((Object)("Received a bad response from PDO request: " + pdoLine));
                throw new PDOBadResponseException("Received a bad response from PDO request.", pdoLine);
            }
            this.mapSensorsValues.put(varName, varValue);
        }
    }

    public String getVarValue(String nodeID, String inputNB) {
        String token = "ADC" + nodeID + "_" + inputNB;
        return this.mapSensorsValues.get(token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PDO STORAGE:");
        sb.append("(SIZE=").append(this.mapSensorsValues.size()).append(")");
        sb.append(this.mapSensorsValues.toString());
        return sb.toString();
    }
}

