/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public interface EPOSController
extends PieceOfHardware {
    public boolean isTurnedOff();

    public String off() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException;

    public int getMaxCurrent() throws FcsHardwareException;

    public int getMinCurrent() throws FcsHardwareException;

    public int getMaxSpeed() throws FcsHardwareException;

    public int getMaxPosition() throws FcsHardwareException;

    public int getMinPosition() throws FcsHardwareException;

    public boolean isParametersOK();

    public String changeMode(EPOSEnumerations.EposMode var1) throws SDORequestException, FcsHardwareException;

    @Command(type=Command.CommandType.ACTION, level=1, description="Defines the actual position as the absolute position which value is given as an argument.")
    public void defineAbsolutePosition(int var1) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException, FcsHardwareException;

    public int readNumberOfErrors() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public String displayErrorHistory() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void checkFault() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void writeParameters(EPOSEnumerations.EposMode var1) throws SDORequestException, ErrorInCommandExecutionException, FcsHardwareException;

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int var1) throws BadCommandException, SDORequestException, FcsHardwareException;

    public void writeParameters(Map<String, Integer> var1) throws SDORequestException, FcsHardwareException;

    @Command(type=Command.CommandType.ACTION, level=1, description="In current mode this methods send a current to the motor.")
    public void writeCurrent(int var1) throws BadCommandException, EPOSConfigurationException, SDORequestException, FcsHardwareException;

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the target position has been reached.")
    public boolean isTargetPositionReached(int var1) throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public int readPosition() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public int readSSIPosition() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public int readCurrent() throws BadCommandException, SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public String readParameters(EPOSEnumerations.EposMode var1) throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public int readProfileVelocity() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public String enable() throws SDORequestException, FcsHardwareException;

    public boolean isEnabled() throws SDORequestException, FcsHardwareException;

    public EPOSEnumerations.EposMode readMode() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void quickStop() throws SDORequestException, FcsHardwareException;

    public void checkParameters(String var1) throws HardwareException, FcsHardwareException, SDORequestException, ShortResponseToSDORequestException;

    public void checkParameters(EPOSEnumerations.EposMode var1) throws HardwareException, FcsHardwareException, SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void writeControlWord(String var1) throws SDORequestException, FcsHardwareException;

    public String shutdown() throws SDORequestException, FcsHardwareException;

    public boolean checkTargetReached() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void activateBrake() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void releaseBrake() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void switchOnEnableOperation() throws SDORequestException, FcsHardwareException;

    public Map<String, Integer> getParamsForCurrent();

    public Map<String, Integer> getParamsForHoming();

    public Map<String, Integer> getParamsForProfilePosition();

    public boolean isEnabledToPublish();

    public boolean isInError();

    public String getErrorRegister();

    public String[] getErrorHistory();

    public String getModeInString();

    public String writeParameterInHexa(EPOSEnumerations.Parameter var1, String var2) throws SDORequestException, FcsHardwareException;

    public void disable() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;
}

