/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public abstract class PlutoGatewayModule
extends Module
implements PlutoGatewayInterface,
PieceOfHardware {
    protected String[] hexaValues;
    protected int analogValue;
    protected volatile boolean updatingValues = false;
    protected final Lock lock = new ReentrantLock();
    protected final Condition valueUpdated = this.lock.newCondition();

    public PlutoGatewayModule(String string, int i) {
        super(string, i);
        this.hexaValues = new String[6];
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        this.analogValue = 0;
    }

    public void initModule() {
    }

    public String[] getHexaValues() {
        this.lock.lock();
        try {
            while (this.updatingValues) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ex.getMessage()));
                }
            }
            String[] stringArray = this.hexaValues;
            return stringArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getAnalogValue() {
        this.lock.lock();
        try {
            while (this.updatingValues) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ex.getMessage()));
                }
            }
            int n = this.analogValue;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateValues() throws FcsHardwareException {
        this.lock.lock();
        try {
            this.updatingValues = true;
            this.hexaValues = this.readNewHexaValues();
            FCSCst.FCSLOG.finest((Object)(this.getName() + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0] + " hexaValues[1]=" + this.hexaValues[1]));
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    public void updateAnalogValue() throws FcsHardwareException {
        this.lock.lock();
        try {
            this.updatingValues = true;
            this.analogValue = this.readNewAnalogValue();
            FCSCst.FCSLOG.finest((Object)(this.getName() + " ANALOG VALUE READ=" + this.analogValue));
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/byte no0=");
        sb.append(String.valueOf(this.hexaValues[0]));
        sb.append("/byte no1=");
        sb.append(String.valueOf(this.hexaValues[1]));
        sb.append("/byte no2=");
        sb.append(String.valueOf(this.hexaValues[2]));
        sb.append("/byte no3=");
        sb.append(String.valueOf(this.hexaValues[3]));
        sb.append("/analogValue=");
        sb.append(String.valueOf(this.analogValue));
        return sb.toString();
    }
}

