/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.TcpProxyInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public abstract class MainModule
extends Module {
    protected BridgeToHardware bridge;
    protected boolean hardwareReady = false;
    protected AtomicBoolean haltRequired;
    protected AtomicBoolean stopRequired;

    public MainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis);
        this.bridge = bridge;
    }

    public AtomicBoolean getHaltRequired() {
        return this.haltRequired;
    }

    public AtomicBoolean getStopRequired() {
        return this.stopRequired;
    }

    public void initModule() {
        this.haltRequired = new AtomicBoolean(false);
        this.stopRequired = new AtomicBoolean(false);
        String msg = this.controlRealHardware() ? "Real Hardware" : "Simulation";
        FCSCst.FCSLOG.info((Object)(this.name + "==>" + msg));
    }

    public void postStart() throws HardwareException {
        super.postStart();
        FCSCst.FCSLOG.fine((Object)(this.name + ":postStart begins."));
        try {
            this.updateStateWithSensors();
        }
        catch (BadCommandException | ErrorInCommandExecutionException | FcsHardwareException ex) {
            throw new HardwareException(true, ex);
        }
        FCSCst.FCSLOG.fine((Object)(this.name + ":postStart ends."));
    }

    @Command(level=1, type=Command.CommandType.QUERY, description="Return true if hardware is booted, identified and initialized.")
    public boolean isHardwareReady() {
        if (this.hardwareReady) {
            return this.hardwareReady;
        }
        this.hardwareReady = this.bridge.isHardwareReady();
        return this.hardwareReady;
    }

    @Command(type=Command.CommandType.QUERY, description="Return true if this main module controls real hardware.")
    public boolean controlRealHardware() {
        return this.bridge.isRealHardware();
    }

    @Command(level=1, description="Return the list of CANopen hardware that this subsystem manages.", type=Command.CommandType.QUERY)
    public String listHardware() {
        return this.bridge.getTcpProxy().listHardware();
    }

    @Command(level=1, description="Return the list of CANopen hardware that this subsystem manages.", type=Command.CommandType.QUERY)
    public List<String> listHardwareNames() {
        return this.bridge.getTcpProxy().listHardwareNames();
    }

    @Command(type=Command.CommandType.QUERY, description="Return the list of names of filters  that this subsystem manages.", level=1, alias="listFilterNames")
    public List<String> getFilterNames() {
        FilterManager filterManager = (FilterManager)((Object)this.getComponentByName("filterManager"));
        if (filterManager == null) {
            return Collections.EMPTY_LIST;
        }
        return filterManager.getFilterNamesSortedByFilterID();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.getTcpProxy().publishData();
    }

    public TcpProxyInterface getTcpProxy() {
        return this.bridge.getTcpProxy();
    }

    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                FCSCst.FCSLOG.debug((Object)"HALT required");
                this.haltRequired.set(true);
                break;
            }
            case STOP: {
                FCSCst.FCSLOG.debug((Object)"STOP required");
                this.stopRequired.set(true);
                break;
            }
            case INTERRUPT1: {
                break;
            }
            case INTERRUPT2: {
                break;
            }
            case RE_START: {
                this.haltRequired.set(false);
                this.stopRequired.set(false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return TreeWalkerDiag.GO;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="For tests purpose only - raise an ALERT.")
    public void simulateAlert(String errorId, String alarmMsg) {
        FCSCst.FCSLOG.error((Object)"A fake Alert has been raised.");
        String message = alarmMsg == null ? "COUCOU c'est une blague !" : alarmMsg;
        String fcsErrorId = errorId == null ? "FCS002" : errorId;
        Alert alert = new Alert(fcsErrorId, message);
        this.getSubsystem().raiseAlert(alert, AlertState.ALARM);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="For tests purpose only - raise an ALERT.")
    public void simulateWarning(String errorId, String alarmMsg) {
        FCSCst.FCSLOG.error((Object)"A fake Alert has been raised.");
        String message = alarmMsg == null ? "COUCOU c'est une blague !" : alarmMsg;
        String fcsErrorId = errorId == null ? "FCS002" : errorId;
        Alert alert = new Alert(fcsErrorId, message);
        this.getSubsystem().raiseAlert(alert, AlertState.WARNING);
    }

    public String toString() {
        return super.toString();
    }
}

