/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class LoaderClampModule
extends MobileItemModule {
    private final LoaderHookModule hook1;
    private final LoaderHookModule hook2;
    private final LoaderHookModule hook3;
    private final LoaderHookModule hook4;
    private EPOSController hooksController;
    private LoaderModule loader;
    private FcsEnumerations.LockStatus lockStatus;
    private long timeoutForClosingHooks;
    private long timeoutForClampingHooks;
    private long timeoutForOpeningHooks;
    private long timeoutForGoingToHomePosition;
    private volatile boolean initialized;
    private final Condition stateUpdated;
    protected volatile boolean updatingState;
    private int position;
    private int minPosition;
    private int maxPosition;
    private final int minCurrent;
    private final int maxCurrent;
    private int targetPositionToOpen;
    private int targetPositionToClose;
    private int targetPositionToClamp;
    private int currentToClamp;
    private int currentToGoHome;
    private int readCurrent;
    private final Map<String, Integer> paramsForCurrentToGoHome;
    private final Map<String, Integer> paramsForCurrentToClamp;

    public LoaderClampModule(String moduleName, int aTickMillis, LoaderHookModule hook1, LoaderHookModule hook2, LoaderHookModule hook3, LoaderHookModule hook4, long timeoutForClosingHooks, long timeoutForClosingHooksStrongly, long timeoutForOpeningHooks, long timeoutForGoingToHomePosition, int targetPositionToOpen, int targetPositionToClose, int targetPositionToCloseStrongly, int currentToClose, int currentToGoHome, Map<String, Integer> paramsForCurrentToClamp, Map<String, Integer> paramsForCurrentToGoHomePosition, int minPosition, int maxPosition, int minCurrent, int maxCurrent) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
        this.initialized = false;
        this.timeoutForClosingHooks = timeoutForClosingHooks;
        this.timeoutForClampingHooks = timeoutForClosingHooksStrongly;
        this.timeoutForOpeningHooks = timeoutForOpeningHooks;
        this.timeoutForGoingToHomePosition = timeoutForGoingToHomePosition;
        this.targetPositionToOpen = targetPositionToOpen;
        this.targetPositionToClose = targetPositionToClose;
        this.targetPositionToClamp = targetPositionToCloseStrongly;
        this.currentToClamp = currentToClose;
        this.currentToGoHome = currentToGoHome;
        this.paramsForCurrentToClamp = paramsForCurrentToClamp;
        this.paramsForCurrentToGoHome = paramsForCurrentToGoHomePosition;
        this.minPosition = minPosition;
        this.maxPosition = maxPosition;
        this.minCurrent = minCurrent;
        this.maxCurrent = maxCurrent;
    }

    public int getFilterPresenceSensorValue() {
        return this.loader.getFilterPresenceSensor0().getDigitalValue();
    }

    public LoaderHookModule getHook1() {
        return this.hook1;
    }

    public LoaderHookModule getHook2() {
        return this.hook2;
    }

    public LoaderHookModule getHook3() {
        return this.hook3;
    }

    public LoaderHookModule getHook4() {
        return this.hook4;
    }

    public int getPosition() {
        return this.position;
    }

    public int getMinPosition() {
        return this.minPosition;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public int getMinCurrent() {
        return this.minCurrent;
    }

    public int getMaxCurrent() {
        return this.maxCurrent;
    }

    public int getTargetPositionToOpen() {
        return this.targetPositionToOpen;
    }

    public int getTargetPositionToClose() {
        return this.targetPositionToClose;
    }

    public int getTargetPositionToClamp() {
        return this.targetPositionToClamp;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public int getCurrentToGoHome() {
        return this.currentToGoHome;
    }

    public int getReadCurrent() {
        return this.readCurrent;
    }

    @ConfigChanger
    public long getTimeoutForClosingHooks() {
        return this.timeoutForClosingHooks;
    }

    public long getTimeoutForClampingHooks() {
        return this.timeoutForClampingHooks;
    }

    public long getTimeoutForOpeningHooks() {
        return this.timeoutForOpeningHooks;
    }

    @ConfigChanger
    public long getTimeoutForGoingToHomePosition() {
        return this.timeoutForGoingToHomePosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @ConfigChanger
    public void setTimeoutForClosingHooks(long timeoutForClosingHooks) {
        this.timeoutForClosingHooks = timeoutForClosingHooks;
    }

    @ConfigChanger
    public void setTimeoutForClampingHooks(long timeoutForClampingHooks) {
        this.timeoutForClampingHooks = timeoutForClampingHooks;
    }

    @ConfigChanger
    public void setTimeoutForOpeningHooks(long timeoutForOpeningHooks) {
        this.timeoutForOpeningHooks = timeoutForOpeningHooks;
    }

    @ConfigChanger
    public void setTimeoutForGoingToHomePosition(long timeoutForGoingToHomePosition) {
        this.timeoutForGoingToHomePosition = timeoutForGoingToHomePosition;
    }

    @ConfigChanger
    public void setMinPosition(int minPosition) {
        if (minPosition > this.maxPosition) {
            throw new IllegalArgumentException(this.name + "minPosition can't be > maxPosition; maxPosition=" + this.maxPosition);
        }
        this.minPosition = minPosition;
    }

    @ConfigChanger
    public void setMaxPosition(int maxPosition) {
        if (this.minPosition > maxPosition) {
            throw new IllegalArgumentException(this.name + "maxPosition can't be < minPosition; minPosition=" + this.minPosition);
        }
        this.maxPosition = maxPosition;
    }

    @ConfigChanger
    public void setTargetPositionToOpen(int targetPositionToOpen) {
        this.targetPositionToOpen = targetPositionToOpen;
    }

    @ConfigChanger
    public void setTargetPositionToClose(int targetPositionToClose) {
        this.targetPositionToClose = targetPositionToClose;
    }

    @ConfigChanger
    public void setTargetPositionToClamp(int targetPositionToClamp) {
        this.targetPositionToClamp = targetPositionToClamp;
    }

    @ConfigChanger
    public void setCurrentToClamp(int currentToClamp) {
        this.currentToClamp = currentToClamp;
    }

    @ConfigChanger
    public void setCurrentToGoHome(int currentToGoHome) {
        this.currentToGoHome = currentToGoHome;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.name + ": interrupted in getLockStatus."));
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED")
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isUnlocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isInError() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.ERROR);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader is empty.")
    public boolean isEmpty() {
        return this.loader.isEmpty();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader hardware is connected and ready.")
    public boolean isHardwareReady() {
        return this.loader.isHardwareReady();
    }

    @Override
    public void initModule() {
        this.hooksController = (EPOSController)this.getComponentByName("hooksController");
        this.loader = (LoaderModule)((Object)this.getComponentByName("loader"));
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        if (this.hooksController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.hooksController)});
        }
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        EPOSController ctrl;
        FCSLOG.debug((Object)(this.name + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (!(source instanceof EPOSController)) {
            return;
        }
        if (v.getValue() instanceof EmergencyMessage) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            FCSLOG.debug((Object)(this.name + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
            if (this.hooksController.getName().equals(emcyMsg.getDeviceName())) {
                String errCode;
                switch (errCode = emcyMsg.getDeviceErrorCode()) {
                    case "00": {
                        FCSLOG.debug((Object)(this.name + ":faultReset ?=" + emcyMsg.toString()));
                        String errorMsg = ": a faultReset has been performed on the controller.";
                        this.getSubsystem().raiseAlert(new Alert("FCS006:" + this.name, errorMsg), AlertState.WARNING);
                        break;
                    }
                    default: {
                        FCSLOG.debug((Object)(this.name + ":EmergencyMessage received for " + "loader controller from CanOpenProxy=" + emcyMsg.toString()));
                        String errorMsg = ": Controller in Error.";
                        this.getSubsystem().raiseAlert(new Alert("FCS006:" + this.name, errorMsg), AlertState.ALARM);
                    }
                }
                this.publishData();
            }
        } else if (v.getValue() instanceof String && (ctrl = (EPOSController)((Object)source)).getName().equals(this.hooksController.getName()) && "faultReset".equals((String)v.getValue())) {
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is open and at home position")
    public boolean isAtHomePosition() throws SDORequestException {
        return this.position == 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is closed and at clamped position")
    public boolean isAtClampedPosition() throws SDORequestException {
        return this.targetPositionToClamp - 1000 <= this.position && this.targetPositionToClamp <= this.position + 1000;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at closed position.")
    public boolean isAtClosedPosition() throws SDORequestException {
        return this.position == this.targetPositionToClose;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at open position.")
    public boolean isAtOpenPosition() throws SDORequestException {
        return this.position == this.targetPositionToOpen;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="If loader is empty, go to home position otherwise go to clamped position.", alias="homing")
    public void initializeHardware() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.updateStateWithSensors();
        this.publishData();
        if (this.isInError()) {
            String msg = this.name + " in ERROR state. Can't initialize hardware.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (!this.hooksController.isInitialized()) {
            throw new FcsHardwareException(this.name + ": hooksController has to be initialized.");
        }
        if (this.isEmpty()) {
            this.goToHomePosition();
        } else {
            this.goToClampedPosition();
        }
        this.initialized = true;
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.hooksController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + ":" + (Object)((Object)ex)));
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void tick() {
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to clamped position to intialize hardware.")
    public String goToClampedPosition() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!this.loader.isConnectedOnCamera()) {
            throw new BadCommandException(this.name + " Loader not connected - can't execute command goToClampedPosition.");
        }
        this.updateStateWithSensors();
        if (this.isInError()) {
            String msg = this.name + " in ERROR state - can't execute command goToClampedPosition.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (this.isEmpty()) {
            throw new BadCommandException(this.name + "No filter in carrier -  can't execute command goToClampedPosition.");
        }
        this.updatePosition();
        if (this.initialized && this.isAtClampedPosition()) {
            String msg = this.name + " is already at clamped position - nothing to do.";
            FCSLOG.warning((Object)msg);
            return msg;
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to home position to initialize hardware.")
    public String goToHomePosition() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.updateStateWithSensors();
        if (this.isInError()) {
            String msg = this.name + " in ERROR state - can't execute command goToHomePosition.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (!this.loader.isConnectedOnCamera()) {
            throw new BadCommandException(this.name + " Loader hardware not connected on camera - " + "can't execute command goToHomePosition.");
        }
        if (!this.initialized && !this.isEmpty()) {
            throw new BadCommandException(this.name + " There is a filter in carrier - can't execute command goToHomePosition.");
        }
        if (this.initialized && !this.isEmpty() && !this.loader.isAutochangerHoldingFilter()) {
            throw new BadCommandException(this.name + " There is a filter in carrier and Autochanger is not holding filter - " + "can't execute command goToHomePosition. ");
        }
        this.updatePosition();
        if (this.initialized && this.isAtHomePosition()) {
            String msg = this.name + " is already at home position - nothing to do.";
            FCSLOG.warning((Object)msg);
            return msg;
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION, this.timeoutForGoingToHomePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close clamp.")
    public String close() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.loader.checkPreConditionsForClosingHooks();
        if (this.isAtClosedPosition()) {
            String msg = this.name + ": is already closed.";
            FCSLOG.error((Object)msg);
            throw new BadCommandException(msg);
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS, this.timeoutForClosingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp clamp.")
    public String clamp() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.loader.checkPreConditionsForClosingHooks();
        if (!this.isLocked()) {
            throw new BadCommandException(this.name + " has to be LOCKED first. Close hooks prior clamp.");
        }
        if (this.loader.isAutochangerHoldingFilter()) {
            throw new BadCommandException(this.name + " Autochanger is holding filter. Open autochanger latches before " + "clamping loader hooks.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open clamp.")
    public String open() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.loader.checkPreConditionsForOpeningHooks();
        return this.executeAction(FcsEnumerations.MobileItemAction.OPENLOADERHOOKS, this.timeoutForOpeningHooks);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        int DELTA = 5;
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                FCSLOG.debug((Object)("readCurrent=" + this.readCurrent + " currentToClamp=" + this.currentToClamp));
                return this.currentToClamp - DELTA <= this.readCurrent && this.readCurrent <= this.currentToClamp + DELTA;
            }
            case GOTOHOMEPOSITION: {
                FCSLOG.debug((Object)("readCurrent=" + this.readCurrent + " currentToGoHome=" + this.currentToGoHome));
                return this.currentToGoHome - DELTA <= this.readCurrent && this.readCurrent <= this.currentToGoHome + DELTA;
            }
            case CLOSELOADERHOOKS: {
                return this.position == this.targetPositionToClose;
            }
            case CLAMPLOADERHOOKS: {
                return this.currentToClamp - DELTA <= this.readCurrent && this.readCurrent <= this.currentToClamp + DELTA;
            }
            case OPENLOADERHOOKS: {
                return this.position == this.targetPositionToOpen;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
        if (this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.OPENLOADERHOOKS)) {
            this.position = this.hooksController.readPosition();
        } else if (this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS)) {
            this.readCurrent = this.hooksController.readCurrent();
            this.position = this.hooksController.readPosition();
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToClamp);
                this.hooksController.writeCurrent(this.currentToClamp);
                break;
            }
            case GOTOHOMEPOSITION: {
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToGoHome);
                this.hooksController.writeCurrent(this.currentToGoHome);
                break;
            }
            case CLOSELOADERHOOKS: {
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToClose);
                this.hooksController.writeControlWord("3F");
                break;
            }
            case CLAMPLOADERHOOKS: {
                if (!this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                    throw new BadCommandException(this.name + ": Hooks have to be LOCKED before being LOCKED STRONGLY");
                }
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToClamp);
                this.hooksController.writeCurrent(this.currentToClamp);
                break;
            }
            case OPENLOADERHOOKS: {
                this.hooksController.enable();
                this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToOpen);
                this.hooksController.writeControlWord("3F");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
        this.hooksController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.debug((Object)(this.name + " is STOPPING action " + action.toString() + " within delay " + delay));
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
        this.hooksController.quickStop();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.hooksController.off();
        FCSLOG.info((Object)(this.name + ":" + action.toString() + " completed - doing postAction."));
        switch (action) {
            case GOTOCLAMPEDPOSITION: {
                if (!this.isLocked()) {
                    throw new ErrorInCommandExecutionException(this.name + ": check with sensors: clamp should be LOCKED.");
                }
                this.hooksController.defineAbsolutePosition(this.targetPositionToClamp);
                this.hooksController.off();
                this.updatePosition();
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
                this.publishData();
                break;
            }
            case GOTOHOMEPOSITION: {
                if (!this.isUnlocked()) {
                    throw new ErrorInCommandExecutionException(this.name + ": check with sensors: clamp should be UNLOCKED.");
                }
                this.hooksController.defineAbsolutePosition(0);
                this.hooksController.off();
                this.updatePosition();
                this.publishData();
                break;
            }
            case CLOSELOADERHOOKS: {
                if (this.isLocked()) break;
                throw new ErrorInCommandExecutionException(this.name + ": check with sensors: clamp should be LOCKED.");
            }
            case CLAMPLOADERHOOKS: {
                if (!this.isLocked() || !this.isAtClampedPosition()) break;
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
                this.publishData();
                break;
            }
            case OPENLOADERHOOKS: {
                if (this.isUnlocked()) break;
                throw new ErrorInCommandExecutionException(this.name + ": check with sensors: clamp should be UNLOCKED.");
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.loader.updateStateWithSensors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateWithSensors(String[] readHexaValues) throws FcsHardwareException {
        this.lock.lock();
        try {
            boolean inTravel;
            this.updatingState = true;
            this.hook1.updateStateWithSensors(readHexaValues);
            this.hook2.updateStateWithSensors(readHexaValues);
            this.hook3.updateStateWithSensors(readHexaValues);
            this.hook4.updateStateWithSensors(readHexaValues);
            boolean inError = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook2.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook3.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook4.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
            boolean locked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
            boolean unlocked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
            boolean bl = inTravel = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : (inTravel ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
            if (this.initialized && locked && this.isAtClampedPosition()) {
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp current in reading controller.")
    public void updateCurrent() throws BadCommandException, SDORequestException, FcsHardwareException {
        try {
            this.readCurrent = this.hooksController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp position in reading controller.")
    public void updatePosition() throws SDORequestException, FcsHardwareException {
        try {
            this.position = this.hooksController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String listHooks() {
        StringBuilder sb = new StringBuilder("Hooks status:");
        sb.append("\n");
        sb.append(this.hook1.toString());
        sb.append("/");
        sb.append(this.hook1.getLockStatus());
        sb.append("\n");
        sb.append(this.hook2.toString());
        sb.append("/");
        sb.append(this.hook2.getLockStatus());
        sb.append("\n");
        sb.append(this.hook3.toString());
        sb.append("/");
        sb.append(this.hook3.getLockStatus());
        sb.append("\n");
        sb.append(this.hook4.toString());
        sb.append("/");
        sb.append(this.hook4.getLockStatus());
        sb.append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listSensorsValues() {
        StringBuilder sb = new StringBuilder(this.name + "Sensors values=");
        sb.append("/");
        sb.append(this.hook1.listSensorsValues());
        sb.append("/");
        sb.append(this.hook2.listSensorsValues());
        sb.append("/");
        sb.append(this.hook3.listSensorsValues());
        sb.append("/");
        sb.append(this.hook4.listSensorsValues());
        sb.append("/");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listStatus() {
        StringBuilder sb = new StringBuilder("Clamp status:");
        sb.append(this.lockStatus);
        sb.append("\n");
        sb.append(this.hook1.getName());
        sb.append("/");
        sb.append(this.hook1.getLockStatus());
        sb.append("\n");
        sb.append(this.hook2.getName());
        sb.append("/");
        sb.append(this.hook2.getLockStatus());
        sb.append("\n");
        sb.append(this.hook3.getName());
        sb.append("/");
        sb.append(this.hook3.getLockStatus());
        sb.append("\n");
        sb.append(this.hook4.getName());
        sb.append("/");
        sb.append(this.hook4.getLockStatus());
        sb.append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/timeoutForClosingHooks=");
        sb.append(this.timeoutForClosingHooks);
        sb.append("/timeoutForClosingHooksStrongly=");
        sb.append(this.timeoutForClampingHooks);
        sb.append("/timeoutForOpeningHooks=");
        sb.append(this.timeoutForOpeningHooks);
        return sb.toString();
    }

    public StatusDataPublishedByLoaderClamp getStatusData() {
        StatusDataPublishedByLoaderClamp status = this.createStatusDataPublishedByLoaderClamp();
        return status;
    }

    public StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp() {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setName(this.name);
        status.setPosition(this.position);
        status.setCurrent(this.readCurrent);
        status.setClampState(this.lockStatus);
        status.setStatusPublishedByHook1(this.hook1.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook2(this.hook2.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook3(this.hook3.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook4(this.hook4.createStatusDataPublishedByLoaderHook());
        return status;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByLoaderClamp status = this.getStatusData();
        KeyValueData kvd = new KeyValueData("loaderClamp", (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

