/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class LoaderCarrierModule
extends MobileItemModule {
    protected NumericSensor storagePositionSensor0;
    protected NumericSensor handoffPositionSensor0;
    protected NumericSensor storagePositionSensor1;
    protected NumericSensor handoffPositionSensor1;
    private int position;
    private final int ssiPosition;
    private int handoffPosition;
    private int storagePosition;
    private int speed;
    private int current;
    private final int maxSpeed;
    private final int maxCurrent;
    private long timeoutForGoingToHandOff;
    private long timeoutForGoingToStorage;
    private EPOSController carrierController;
    private LoaderModule loader;
    private final Condition stateUpdated;
    protected volatile boolean updatingState;
    private boolean atStorage;
    private boolean atHandoff;
    private boolean storageSensorsInError;
    private boolean handoffSensorsInError;
    private boolean noConsistant;
    private boolean controllerInFault;
    private boolean limitSwitchDownInError;
    private boolean limitSwitchUpInError;
    private volatile boolean initialized;

    public LoaderCarrierModule(String moduleName, int aTickMillis, int minPos, int maxPos, NumericSensor handoffPositionSensor, NumericSensor handoffPositionSensor1, NumericSensor storagePositionSensor, NumericSensor storagePositionSensor1, long timeoutForGoingToHandOff, long timeoutForGoingToStorage, int maxCurrent, int maxSpeed) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.storagePositionSensor0 = storagePositionSensor;
        this.handoffPositionSensor0 = handoffPositionSensor;
        this.storagePositionSensor1 = storagePositionSensor1;
        this.handoffPositionSensor1 = handoffPositionSensor1;
        this.timeoutForGoingToHandOff = timeoutForGoingToHandOff;
        this.timeoutForGoingToStorage = timeoutForGoingToStorage;
        this.storagePosition = minPos;
        this.handoffPosition = maxPos;
        this.maxCurrent = maxCurrent;
        this.maxSpeed = maxSpeed;
        this.atHandoff = false;
        this.atStorage = false;
        this.position = 0;
        this.ssiPosition = 0;
        this.storageSensorsInError = false;
        this.handoffSensorsInError = false;
        this.controllerInFault = false;
        this.limitSwitchDownInError = false;
        this.limitSwitchUpInError = false;
    }

    public int getPosition() {
        return this.position;
    }

    public int getSsiPosition() {
        return this.ssiPosition;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getCurrent() {
        return this.current;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carrierController is in Fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carrier is initialized and ready to receive commands.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max speed in rpm/mn (format decimal).")
    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max current in mA (format decimal).")
    public int getMaxCurrent() {
        return this.maxCurrent;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the handoff position in microns (format decimal).")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the storage position in microns (format decimal).")
    public int getStoragePosition() {
        return this.storagePosition;
    }

    public NumericSensor getStoragePositionSensor0() {
        return this.storagePositionSensor0;
    }

    public NumericSensor getHandoffPositionSensor0() {
        return this.handoffPositionSensor0;
    }

    public NumericSensor getStoragePositionSensor1() {
        return this.storagePositionSensor1;
    }

    public NumericSensor getHandoffPositionSensor1() {
        return this.handoffPositionSensor1;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Handoff in millis (format decimal).")
    public long getTimeoutForGoingToHandOff() {
        return this.timeoutForGoingToHandOff;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Storage in millis (format decimal).")
    public long getTimeoutForGoingToStorage() {
        return this.timeoutForGoingToStorage;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Storage are equal.")
    public boolean isStorageSensorsInError() {
        return this.storageSensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at HandOff are equal.")
    public boolean isHandoffSensorsInError() {
        return this.handoffSensorsInError;
    }

    public boolean isLimitSwitchDownInError() {
        return this.limitSwitchDownInError;
    }

    public boolean isLimitSwitchUpInError() {
        return this.limitSwitchUpInError;
    }

    @ConfigChanger
    public void setHandoffPosition(int handoffPosition) {
        this.handoffPosition = handoffPosition;
    }

    @ConfigChanger
    public void setStoragePosition(int storagePosition) {
        this.storagePosition = storagePosition;
    }

    @ConfigChanger
    public void setTimeoutForGoingToHandOff(long timeoutForGoingToHandOff) {
        this.timeoutForGoingToHandOff = timeoutForGoingToHandOff;
    }

    @ConfigChanger
    public void setTimeoutForGoingToStorage(long timeoutForGoingToStorage) {
        this.timeoutForGoingToStorage = timeoutForGoingToStorage;
    }

    @Override
    public void initModule() {
        this.loader = (LoaderModule)((Object)this.getComponentByName("loader"));
        this.carrierController = (EPOSController)this.getComponentByName("carrierController");
        this.listens(new Observable[]{(Observable)((Object)this.carrierController)});
    }

    public void tick() {
        this.publishData();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        try {
            this.carrierController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + ":" + (Object)((Object)ex)));
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader hardware is connected and ready.")
    public boolean isHardwareReady() {
        return this.loader.isHardwareReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the sensors and return true if a filter is in the loader.")
    public boolean checkFilterPresence() throws FcsHardwareException {
        this.updateStateWithSensors();
        return !this.isEmpty();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return this.loader.isEmpty();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at storage position. This command doesn't read again the sensors.")
    public boolean isAtStoragePosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.atStorage;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at HANDOFF position. This command doesn't read again the sensors.")
    public boolean isAtHandoffPosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.atHandoff;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        return this.loader.isConnectedOnCamera();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        return this.loader.isAutochangerHoldingFilter();
    }

    @Command(type=Command.CommandType.ACTION, level=1, alias="goToHandoff", description="Move the carrier to Handoff position.")
    public String goToHandOff() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.atHandoff) {
            throw new BadCommandException(this.name + " is already at Handoff position.");
        }
        this.loader.checkPreConditionsForCarrierMotion();
        return this.executeAction(FcsEnumerations.MobileItemAction.MOVELOADERCARRIERTOHANDOFF, this.timeoutForGoingToHandOff);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to Storage position.")
    public String goToStorage() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.atStorage) {
            throw new BadCommandException(this.name + " is already at Standby position.");
        }
        this.loader.checkPreConditionsForCarrierMotion();
        return this.executeAction(FcsEnumerations.MobileItemAction.MOVELOADERCARRIERTOSTORAGE, this.timeoutForGoingToStorage);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVELOADERCARRIERTOHANDOFF: {
                return this.position == this.handoffPosition;
            }
            case MOVELOADERCARRIERTOSTORAGE: {
                return this.position == this.storagePosition;
            }
        }
        assert (false);
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carrier position in reading controller.")
    public void updatePosition() throws SDORequestException, FcsHardwareException {
        try {
            this.position = this.carrierController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carrier current in reading controller.")
    public void updateCurrent() throws BadCommandException, SDORequestException, FcsHardwareException {
        try {
            this.current = this.carrierController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        this.publishData();
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        try {
            this.carrierController.checkFault();
            this.position = this.carrierController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> SDO ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        try {
            this.updateStateWithSensors();
            this.current = this.carrierController.readCurrent();
            this.speed = this.carrierController.readProfileVelocity();
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> SDO ERROR IN READING CONTROLLER:" + ex));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.loader.updateStateWithSensors();
    }

    protected void updateStateWithSensors(String[] readHexaValues) throws FcsHardwareException {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.handoffPositionSensor0.updateValue(readHexaValues);
            this.handoffPositionSensor1.updateValue(readHexaValues);
            this.storagePositionSensor0.updateValue(readHexaValues);
            this.storagePositionSensor1.updateValue(readHexaValues);
            this.atStorage = this.storagePositionSensor0.getDigitalValue() == 1 && this.storagePositionSensor1.getDigitalValue() == 1;
            this.atHandoff = this.handoffPositionSensor0.getDigitalValue() == 1 && this.handoffPositionSensor1.getDigitalValue() == 1;
            this.storageSensorsInError = this.storagePositionSensor0.getDigitalValue() != this.storagePositionSensor1.getDigitalValue();
            this.handoffSensorsInError = this.handoffPositionSensor0.getDigitalValue() != this.handoffPositionSensor1.getDigitalValue();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.carrierController.checkFault();
        if (action.equals((Object)FcsEnumerations.MobileItemAction.MOVELOADERCARRIERTOHANDOFF)) {
            this.carrierController.enable();
            this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.carrierController.writeTargetPosition(this.handoffPosition);
            this.carrierController.writeControlWord("3F");
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.MOVELOADERCARRIERTOSTORAGE)) {
            this.carrierController.enable();
            this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.carrierController.writeTargetPosition(this.storagePosition);
            this.carrierController.writeControlWord("3F");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
        this.carrierController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.debug((Object)(this.name + " is STOPPING action " + action.toString() + " within delay " + delay));
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
        this.carrierController.off();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.carrierController.off();
        FCSLOG.info((Object)(this.name + ":" + action.toString() + " completed - doing postAction."));
        this.noConsistant = false;
        switch (action) {
            case MOVELOADERCARRIERTOSTORAGE: {
                if (this.isAtStoragePosition()) break;
                this.noConsistant = true;
                throw new ErrorInCommandExecutionException(this.name + ": check with sensors: storage sensors don't confirm carrier position.");
            }
            case MOVELOADERCARRIERTOHANDOFF: {
                if (this.isAtHandoffPosition()) break;
                this.noConsistant = true;
                throw new ErrorInCommandExecutionException(this.name + ": check with sensors: handoff sensors don't confirm carrier position.");
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Check if hardware is ready to be started.")
    public void initializeHardware() throws FcsHardwareException {
        if (!this.carrierController.isInitialized()) {
            throw new FcsHardwareException(this.name + ": carrierController has to be initialized.");
        }
        this.updateStateWithSensors();
        try {
            this.updatePosition();
        }
        catch (SDORequestException ex) {
            String msg = this.name + ": couldn't update position";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(this.name, (Throwable)ex);
        }
        this.noConsistant = false;
        if (this.isAtHandoffPosition() && this.position != this.handoffPosition && this.position <= this.handoffPosition) {
            this.noConsistant = true;
            throw new FcsHardwareException(this.name + ": handoff sensors don't confirm position read on carrierController.");
        }
        if (this.isAtStoragePosition() && this.position != this.storagePosition) {
            this.noConsistant = true;
            throw new FcsHardwareException(this.name + ": storage sensors don't confirm position read on carrierController.");
        }
        this.initialized = true;
    }

    public StatusDataPublishedByLoaderCarrier getStatusData() {
        StatusDataPublishedByLoaderCarrier status = this.createStatusDataPublishedByLoaderCarrier();
        return status;
    }

    public StatusDataPublishedByLoaderCarrier createStatusDataPublishedByLoaderCarrier() {
        StatusDataPublishedByLoaderCarrier status = new StatusDataPublishedByLoaderCarrier(this.name, this.position, this.ssiPosition, this.speed, this.current, this.storagePositionSensor0.getDigitalValue(), this.storagePositionSensor1.getDigitalValue(), this.handoffPositionSensor0.getDigitalValue(), this.handoffPositionSensor1.getDigitalValue(), this.storageSensorsInError, this.handoffSensorsInError, this.controllerInFault);
        status.setLimitSwitchDownInError(this.limitSwitchDownInError);
        status.setLimitSwitchUpInError(this.limitSwitchUpInError);
        return status;
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        EPOSController ctrl;
        FCSLOG.debug((Object)(this.name + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (!(source instanceof EPOSController)) {
            return;
        }
        if (v.getValue() instanceof EmergencyMessage) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            FCSLOG.debug((Object)(this.name + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
            if (this.carrierController.getName().equals(emcyMsg.getDeviceName())) {
                String errCode;
                switch (errCode = emcyMsg.getDeviceErrorCode()) {
                    case "00": {
                        FCSLOG.debug((Object)(this.name + ":faultReset ?=" + emcyMsg.toString()));
                        this.controllerInFault = false;
                        break;
                    }
                    default: {
                        FCSLOG.debug((Object)(this.name + ":EmergencyMessage received for " + "loader controller from CanOpenProxy=" + emcyMsg.toString()));
                        this.controllerInFault = true;
                        if (emcyMsg.getDeviceErrorCode().equalsIgnoreCase("ff06")) {
                            this.limitSwitchDownInError = true;
                            break;
                        }
                        if (!emcyMsg.getDeviceErrorCode().equalsIgnoreCase("ff07")) break;
                        this.limitSwitchUpInError = true;
                    }
                }
                this.publishData();
            }
        } else if (v.getValue() instanceof String && (ctrl = (EPOSController)((Object)source)).getName().equals(this.carrierController.getName())) {
            String msgFromController = (String)v.getValue();
            if (msgFromController.equals("faultReset")) {
                this.limitSwitchDownInError = false;
                this.limitSwitchUpInError = false;
                this.controllerInFault = false;
                this.publishData();
            } else if (msgFromController.equals("checkFault")) {
                this.controllerInFault = this.carrierController.isInError();
            }
        }
    }

    @Override
    public void publishData() {
        StatusDataPublishedByLoaderCarrier status = this.getStatusData();
        KeyValueData kvd = new KeyValueData("loaderCarrier", (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

