/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.Filter;

public class FilterManager
extends Module {
    private final ArrayList<Filter> filters = new ArrayList();
    protected TreeMap<String, Filter> filtersMap;

    public FilterManager(String name, Filter ... oneOrMoreFilters) {
        super(name);
        this.filters.addAll(Arrays.asList(oneOrMoreFilters));
    }

    public void initModule() {
        this.filtersMap = new TreeMap();
        for (Filter f : this.filters) {
            FCSCst.FCSLOG.info((Object)("Add filter to filterManager:" + f.toString()));
            this.filtersMap.put(f.getName(), f);
        }
    }

    public Filter getFilterByName(String filterName) {
        return this.filtersMap.get(filterName);
    }

    @Command(type=Command.CommandType.QUERY, description="Return the list of names of filters  that this subsystem manages.", level=1, alias="listFilterNames")
    public List<String> getFilterNames() {
        ArrayList<String> namesList = new ArrayList<String>();
        namesList.addAll(this.filtersMap.keySet());
        return namesList;
    }

    public List<String> getFilterNamesSortedByFilterID() {
        ArrayList<String> namesList = new ArrayList<String>();
        TreeMap<Integer, String> filtersByIDMap = new TreeMap<Integer, String>();
        for (Map.Entry<String, Filter> entry : this.filtersMap.entrySet()) {
            Filter filter = entry.getValue();
            filtersByIDMap.put(filter.getFilterID(), filter.getName());
        }
        namesList.addAll(filtersByIDMap.values());
        return namesList;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="To test the filter manager - print the map filtersMap.")
    public String Test() {
        StringBuilder sb = new StringBuilder("TEST:\n");
        sb.append("FilterG=").append(this.filtersMap.get("filterG").toString()).append('\n');
        for (Map.Entry<String, Filter> entry : this.filtersMap.entrySet()) {
            sb.append("key=").append(entry.getKey());
            sb.append(",filter=").append(entry.getValue().toString()).append('\n');
        }
        return sb.toString();
    }

    @Command(alias="printFilterList", type=Command.CommandType.QUERY, level=0, description="Return a printed list of filters.")
    public String toString() {
        StringBuilder sb = new StringBuilder("Filter List:\n");
        for (Filter f : this.filters) {
            sb.append(f.toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

