/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByFilter;

public class Filter
extends ConfigurableComponent {
    private Integer filterID;
    private String name;
    private double weight;
    private FcsEnumerations.FilterLocation filterLocation = FcsEnumerations.FilterLocation.UNKNOWN;
    private String socketName;

    public Filter(String name, int id, double weight) {
        this.name = name;
        this.filterID = id;
        this.weight = weight;
        this.filterLocation = FcsEnumerations.FilterLocation.UNKNOWN;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isOnCarousel() {
        return this.filterLocation == FcsEnumerations.FilterLocation.CAROUSEL;
    }

    public boolean isOnAutoChanger() {
        return this.filterLocation == FcsEnumerations.FilterLocation.AUTOCHANGER;
    }

    public boolean isOut() {
        return this.filterLocation == FcsEnumerations.FilterLocation.OUT;
    }

    public boolean isUnknown() {
        return this.filterLocation == FcsEnumerations.FilterLocation.UNKNOWN;
    }

    public FcsEnumerations.FilterLocation getFilterLocation() {
        return this.filterLocation;
    }

    public void setFilterLocation(FcsEnumerations.FilterLocation filterLocation) {
        this.filterLocation = filterLocation;
        this.publishData();
    }

    public Integer getFilterID() {
        return this.filterID;
    }

    public void setFilterID(Integer filterID) {
        this.filterID = filterID;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String getSocketName() {
        return this.socketName;
    }

    public void setSocketName(String socketName) {
        this.socketName = socketName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFilterOnSocket(String socketName) {
        Filter filter = this;
        synchronized (filter) {
            this.filterLocation = FcsEnumerations.FilterLocation.CAROUSEL;
            this.socketName = socketName;
        }
        this.publishData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCarousel() {
        Filter filter = this;
        synchronized (filter) {
            this.filterLocation = FcsEnumerations.FilterLocation.AUTOCHANGER;
            this.socketName = "NOT_ON_CAROUSEL";
        }
        FCSCst.FCSLOG.info((Object)(this.name + " removed from carousel"));
        this.publishData();
    }

    public void changeLocation(FcsEnumerations.FilterLocation filterLocation) {
        this.filterLocation = filterLocation;
        this.publishData();
    }

    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)new StatusDataPublishedByFilter(this.filterLocation, this.socketName)));
    }

    @Command(alias="printFilter", type=Command.CommandType.QUERY, level=0, description="Return a printed filter.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("=filterID:");
        sb.append(this.filterID);
        sb.append(",Weight:");
        sb.append(this.weight);
        sb.append(",FilterLocation:");
        sb.append(this.filterLocation);
        if (this.filterLocation.equals((Object)FcsEnumerations.FilterLocation.CAROUSEL)) {
            sb.append(",socket:");
            sb.append(this.socketName);
        }
        return sb.toString();
    }
}

