/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class FcsMainModule
extends MainModule {
    private static final long serialVersionUID = 7669526660659959402L;
    private CarouselModule carousel;
    private AutoChangerModule autochanger;
    private LoaderModule loader;
    private Double standbyPosition;
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private static final String ack = "[FCSMainModule]";

    public FcsMainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis, bridge);
    }

    @Override
    public void initModule() {
        FCSCst.FCSLOG.info((Object)"[FcsMainModule] Initializing the FCS Main module ");
        this.carousel = (CarouselModule)((Object)this.getComponentByName("carousel"));
        this.autochanger = (AutoChangerModule)((Object)this.getComponentByName("autochanger"));
        this.loader = (LoaderModule)((Object)this.getComponentByName("loader"));
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.getSubsystem().publishStatus(v.getName(), v.getValue());
    }

    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getSubsystem().getName()).append("\n  ");
        sb.append(this.carousel.toString()).append("\n  ");
        sb.append(((Object)((Object)this.autochanger)).toString());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(this.carousel.toString());
        sb.append(((Object)((Object)this.autochanger)).toString());
        return sb.toString();
    }

    public String moveFilterToOnline(Object filterName) throws InterruptedException, IllegalArgumentException, BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        this.controlFilterName(filterName);
        FCSCst.FCSLOG.info((Object)("Filter to move : " + filterName));
        FCSCst.FCSLOG.info((Object)("Filter location :" + this.getFilterByName((String)filterName).getFilterLocation()));
        return ack + this.moveFilterToOnline(this.getFilterByName((String)filterName));
    }

    public String moveFilterToStandby(Object filterName) throws InterruptedException, IllegalArgumentException, BadCommandException, ErrorInCommandExecutionException {
        this.controlFilterName(filterName);
        FCSCst.FCSLOG.info((Object)("Filter to move : " + filterName));
        FCSCst.FCSLOG.info((Object)("Filter location : " + this.getFilterByName((String)filterName).getFilterLocation()));
        return ack + this.moveFilterToStandby(this.getFilterByName((String)filterName));
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Check which filters are on Carousel and on which socketand update the sockets.")
    private void locateFilters() {
        this.carousel.engageClampsContact();
        this.filters.get("filterY").setFilterLocation(FcsEnumerations.FilterLocation.OUT);
    }

    private String moveFilterToOnline(Filter filter) throws InterruptedException, BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        this.carousel.moveFilterToStandby(filter);
        String message = "Panic : filter is neither on carousel, neither on autochanger";
        FCSCst.FCSLOG.error((Object)message);
        return message;
    }

    private String moveFilterToStandby(Filter filter) throws BadCommandException, InterruptedException, ErrorInCommandExecutionException {
        String message = null;
        return message;
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    protected void controlFilterName(Object o) throws IllegalArgumentException {
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Incorrect filter name : " + o);
        }
        String filterName = (String)o;
        if (!this.filters.containsKey(filterName)) {
            throw new IllegalArgumentException("Unknown filter name : " + o);
        }
        if (this.getFilterByName(filterName).isUnknown()) {
            throw new IllegalArgumentException("Filter: " + o + " is at unknown location.");
        }
        if (this.getFilterByName(filterName).isOut()) {
            throw new IllegalArgumentException("Filter: " + o + " is out of the camera.");
        }
    }

    public Filter getFilterByName(String filterName) {
        return this.filters.get(filterName);
    }

    public boolean isEmptyStandBy() {
        return false;
    }

    public boolean isEmptyOnline() {
        return true;
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public Double getStandbyPosition() {
        return this.standbyPosition;
    }

    public void setStandbyPosition(Double standbyPosition) {
        this.standbyPosition = standbyPosition;
    }

    public void loadFilter(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new BadCommandException(this.getName() + " can't load a filter when socket at STANDBY position is not empty and ready.");
        }
        if (!this.autochanger.isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new BadCommandException(this.getName() + " autochanger is not empty at STANDOFF position; can't load a filter.");
        }
        this.connectLoader();
        if (!this.loader.isHoldingAFilter() || !this.loader.isCarrierAtStoragePosition()) {
            throw new BadCommandException(this.getName() + " can't load filter because loader is not holding a filter at storage position.");
        }
        this.loader.goToHandoff();
        this.autochanger.goToHandOff();
        this.autochanger.grabFilterAtHandoff(aFilter);
        aFilter.setFilterLocation(FcsEnumerations.FilterLocation.AUTOCHANGER);
        this.loader.openHooks();
        this.loader.goToStorage();
        this.disconnectLoader();
    }

    public void unloadFilter(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!aFilter.isOnCarousel()) {
            throw new BadCommandException(this.getName() + " " + aFilter.getName() + " is not on the carousel, can't unload it.");
        }
        if (!this.carousel.isOnStandby(aFilter)) {
            throw new BadCommandException(this.getName() + " " + aFilter.getName() + " is not on the carousel at standby position, can't unload it.");
        }
        if (!this.autochanger.isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new BadCommandException(this.getName() + " autochanger is not empty at STANDOFF position; can't unload a filter.");
        }
        this.connectLoader();
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move empty to standby position.");
        this.autochanger.grabFilterAtStandby(aFilter);
        FCSCst.FCSLOG.info((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.ungrabFilterAtStandby(aFilter);
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move loaded with the filter to handoff position.");
        this.autochanger.moveFilterToHandoff(aFilter);
        FCSCst.FCSLOG.info((Object)"=======> Carousel about to release Clamps.");
        this.carousel.releaseClamps();
        this.loader.goToHandoff();
        this.loader.closeHooks();
        this.autochanger.ungrabFilterAtHandoff(aFilter);
        this.loader.clampHooks();
        this.loader.goToStorage();
        aFilter.setFilterLocation(FcsEnumerations.FilterLocation.OUT);
        this.disconnectLoader();
    }

    private void connectLoader() {
    }

    private void disconnectLoader() {
    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

