/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.common.AutochangerHandler;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.errors.ClampsOrLatchesDisagreeException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class CarouselSocket
extends MobileItemModule
implements ClearAlertHandler {
    private BridgeToHardware bridge;
    private CarouselClampModule clampXminus;
    private CarouselClampModule clampXplus;
    private EPOSController clampActuatorXminus;
    private EPOSController clampActuatorXplus;
    private AutochangerHandler autochangerHandler;
    private final double positionOnCarousel;
    private final double standbyPosition;
    private Filter filter;
    private FilterManager filterManager;
    private volatile boolean updatingClamps = false;
    private volatile FcsEnumerations.FilterClampState clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
    private final Condition stateUpdated = this.lock.newCondition();
    private long timeoutForUnlocking = 4000L;
    private long timeoutForReleasing = 4000L;

    public CarouselSocket(String moduleName, int aTickMillis, CarouselClampModule clampXminus, CarouselClampModule clampXplus, double position, double standbyPosition) {
        super(moduleName, aTickMillis);
        this.clampXminus = clampXminus;
        this.clampXplus = clampXplus;
        this.positionOnCarousel = position;
        this.standbyPosition = standbyPosition;
    }

    public CarouselClampModule getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(CarouselClampModule clampXminus) {
        this.clampXminus = clampXminus;
    }

    public CarouselClampModule getClampXplus() {
        return this.clampXplus;
    }

    public void setClampXplus(CarouselClampModule clampXplus) {
        this.clampXplus = clampXplus;
    }

    public double getActualPosition() {
        return CarouselModule.addAngle(this.positionOnCarousel, this.getCarouselPosition());
    }

    public double getCarouselPosition() {
        return ((CarouselModule)((Object)this.getComponentByName("carousel"))).getPosition();
    }

    public double getPositionOnCarousel() {
        return this.positionOnCarousel;
    }

    public Filter getFilter() {
        return this.filter;
    }

    private void setFilter(Filter filter) {
        this.filter = filter;
    }

    public double getStandbyPosition() {
        return this.standbyPosition;
    }

    public boolean isAtStandby() {
        return Double.doubleToRawLongBits(this.getCarouselPosition()) == Double.doubleToRawLongBits(this.standbyPosition);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.bridge = (BridgeToHardware)this.getComponentByName("bridge");
        this.clampActuatorXminus = (EPOSController)this.getComponentByName("clampXminusController");
        this.clampActuatorXplus = (EPOSController)this.getComponentByName("clampXplusController");
        this.timeoutForReleasing = Math.max(this.clampXminus.timeoutForReleasing, this.clampXplus.timeoutForReleasing);
        this.timeoutForUnlocking = Math.max(this.clampXminus.timeoutForUnlocking, this.clampXplus.timeoutForUnlocking);
        if (!(this.getComponentByName("main") instanceof AutochangerHandler)) {
            String MSG = this.name + " ==>main doesn't implements AutochangerHandler -" + " Please fix groovy description file or Main Module implementation.";
            FCSLOG.error((Object)MSG);
            throw new IllegalArgumentException(MSG);
        }
        this.autochangerHandler = (AutochangerHandler)this.getComponentByName("main");
        this.clampXminus.setController(this.clampActuatorXminus);
        this.clampXplus.setController(this.clampActuatorXplus);
    }

    @Command(type=Command.CommandType.QUERY, description="Returns true if the autochanger holds the filter.")
    public boolean isAutochangerHoldingFilter() {
        return this.autochangerHandler.isAutochangerHoldingFilterAtSTANDBY();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean isHardwareReady() {
        return ((MainModule)((Object)this.getComponentByName("main"))).isHardwareReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return clamps state - doesn't read again sensors.")
    public FcsEnumerations.FilterClampState getClampsState() {
        this.lock.lock();
        try {
            while (this.updatingClamps) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.name + " was interrupted during getClampsState."));
                }
            }
            FcsEnumerations.FilterClampState filterClampState = this.clampsState;
            return filterClampState;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public void updateClampsStateWithSensorsFromSDO() throws FcsHardwareException {
        block4: {
            this.lock.lock();
            this.updatingClamps = true;
            try {
                this.clampXminus.updateStateWithSensorsFromSDO();
                this.clampXplus.updateStateWithSensorsFromSDO();
                if (this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    this.clampsState = this.clampXminus.getClampState();
                    break block4;
                }
                throw new FcsHardwareException("Error in filter presence detection at standby position : the clamps don't agree.");
            }
            finally {
                this.updatingClamps = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClampsStateWithSensors(PDOStorage pdoStorage) throws FcsHardwareException {
        block4: {
            this.lock.lock();
            this.updatingClamps = true;
            try {
                this.clampXminus.updateStateWithSensors(pdoStorage);
                this.clampXplus.updateStateWithSensors(pdoStorage);
                if (this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    this.clampsState = this.clampXminus.getClampState();
                    FCSLOG.info((Object)(this.name + ":XXXXXXXXSocket at standby : clamps are updated"));
                    break block4;
                }
                String msg = this.name + ":Error in carousel at standby position : " + "clampState at Xminus side is different from clampState at Xplus side.";
                msg = msg + " =>clampXminus state=" + this.clampXminus.getClampState();
                msg = msg + " =>clampXplus state=" + this.clampXplus.getClampState();
                FCSLOG.error((Object)msg);
                Alert alert = new Alert("FCS004", msg);
                this.getSubsystem().raiseAlert(alert, AlertState.ALARM);
                throw new ClampsOrLatchesDisagreeException(msg);
            }
            finally {
                this.updatingClamps = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update clamps state in reading sensors.")
    public void updateClampsStateWithSensors() throws FcsHardwareException, BadCommandException {
        FCSLOG.debug((Object)("updateClampsStateWithSensors/" + this.name + "/bridge=" + this.bridge.toString()));
        this.updateClampsStateWithSensors(this.bridge.readPDOs());
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is no filter in the socket.")
    public boolean isEmpty() {
        return this.clampsState.equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP) || this.clampsState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare LOCKED.")
    public boolean isClampedOnFilter() {
        return this.clampsState.equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedOnFilter() {
        return this.clampsState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is NO filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedEmpty() {
        return this.clampsState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if this socket is ready to clamp a filter.")
    public boolean isReadyToClamp() {
        return this.clampsState.equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release the 2 clamps of this socket if the socket is at STANDBY position.")
    public String releaseClamps() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.updateClampsStateWithSensors();
        FCSLOG.info((Object)("Checking conditions for release clamp " + this.name + " on socket " + "at standby position."));
        if (!this.isAtStandby()) {
            throw new BadCommandException(this.name + " is NOT AT STANDBY - can't unlock clamps.");
        }
        if (!this.clampsState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY)) {
            throw new BadCommandException("Can't release clamps if socket is not unclamped and empty.");
        }
        FCSLOG.info((Object)("Releasing clamp " + this.name + " on socket at standby position."));
        return this.executeAction(FcsEnumerations.MobileItemAction.RELEASECLAMPS, this.timeoutForReleasing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the 2 clamps of this socket if the socket is at STANDBY position.")
    public String unlockClamps() throws FcsHardwareException, BadCommandException, ErrorInCommandExecutionException {
        if (!this.isAtStandby()) {
            throw new BadCommandException(this.name + " is NOT AT STANDBY - can't unlock clamps.");
        }
        this.updateClampsStateWithSensors();
        if (!this.clampsState.equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER)) {
            throw new BadCommandException(this.name + ":Can't unlock clamps if isn't clamped on filter.");
        }
        if (!this.isAutochangerHoldingFilter()) {
            throw new BadCommandException("CANNOT UNLOCK CLAMPS if FILTER is not HELD by autochanger.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.UNLOCKCLAMPS, this.timeoutForUnlocking);
    }

    public void removeFilter() throws BadCommandException {
        if (this.filter == null) {
            throw new BadCommandException("Carousel socket : there is no filter to remove at standby position");
        }
        this.filter.removeFromCarousel();
        this.filter = null;
        this.publishData();
    }

    public synchronized void putFilterOnSocket(Filter filter) {
        this.setFilter(filter);
        this.publishData();
        filter.putFilterOnSocket(this.name);
    }

    public void tick() {
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a String representation of a CarouselSocket.")
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(",positionOnCarousel:");
        sb.append(this.positionOnCarousel);
        sb.append(",Filter in socket : ");
        if (this.filter == null) {
            sb.append(" NO FILTER").append("\n");
        } else {
            sb.append(this.filter.getName()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.UNLOCKCLAMPS)) {
            return this.clampsState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.RELEASECLAMPS)) {
            return this.clampsState.equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP);
        }
        throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        try {
            this.updateClampsStateWithSensors();
        }
        catch (ClampsOrLatchesDisagreeException ex) {
            FCSLOG.warning((Object)ex);
            String msg = this.name + " a little delai between the update of the 2 clamps : have to wait ...";
            FCSLOG.warning((Object)msg);
            Alert alert = new Alert("FCS004", msg);
            this.getSubsystem().raiseAlert(alert, AlertState.WARNING);
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.UNLOCKCLAMPS)) {
            if (!this.clampActuatorXminus.isEnabled()) {
                this.clampActuatorXminus.enable();
            }
            if (!this.clampActuatorXplus.isEnabled()) {
                this.clampActuatorXplus.enable();
            }
            if (!this.clampActuatorXminus.isEnabled()) {
                throw new BadCommandException(this.name + " ControllerXminus has to be enabled first.");
            }
            if (!this.clampActuatorXplus.isEnabled()) {
                throw new BadCommandException(this.name + " ControllerXplus has to be enabled first.");
            }
            this.clampActuatorXminus.writeCurrent(this.clampXminus.getCurrentToUnlock());
            this.clampActuatorXplus.writeCurrent(this.clampXplus.getCurrentToUnlock());
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.RELEASECLAMPS)) {
            this.clampActuatorXminus.off();
            this.clampActuatorXplus.off();
        } else {
            throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
        }
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.info((Object)(this.name + " stopAction : nothing to be done."));
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCarouselSocket()));
    }

    public StatusDataPublishedByCarouselSocket createStatusDataPublishedByCarouselSocket() {
        StatusDataPublishedByCarouselSocket status = new StatusDataPublishedByCarouselSocket();
        status.setActualPosition(this.getActualPosition());
        status.setAtStandby(this.isAtStandby());
        status.setClampsState(this.clampsState);
        status.setEmpty(this.isEmpty());
        if (this.filter == null) {
            status.setFilterName("NO FILTER");
        } else {
            status.setFilterName(this.filter.getName());
        }
        return status;
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        switch (alert.getAlertId()) {
            case "FCS004": {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }
}

