/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsMainModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.common.AutochangerHandler;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CarouselModule
extends Module {
    private static final long serialVersionUID = -2376279469784152348L;
    private double position = 0.0;
    private final double speed;
    private double current = 0.0;
    private EPOSController clampXminusController;
    private EPOSController clampXplusController;
    private EPOSController carouselController;
    private PieceOfHardware clampsSensorsReaderDevice;
    private PieceOfHardware cancbxAI420_1;
    private PieceOfHardware cancbxAI420_2;
    private AutochangerHandler autochangerHandler;
    private final ArrayList<CarouselSocket> sockets;
    protected Map<String, CarouselSocket> socketsMap;
    private BridgeToHardware bridge;
    private volatile ModuleState state = ModuleState.HALTED;
    private boolean stopped = false;

    public CarouselModule(String aName, int aTickMillis, CarouselSocket ... oneOrMoreSockets) {
        super(aName, aTickMillis);
        this.speed = 0.0;
        this.sockets = new ArrayList();
        this.sockets.addAll(Arrays.asList(oneOrMoreSockets));
    }

    public CarouselSocket getSocketByName(String socketName) {
        if (this.socketsMap.containsKey(socketName)) {
            return this.socketsMap.get(socketName);
        }
        throw new IllegalArgumentException(this.name + ": no such name for socket:" + socketName);
    }

    public double getPosition() {
        return this.position;
    }

    public synchronized ModuleState getState() {
        return this.state;
    }

    public synchronized void setState(ModuleState state) {
        this.state = state;
    }

    public EPOSController getClampXminusController() {
        return this.clampXminusController;
    }

    public EPOSController getClampXplusController() {
        return this.clampXplusController;
    }

    public EPOSController getCarouselController() {
        return this.carouselController;
    }

    public PieceOfHardware getClampsSensorsReader() {
        return this.clampsSensorsReaderDevice;
    }

    public PieceOfHardware getCancbxAI420_1() {
        return this.cancbxAI420_1;
    }

    public PieceOfHardware getCancbxAI420_2() {
        return this.cancbxAI420_2;
    }

    public CarouselClampModule getClampXminus() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getClampXminus();
    }

    public CarouselClampModule getClampXplus() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getClampXplus();
    }

    public synchronized boolean isAtStandby() {
        if (this.isRotating()) {
            return false;
        }
        for (CarouselSocket socket : this.sockets) {
            if (!socket.isAtStandby()) continue;
            return true;
        }
        return false;
    }

    public synchronized CarouselSocket getSocketAtStandby() {
        if (this.isRotating()) {
            return null;
        }
        for (CarouselSocket socket : this.sockets) {
            if (!socket.isAtStandby()) continue;
            return socket;
        }
        return null;
    }

    public synchronized Filter getFilterAtStandby() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getFilter();
    }

    public synchronized String getFilterAtStandbyName() {
        Filter filterAtStandby = this.getFilterAtStandby();
        if (filterAtStandby == null) {
            return "NO FILTER";
        }
        return filterAtStandby.getName();
    }

    public boolean isAutochangerHoldingFilter() {
        return this.autochangerHandler.isAutochangerHoldingFilterAtSTANDBY();
    }

    public void initModule() {
        super.initModule();
        FCSCst.FCSLOG.info((Object)"[CarouselModule] Initializing the carousel module ");
        this.setState(ModuleState.HALTED);
        this.bridge = (BridgeToHardware)this.getComponentByName("bridge");
        this.clampXminusController = (EPOSController)this.getComponentByName("clampXminusController");
        this.clampXplusController = (EPOSController)this.getComponentByName("clampXplusController");
        this.carouselController = (EPOSController)this.getComponentByName("carouselController");
        this.clampsSensorsReaderDevice = (PieceOfHardware)this.getComponentByName("clampsSensorsReader");
        this.cancbxAI420_1 = (PieceOfHardware)this.getComponentByName("ai420_1");
        this.cancbxAI420_2 = (PieceOfHardware)this.getComponentByName("ai420_2");
        this.socketsMap = new TreeMap<String, CarouselSocket>();
        for (CarouselSocket socket : this.sockets) {
            FCSCst.FCSLOG.info((Object)("Add socket to sockets Map:" + socket.toString()));
            this.socketsMap.put(socket.getName(), socket);
        }
        if (!(this.getComponentByName("main") instanceof AutochangerHandler)) {
            String MSG = this.name + " ==>main doesn't implements AutochangerHandler -" + " Please fix groovy description file or MainModule implementation.";
            FCSCst.FCSLOG.error((Object)MSG);
            throw new IllegalArgumentException(MSG);
        }
        this.autochangerHandler = (AutochangerHandler)this.getComponentByName("main");
    }

    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("carousel", (Serializable)this.createStatusDataPublishedByCarousel()));
    }

    public StatusDataPublishedByCarousel createStatusDataPublishedByCarousel() {
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel();
        status.setName(this.name);
        status.setRotationInDegrees(this.position);
        status.setLocked(this.isLocked());
        status.setCurrent(this.current);
        status.setSpeed(this.speed);
        if (this.isAtStandby()) {
            status.setAtStandby(true);
            FCSCst.FCSLOG.debug((Object)(this.name + " Filter at STANDBY=" + this.getFilterAtStandbyName()));
            status.setFilterAtStandbyName(this.getFilterAtStandbyName());
            status.setSocketAtStandbyName(this.getSocketAtStandby().getName());
        } else {
            status.setAtStandby(false);
        }
        TreeMap<String, String> mapSocketFilter = new TreeMap<String, String>();
        for (Map.Entry<String, CarouselSocket> entry : this.socketsMap.entrySet()) {
            CarouselSocket socket = entry.getValue();
            if (socket.getFilter() == null) {
                mapSocketFilter.put(socket.getName(), "NO FILTER");
                continue;
            }
            mapSocketFilter.put(socket.getName(), socket.getFilter().getName());
        }
        for (Map.Entry<String, CarouselSocket> entry : mapSocketFilter.entrySet()) {
            FCSCst.FCSLOG.debug((Object)(this.name + " socket name=" + entry.getKey() + " filter name=" + (String)((Object)entry.getValue())));
        }
        status.setFiltersOnCamera(mapSocketFilter);
        return status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("\n Numbers of sockets: ");
        sb.append(this.sockets.size());
        for (CarouselSocket socket : this.sockets) {
            sb.append("\n Socket name ");
            sb.append(socket.getName());
            sb.append(" / ");
            sb.append(String.valueOf((Object)socket));
        }
        return sb.toString();
    }

    @Command(level=1, type=Command.CommandType.QUERY, description="Returns true if Carousel is stopped and no filter is at STANDBY position")
    public boolean isReadyToGrabAFilterAtStandby() throws FcsHardwareException {
        if (this.isRotating()) {
            return false;
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return false;
        }
        return socketAtStandby.isEmpty() && socketAtStandby.isReadyToClamp();
    }

    @Command(level=1, type=Command.CommandType.QUERY, description="Returns true if a filter is clamped at STANDBY position")
    public boolean isHoldingFilterAtStandby() throws FcsHardwareException {
        if (this.isRotating()) {
            return false;
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return false;
        }
        if (socketAtStandby.isEmpty()) {
            return false;
        }
        return socketAtStandby.isClampedOnFilter();
    }

    public boolean isRotating() {
        return false;
    }

    @Command(level=1, type=Command.CommandType.QUERY, description="Returns true if the brake is released")
    public boolean isAbleToMove() {
        return true;
    }

    public boolean isLocked() {
        return true;
    }

    @Command(level=1, type=Command.CommandType.ACTION, description="Engage the carousel brake to stop the rotation")
    public String engageBrake() {
        return this.name + " locked";
    }

    @Command(level=1, type=Command.CommandType.ACTION, description="Release the carousel brake")
    public String releaseBrake() {
        return this.name + " unlocked";
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carousel position in reading controller.")
    public void updatePosition() throws FcsHardwareException {
        try {
            this.position = this.carouselController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update field current in reading controller.")
    public void updateCurrent() throws BadCommandException, FcsHardwareException {
        try {
            this.current = this.carouselController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSCst.FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        this.publishData();
    }

    public void updateClampsStateWithSensorsFromSDO() throws BadCommandException, FcsHardwareException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException(this.name + " can't update Clamps State because there is no socket at standby.");
        }
        this.getSocketAtStandby().updateClampsStateWithSensors();
    }

    public void updateClampsStateWithSensorsFromPDO() throws BadCommandException, FcsHardwareException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException(this.name + " can't update Clamps State because there is no socket at STANDBY.");
        }
        PDOStorage pdoStore = this.bridge.readPDOs();
        FCSCst.FCSLOG.finest((Object)(this.name + ":pdoStore=" + pdoStore.toString()));
        this.getSocketAtStandby().updateClampsStateWithSensors(pdoStore);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read clamps sensors and update clamps state")
    public void updateClampsStateWithSensors() throws BadCommandException, FcsHardwareException {
        this.updateClampsStateWithSensorsFromPDO();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to an absolute angle.")
    public String rotateToAbsoluteAngle(@Argument(name="angle", description="Angle to reach in degrees") double angle) {
        this.position = angle;
        this.publishData();
        return this.name + "rotation OK";
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel for an angle.")
    public String rotateToRelativeAngle(@Argument(name="angle", description="Angle to reach in degrees") double angle) {
        this.position = CarouselModule.addAngle(this.position, angle);
        this.publishData();
        return this.name + "rotation OK";
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel for an angle")
    public String rotate(@Argument(name="angle", description="Angle to reach in degrees") double angle) throws BadCommandException {
        FcsEnumerations.RunningWay way;
        double absAngle;
        if (angle < -360.0 || angle > 360.0) {
            throw new IllegalArgumentException("Please enter an angle between -360 and +360");
        }
        if (angle >= 0.0) {
            absAngle = angle;
            way = FcsEnumerations.RunningWay.POSITIVE;
        } else {
            absAngle = -angle;
            way = FcsEnumerations.RunningWay.NEGATIVE;
        }
        double requiredPosition = CarouselModule.addAngle(this.getPosition(), angle);
        return this.rotate(absAngle, way, requiredPosition);
    }

    @Deprecated
    private String rotate(double angle, FcsEnumerations.RunningWay runningWay, double finalPosition) throws BadCommandException {
        if (angle < 0.0 || angle > 360.0) {
            throw new IllegalArgumentException(this.name + " command rotate accepts angle only between 0 and 360)");
        }
        if (finalPosition < 0.0 || finalPosition > 360.0) {
            throw new IllegalArgumentException(this.name + " command rotate accepts finalPosition only between 0 and 360)");
        }
        if (this.isRotating()) {
            String message = "Carousel is rotating, stop it before sending a new rotate command.";
            FCSCst.FCSLOG.error((Object)message);
            throw new BadCommandException(message);
        }
        if (!this.isAbleToMove()) {
            String message = "Carousel is unable to move. Check lock or flip rail.";
            FCSCst.FCSLOG.error((Object)message);
            throw new BadCommandException(message);
        }
        this.stopped = false;
        this.setState(ModuleState.RUNNING);
        String message = "Rotating to required position: " + finalPosition;
        FCSCst.FCSLOG.info((Object)message);
        while (this.isRotating()) {
            try {
                FCSCst.FCSLOG.info((Object)"...carousel rotating, please wait.....");
                FCSCst.FCSLOG.info((Object)(this.name + " WAITING TO BE AT REQUIRED POSITION=" + finalPosition));
                FCSCst.FCSLOG.info((Object)this.state.toString());
                Thread.sleep(this.tickMillis);
            }
            catch (InterruptedException e) {
                return "Sleeping interrupted";
            }
        }
        if (!this.isRotating()) {
            FCSCst.FCSLOG.info((Object)("THREAD=" + Thread.currentThread().getName()));
            this.setState(ModuleState.HALTED);
            FCSCst.FCSLOG.info((Object)"carousel is now stopped.");
            if (Double.doubleToRawLongBits(this.getPosition()) == Double.doubleToRawLongBits(finalPosition)) {
                message = "Command completed";
                FCSCst.FCSLOG.info((Object)message);
            } else {
                message = "Command non completed: carousel is not stopped at the required position";
                FCSCst.FCSLOG.info((Object)message);
            }
        }
        if (this.stopped) {
            message = "Command rotate carousel interrupted by command stop";
            FCSCst.FCSLOG.info((Object)message);
        }
        if (!this.stopped && Double.doubleToRawLongBits(this.getPosition()) != Double.doubleToRawLongBits(finalPosition)) {
            message = "Command non completed: carousel is not stopped at the required position";
            FCSCst.FCSLOG.error((Object)message);
        }
        return message;
    }

    public void tick() {
        this.publishData();
    }

    private synchronized void putFilterOnCarousel(Filter filter) throws BadCommandException {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(this.name + ": there is no socket at standby " + "position to put a filter in.");
        }
        socketAtStandby.putFilterOnSocket(filter);
        this.publishData();
    }

    public double getFilterPosition(Filter filter) {
        double filterPosition = 0.0;
        for (CarouselSocket socket : this.sockets) {
            if (!((Object)((Object)socket.getFilter())).equals((Object)filter)) continue;
            filterPosition = socket.getPositionOnCarousel();
        }
        return filterPosition;
    }

    public double getStandbyPositionForFilter(Filter filter) {
        double filterPosition = 0.0;
        for (CarouselSocket socket : this.sockets) {
            if (!((Object)((Object)socket.getFilter())).equals((Object)filter)) continue;
            filterPosition = socket.getStandbyPosition();
            return filterPosition;
        }
        return filterPosition;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to put filter at standby position")
    protected String moveFilterToStandby(Filter filter) throws BadCommandException {
        FcsEnumerations.RunningWay runningWay;
        if (!filter.isOnCarousel()) {
            throw new IllegalArgumentException("filter: " + filter.getName() + " is not on carousel.");
        }
        String message = " [CarouselModule]";
        double requiredPosition = this.getStandbyPositionForFilter(filter);
        if (this.state == ModuleState.RUNNING) {
            throw new BadCommandException("Carousel is running, stop it before sending a new command.");
        }
        if (Double.doubleToRawLongBits(this.getPosition()) == Double.doubleToRawLongBits(requiredPosition)) {
            FCSCst.FCSLOG.info((Object)(filter.getName() + " is at STANDBY position on carousel."));
            return filter.getName() + " is at STANDBY position on carousel.";
        }
        double angle = CarouselModule.addAngle(this.getPosition(), this.getFilterPosition(filter));
        if (angle < 180.0) {
            runningWay = FcsEnumerations.RunningWay.NEGATIVE;
        } else {
            angle = 360.0 - angle;
            runningWay = FcsEnumerations.RunningWay.POSITIVE;
        }
        this.releaseClampsContact();
        this.rotate(angle, runningWay, requiredPosition);
        this.engageClampsContact();
        message = message + this.engageBrake();
        return message;
    }

    public String grabFilterAtStandby(Object filterName) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FcsMainModule fcsMainModule = (FcsMainModule)((Object)this.getComponentByName("main"));
        fcsMainModule.controlFilterName(filterName);
        Filter filterToGrabbe = fcsMainModule.getFilterByName((String)filterName);
        FCSCst.FCSLOG.info((Object)("Filter to move : " + filterName));
        FCSCst.FCSLOG.info((Object)("Filter location : " + filterToGrabbe.getFilterLocation()));
        return this.name + this.grabFilterAtStandby(filterToGrabbe);
    }

    public synchronized String grabFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (filter == null) {
            throw new IllegalArgumentException(this.name + ": grabbeFilterAtStandby must receive a non null argument as a filter");
        }
        if (this.isRotating()) {
            throw new BadCommandException(this.name + ": grabbeFilterAtStandby can't grabbe a filter while rotating");
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(this.name + ": grabbeFilterAtStandby can't be executed because there is no socket at standby position.");
        }
        socketAtStandby.updateClampsStateWithSensors();
        if (socketAtStandby.isEmpty()) {
            throw new BadCommandException(this.name + ": grabbeFilterAtStandby can't be executed because no filter is detected in socket at standby position.");
        }
        if (socketAtStandby.isClampedOnFilter()) {
            FCSCst.FCSLOG.info((Object)(this.name + ": grabbing " + filter.getName() + " at standby position."));
            this.putFilterOnCarousel(filter);
            FCSCst.FCSLOG.info((Object)(this.name + ": " + filter.getName() + " is grabbed on carousel."));
            String ack = this.name + ": " + filter.getName() + " is grabbed at standby position";
            return ack;
        }
        throw new BadCommandException(this.name + ": grabbeFilterAtStandby can't be executed because the clamps are not CLAMPED ON FILTER.");
    }

    public void ungrabFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (filter == null) {
            throw new IllegalArgumentException("Filter to ungrabb should not be null");
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(this.name + ":A socket has to be halted at standby position for this operation.");
        }
        if (!this.isOnStandby(filter)) {
            throw new BadCommandException(this.name + ": filter has to be at standby position to be ejected");
        }
        if (!socketAtStandby.isClampedOnFilter()) {
            throw new BadCommandException(this.name + ": can't ungrabb filter which is already unclamped.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + ": ungrabbing " + filter.getName() + " at standby position."));
        this.unlockClamps(filter);
        FCSCst.FCSLOG.info((Object)(this.name + ": socket at standby state : " + socketAtStandby.toString()));
        FCSCst.FCSLOG.info((Object)(this.name + ": " + filter.getName() + " is ungrabbed from carousel."));
    }

    @Command(level=1, description="Release clamps at standby position to get ready to clamp again", type=Command.CommandType.ACTION)
    public String releaseClamps() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(this.name + ":Can't release clamps while a socket is not halted at standby position.");
        }
        socketAtStandby.updateClampsStateWithSensors();
        if (!socketAtStandby.isEmpty()) {
            throw new BadCommandException(this.name + ":Can't release clamps while " + "a filter is in the socket at standby.");
        }
        if (!socketAtStandby.isUnclampedEmpty()) {
            throw new BadCommandException(this.name + ":Can't release clamps when both clamps are not in state UNCLAMPEDEMPTY.");
        }
        socketAtStandby.releaseClamps();
        socketAtStandby.updateClampsStateWithSensors();
        if (socketAtStandby.isReadyToClamp()) {
            return "Clamps are released and ready to clamp again.";
        }
        throw new ErrorInCommandExecutionException("Could not release clamps.");
    }

    public String unlockClamps(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException("Can't unlock clamps while a socket is not halted at standby position.");
        }
        socketAtStandby.updateClampsStateWithSensors();
        if (!this.isAutochangerHoldingFilter()) {
            throw new BadCommandException("Can't unlock clamps if the filter is not held by the autochanger.");
        }
        if (!socketAtStandby.isClampedOnFilter()) {
            throw new BadCommandException("Can't unlock clamps when a filter is not clamped at standby.");
        }
        FCSCst.FCSLOG.info((Object)"Unlocking clamps at standby.");
        socketAtStandby.unlockClamps();
        socketAtStandby.updateClampsStateWithSensors();
        if (socketAtStandby.isUnclampedOnFilter()) {
            FCSCst.FCSLOG.info((Object)"Just about to remove filter from carousel");
            socketAtStandby.removeFilter();
            this.publishData();
            FCSCst.FCSLOG.info((Object)"Command unlockClamps completed");
            return "Clamps unlocked";
        }
        FCSCst.FCSLOG.info((Object)this.state);
        throw new ErrorInCommandExecutionException(this.name + ":Could not unlock filter at standby");
    }

    @Command(level=3, description="Unlock the clamps", type=Command.CommandType.ACTION)
    public String unlockClamps() throws BadCommandException, FcsHardwareException, ErrorInCommandExecutionException {
        return this.unlockClamps(this.getFilterAtStandby());
    }

    public boolean isOnStandby(Filter filter) {
        return Double.doubleToRawLongBits(this.getPosition()) == Double.doubleToRawLongBits(this.getStandbyPositionForFilter(filter));
    }

    public static double addAngle(double angle1, double angle2) {
        double angle = angle1 + angle2;
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void releaseClampsContact() {
    }

    public void engageClampsContact() {
    }
}

