/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.AutochangerHandler;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class CarouselMainModule
extends MainModule
implements AutochangerHandler {
    private CarouselModule carousel;
    private final FilterManager filterManager;

    public CarouselMainModule(String aName, int aTickMillis, BridgeToHardware bridge, FilterManager filterMg) {
        super(aName, aTickMillis, bridge);
        this.filterManager = filterMg;
    }

    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    public CarouselModule getCarousel() {
        return this.carousel;
    }

    @Override
    public void initModule() {
        this.carousel = (CarouselModule)((Object)this.getComponentByName("carousel"));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if Autochanger is holding filter at STANDBY.")
    public boolean isAutochangerHoldingFilterAtSTANDBY() {
        return false;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        super.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Check which filters are on Carousel and on which socketand update the sockets.")
    public void locateFilters() throws FcsHardwareException, BadCommandException {
        if (!this.controlRealHardware()) {
            FCSCst.FCSLOG.info((Object)(this.name + " locating filters....."));
            this.carousel.getSocketByName("socket1").putFilterOnSocket(this.filterManager.getFilterByName("filterU"));
            this.carousel.getSocketByName("socket2").putFilterOnSocket(this.filterManager.getFilterByName("filterG"));
            this.carousel.getSocketByName("socket3").putFilterOnSocket(this.filterManager.getFilterByName("filterR"));
            this.carousel.getSocketByName("socket4").putFilterOnSocket(this.filterManager.getFilterByName("filterI"));
            this.carousel.getSocketByName("socket5").putFilterOnSocket(this.filterManager.getFilterByName("filterZ"));
            this.carousel.engageClampsContact();
            this.filterManager.getFilterByName("filterY").setFilterLocation(FcsEnumerations.FilterLocation.OUT);
            TreeMap<String, Filter> filterMap = this.filterManager.filtersMap;
            for (Map.Entry entry : filterMap.entrySet()) {
                Filter filter = (Filter)((Object)entry.getValue());
                if (filter.isOnCarousel()) continue;
                this.filterManager.getFilterByName(filter.getName()).setFilterLocation(FcsEnumerations.FilterLocation.OUT);
            }
            this.carousel.getSocketByName("socket1").updateClampsStateWithSensorsFromSDO();
            this.carousel.getSocketByName("socket2").updateClampsStateWithSensorsFromSDO();
            this.carousel.getSocketByName("socket3").updateClampsStateWithSensorsFromSDO();
            this.carousel.getSocketByName("socket4").updateClampsStateWithSensorsFromSDO();
            this.carousel.getSocketByName("socket5").updateClampsStateWithSensorsFromSDO();
        }
    }

    public void start() {
        if (!this.controlRealHardware()) {
            try {
                this.locateFilters();
            }
            catch (BadCommandException | FcsHardwareException ex) {
                FCSCst.FCSLOG.error((Object)(this.name + " error in locateFilters:" + ex));
            }
        }
    }
}

