/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.BasicAutoChangerModule;

public class CarouselClampModule
extends MobileItemModule {
    private BridgeToHardware bridge;
    protected EPOSController controller;
    private final Sensor14bits filterPresenceSensor;
    private final Sensor14bits lockSensor;
    private final Thermometer thermometer;
    protected FcsEnumerations.FilterClampState clampState;
    protected FcsEnumerations.FilterPresenceStatus filterPresenceStatus;
    protected int currentToUnlock;
    protected int currentToMaintainUnlocked;
    private FcsEnumerations.LockStatus lockStatus;
    protected double temperature;
    private int lockSensorValueA;
    private int lockSensorValueB;
    private int lockSensorValueC;
    private int lockSensorOffset;
    private static final int LOCK_SENSOR_MINVALUE = 0;
    private static final int LOCK_SENSOR_MAX_VALUE = Short.MAX_VALUE;
    private static final int FILTER_POSITION_SENSOR_MINVALUE = 0;
    private static final int FILTER_POSITION_SENSOR_MAXVALUE = Short.MAX_VALUE;
    private int filterPresenceValueA;
    private int filterPresenceValueB;
    private int filterPresenceValueC;
    private int filterPresenceOffset;
    private boolean initialized = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    protected long timeoutForUnlocking = 4000L;
    protected long timeoutForReleasing = 4000L;

    public CarouselClampModule(String aName, int aTickMillis, Sensor14bits filterPresenceSensor, Sensor14bits lockSensor, Thermometer thermometer, int filterPresenceValueA, int filterPresenceValueB, int filterPresenceValueC, int filterPresenceOffset, int lockSensorValueA, int lockSensorValueB, int lockSensorValueC, int lockSensorOffset, int timeoutForUnlocking, int timeoutForReleasing, int currentToUnlock, int currentToMaintainUnlocked) {
        super(aName, aTickMillis);
        this.filterPresenceSensor = filterPresenceSensor;
        this.lockSensor = lockSensor;
        this.thermometer = thermometer;
        this.filterPresenceValueA = filterPresenceValueA;
        this.filterPresenceValueB = filterPresenceValueB;
        this.filterPresenceValueC = filterPresenceValueC;
        this.filterPresenceOffset = filterPresenceOffset;
        this.lockSensorValueA = lockSensorValueA;
        this.lockSensorValueB = lockSensorValueB;
        this.lockSensorValueC = lockSensorValueC;
        this.lockSensorOffset = lockSensorOffset;
        this.timeoutForUnlocking = timeoutForUnlocking;
        this.timeoutForReleasing = timeoutForReleasing;
        this.currentToUnlock = currentToUnlock;
        this.currentToMaintainUnlocked = currentToMaintainUnlocked;
    }

    public int getCurrentToUnlock() {
        return this.currentToUnlock;
    }

    protected void setController(EPOSController actuator) {
        this.controller = actuator;
    }

    @ConfigChanger
    public void setFilterPositionValueA(int valueA) {
        this.filterPresenceValueA = valueA;
    }

    @ConfigChanger
    public void setFilterPositionValueB(int valueB) {
        this.filterPresenceValueB = valueB;
    }

    @ConfigChanger
    public void setFilterPositionValueC(int valueC) {
        this.filterPresenceValueC = valueC;
    }

    public int getLockSensorValueA() {
        return this.lockSensorValueA;
    }

    @ConfigChanger
    public void setLockSensorValueA(int aValue) {
        this.lockSensorValueA = aValue;
    }

    public int getLockSensorValueB() {
        return this.lockSensorValueB;
    }

    @ConfigChanger
    public void setLockSensorValueB(int aValue) {
        this.lockSensorValueB = aValue;
    }

    public int getLockSensorValueC() {
        return this.lockSensorValueC;
    }

    @ConfigChanger
    public void setLockSensorValueC(int lockSensorValueC) {
        this.lockSensorValueC = lockSensorValueC;
    }

    public int getFilterPositionMaxValue() {
        return Short.MAX_VALUE;
    }

    public int getFilterPositionMinValue() {
        return 0;
    }

    public int getLockSensorMaxValue() {
        return Short.MAX_VALUE;
    }

    public int getLockSensorMinValue() {
        return 0;
    }

    @ConfigChanger
    public void setLockSensorOffset(int lockSensorOffset) {
        this.lockSensorOffset = lockSensorOffset;
    }

    public int getFilterPresenceValueA() {
        return this.filterPresenceValueA;
    }

    public int getFilterPresenceValueB() {
        return this.filterPresenceValueB;
    }

    public int getFilterPresenceValueC() {
        return this.filterPresenceValueC;
    }

    public int getLockSensorOffset() {
        return this.lockSensorOffset;
    }

    public int getFilterPositionOffset() {
        return this.filterPresenceOffset;
    }

    public void setFilterPositionOffset(int filterPresenceOffset) {
        this.filterPresenceOffset = filterPresenceOffset;
    }

    public Sensor14bits getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public Sensor14bits getLockSensor() {
        return this.lockSensor;
    }

    public Thermometer getThermometer() {
        return this.thermometer;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public long getTimeoutRelease() {
        return this.timeoutForReleasing;
    }

    @ConfigChanger
    public void setTimeoutRelease(long timeoutRelease) {
        this.timeoutForReleasing = timeoutRelease;
    }

    public long getTimeoutUnlock() {
        return this.timeoutForUnlocking;
    }

    @ConfigChanger
    public void setTimeoutUnlock(long timeoutUnlock) {
        this.timeoutForUnlocking = timeoutUnlock;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.bridge = (BridgeToHardware)this.getComponentByName("bridge");
        this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
        this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.temperature = 0.0;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean isHardwareReady() {
        return ((MainModule)((Object)this.getComponentByName("main"))).isHardwareReady();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        EPOSEnumerations.EposMode mode;
        try {
            mode = this.controller.readMode();
        }
        catch (FcsHardwareException ex) {
            FCSLOG.error((Object)ex);
            String msg = this.name + " ERROR while reading EPOS controller mode :" + ex.getMessage();
            FCSLOG.error((Object)msg);
            throw new HardwareException(false, (Throwable)ex);
        }
        if (!mode.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            throw new HardwareException(false, this.name + " is not in CURRENT mode.");
        }
        return TreeWalkerDiag.GO;
    }

    public FcsEnumerations.FilterClampState getClampState() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.name + ": getClampState interrupted while waiting for update."));
                }
            }
            FcsEnumerations.FilterClampState filterClampState = this.clampState;
            return filterClampState;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the clamp is locked")
    public boolean isLocked() {
        return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if filter is engaged on the clamp : filter presence sensors sees it ")
    public synchronized boolean isFilterEngaged() {
        return this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE);
    }

    public void updateFilterPresenceStatus() throws FcsHardwareException {
        this.filterPresenceSensor.updateValue();
        int newFilterPresenceSensorValue = this.filterPresenceSensor.getValue();
        int mechaValue = newFilterPresenceSensorValue - this.filterPresenceOffset;
        if (mechaValue < this.filterPresenceValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            FCSLOG.error((Object)(this.getName() + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue));
            throw new SensorValueOutOfRangeException("FILTER POSITION SENSOR", this.filterPresenceSensor.getName(), 0, this.filterPresenceValueA, mechaValue);
        }
        this.filterPresenceStatus = mechaValue < this.filterPresenceValueB ? FcsEnumerations.FilterPresenceStatus.LOCKABLE : (mechaValue < this.filterPresenceValueC ? FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE : FcsEnumerations.FilterPresenceStatus.NOFILTER);
    }

    private void updateFilterPresenceStatus(PDOStorage pdoStorage) throws FcsHardwareException {
        int newFilterPresenceSensorValue = this.filterPresenceSensor.updateValue(pdoStorage);
        int mechaValue = newFilterPresenceSensorValue - this.filterPresenceOffset;
        if (mechaValue < this.filterPresenceValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            FCSLOG.error((Object)(this.getName() + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue));
            throw new SensorValueOutOfRangeException("FILTER POSITION SENSOR", this.filterPresenceSensor.getName(), 0, Short.MAX_VALUE, mechaValue);
        }
        this.filterPresenceStatus = mechaValue < this.filterPresenceValueB ? FcsEnumerations.FilterPresenceStatus.LOCKABLE : (mechaValue < this.filterPresenceValueC ? FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE : FcsEnumerations.FilterPresenceStatus.NOFILTER);
    }

    public void updateLockStatus() throws FcsHardwareException {
        this.lockSensor.updateValue();
        int newLockSensorValue = this.lockSensor.getValue();
        int mechaValue = newLockSensorValue - this.lockSensorOffset;
        if (mechaValue < this.lockSensorValueA) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorValueB) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.lockSensorValueC) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            FCSLOG.error((Object)(this.getName() + " ERROR new read value FOR LOCK SENSOR  = " + newLockSensorValue));
            throw new SensorValueOutOfRangeException("ERROR in reading LOCK SENSOR", this.lockSensor.getName(), 0, Short.MAX_VALUE, mechaValue);
        }
    }

    private void updateLockStatus(PDOStorage pdoStorage) throws FcsHardwareException {
        int newLockSensorValue = this.lockSensor.updateValue(pdoStorage);
        int mechaValue = newLockSensorValue - this.lockSensorOffset;
        FCSLOG.info((Object)this.toString());
        FCSLOG.info((Object)(this.name + " value read=" + mechaValue));
        if (mechaValue < this.lockSensorValueA) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorValueB) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.lockSensorValueC) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            FCSLOG.error((Object)(this.getName() + " ERROR new read value FOR LOCK SENSOR  = " + newLockSensorValue));
            throw new SensorValueOutOfRangeException("ERROR in reading LOCK SENSOR", this.lockSensor.getName(), 0, Short.MAX_VALUE, mechaValue);
        }
    }

    @Deprecated
    public void updateStateWithSensorsFromSDO() throws FcsHardwareException {
        this.lock.lock();
        this.updatingState = true;
        try {
            this.updateFilterPresenceStatus();
            this.updateLockStatus();
            this.clampState = this.computeClampState();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, description="Read clamp sensors and update clampState", level=1, alias="updState")
    public void updateStateWithSensors() throws FcsHardwareException, BadCommandException {
        this.updateStateWithSensors(this.bridge.readPDOs());
    }

    void updateStateWithSensors(PDOStorage pdoStorage) throws FcsHardwareException {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.updateFilterPresenceStatus(pdoStorage);
            this.updateLockStatus(pdoStorage);
            this.clampState = this.computeClampState();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Override
    public void publishData() {
        StatusDataPublishedByCarouselClamp status = this.createStatusDataPublishedByClamp();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)status));
    }

    public StatusDataPublishedByCarouselClamp createStatusDataPublishedByClamp() {
        StatusDataPublishedByCarouselClamp status = new StatusDataPublishedByCarouselClamp();
        status.setName(this.name);
        status.setClampState(this.clampState.toString());
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        status.setFilterPositionSensorValue(this.filterPresenceSensor.getValue());
        status.setLockSensorValue(this.lockSensor.getValue());
        status.setLockStatus(this.lockStatus);
        status.setTemperature(this.temperature);
        return status;
    }

    public FcsEnumerations.FilterClampState computeClampState() {
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.ERROR) || this.lockStatus.equals((Object)FcsEnumerations.LockStatus.ERROR)) {
            return FcsEnumerations.FilterClampState.ERROR;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE)) {
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                return FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
            }
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                return FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
            }
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.NOFILTER)) {
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                return FcsEnumerations.FilterClampState.READYTOCLAMP;
            }
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                return FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
            }
            return FcsEnumerations.FilterClampState.ERROR;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE)) {
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        return FcsEnumerations.FilterClampState.UNDEFINED;
    }

    public void tick() {
        this.publishData();
    }

    @Command(level=3, description="Release clamp in order to get ready to clamp a filter again", type=Command.CommandType.ACTION)
    public String release() throws FcsHardwareException, BadCommandException, ErrorInCommandExecutionException {
        FCSLOG.info((Object)("Checking conditions for release clamp " + this.getName() + " on socket at standby position."));
        this.updateStateWithSensors();
        if (!this.clampState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY)) {
            throw new BadCommandException("Can't release a clamp if isn't unclamped and empty.");
        }
        FCSLOG.info((Object)("Releasing clamp " + this.getName() + " on socket at standby position."));
        return this.executeAction(FcsEnumerations.MobileItemAction.RELEASE, this.timeoutForReleasing);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamp")
    public String unlock() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.info((Object)(this.getName() + ": " + "UNLOCK State1 = " + this.clampState.toString()));
        this.updateStateWithSensors();
        if (!this.clampState.equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER)) {
            throw new BadCommandException("Can't unlock a clamp if it is already unlocked.");
        }
        BasicAutoChangerModule autochanger = (BasicAutoChangerModule)((Object)this.environment.getComponentByName("autochanger"));
        if (autochanger == null) {
            throw new BadCommandException("NO AUTOCHANGER");
        }
        if (!autochanger.isHoldingFilterAtStandby()) {
            throw new BadCommandException("CANNOT UNLOCK A CLAMP if FILTER is not HELD by autochanger.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK, this.timeoutForUnlocking);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws SDORequestException, BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.UNLOCK)) {
            this.controller.enable();
            this.controller.writeCurrent(this.currentToUnlock);
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.RELEASE)) {
            this.controller.off();
        } else {
            throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.UNLOCK)) {
            return this.clampState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.RELEASE)) {
            return this.clampState.equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP);
        }
        throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws FcsHardwareException, BadCommandException {
        this.updateStateWithSensors();
    }

    public double updateTemperature() throws FcsHardwareException {
        double temp;
        this.temperature = temp = this.thermometer.readTemperature();
        return temp;
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="display configuration values for this clamp.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/filterPresenceSensor=");
        sb.append(this.filterPresenceSensor.getName());
        sb.append("#valueA=");
        sb.append(this.filterPresenceValueA);
        sb.append("#valueB=");
        sb.append(this.filterPresenceValueB);
        sb.append("#valueC=");
        sb.append(this.filterPresenceValueC);
        sb.append("/lockSensor=");
        sb.append(this.lockSensor.getName());
        sb.append("#valueA=");
        sb.append(this.lockSensorValueA);
        sb.append("#valueB=");
        sb.append(this.lockSensorValueB);
        sb.append("#valueC=");
        sb.append(this.lockSensorValueC);
        return sb.toString();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.info((Object)("Current Command: " + this.getSubsystem().getCurrentAction() + " " + this.getSubsystem().getState()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

