/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class AutochangerThreeOnlineClamps
extends MobileItemModule {
    private AutoChangerModule autochanger;
    private final AutochangerOnlineClampModule onlineClampXminus;
    private final AutochangerOnlineClampModule onlineClampXplus;
    private final AutochangerOnlineClampModule onlineClampYminus;
    private FcsEnumerations.LockStatus lockStatus;
    private volatile boolean initialized;
    private final Condition stateUpdated;
    protected volatile boolean updatingState;
    private final long timeoutForLockingClamps;
    private final long timeoutForUnlockingClamps;

    public AutochangerThreeOnlineClamps(String moduleName, int aTickMillis, AutochangerOnlineClampModule onlineClampXminus, AutochangerOnlineClampModule onlineClampXplus, AutochangerOnlineClampModule onlineClampY, long timeoutForLockingClamps, long timeoutForUnlockingClamps) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampYminus = onlineClampY;
        this.timeoutForLockingClamps = timeoutForLockingClamps;
        this.timeoutForUnlockingClamps = timeoutForUnlockingClamps;
    }

    public AutochangerOnlineClampModule getOnlineClampXminus() {
        return this.onlineClampXminus;
    }

    public AutochangerOnlineClampModule getOnlineClampXplus() {
        return this.onlineClampXplus;
    }

    public AutochangerOnlineClampModule getOnlineClampYminus() {
        return this.onlineClampYminus;
    }

    public EPOSController getOnlineClampXminusController() {
        return this.onlineClampXminus.getController();
    }

    public EPOSController getOnlineClampXplusController() {
        return this.onlineClampXplus.getController();
    }

    public EPOSController getOnlineClampYminusController() {
        return this.onlineClampYminus.getController();
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Override
    public void initModule() {
        this.autochanger = (AutoChangerModule)((Object)this.getComponentByName("autochanger"));
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Override
    public boolean isHardwareReady() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Lock the online clamps.")
    public String lockClamps() throws BadCommandException, SDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Unlock the online clamps.")
    public String unlockClamps() throws BadCommandException, SDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS, this.timeoutForUnlockingClamps);
    }

    public StatusDataPublishedByAutochangerThreeClamps getStatusData() {
        return this.createStatusDataPublishedByThreeClamps();
    }

    public StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps() {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setName(this.name);
        status.setLockStatus(this.lockStatus);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerClamps", (Serializable)this.getStatusData()));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update autochanger state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.autochanger.updateStateWithSensors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            boolean inTravel;
            this.updatingState = true;
            this.onlineClampXminus.updateStateWithSensors(hexaValues);
            this.onlineClampXplus.updateStateWithSensors(hexaValues);
            this.onlineClampYminus.updateStateWithSensors(hexaValues);
            boolean inError = this.onlineClampXminus.isInError() || this.onlineClampXplus.isInError() || this.onlineClampYminus.isInError();
            boolean locked = this.onlineClampXminus.isLocked() || this.onlineClampXplus.isLocked() || this.onlineClampYminus.isLocked();
            boolean unlocked = this.onlineClampXminus.isUnlocked() || this.onlineClampXplus.isUnlocked() || this.onlineClampYminus.isUnlocked();
            boolean bl = inTravel = this.onlineClampXminus.isInTravel() || this.onlineClampXplus.isInTravel() || this.onlineClampYminus.isInTravel();
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : (inTravel ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }
}

