/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerOnlineClampModule
extends MobileItemModule
implements MovedByEPOSController {
    private AutoChangerModule autochanger;
    private final EPOSController controller;
    private final NumericSensor lockSensor;
    private final NumericSensor lockSensorC;
    private final NumericSensor unlockSensor;
    private final NumericSensor unlockSensorC;
    private final Map<String, Integer> paramsForCurrentToLock;
    private final Map<String, Integer> paramsForCurrentToUnlock;
    private int currentToLock;
    private int currentToUnlock;
    private int currentToClamp;
    private int holdTime = 2000;
    private int travelTime = 5000;
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private boolean inTravel;
    private boolean lockSensorInError;
    private boolean unlockSensorInError;
    private FcsEnumerations.LockStatus lockStatus;
    private boolean controllerInFault;
    private volatile boolean initialized;
    private boolean controllerConfigured = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;

    public AutochangerOnlineClampModule(String moduleName, int aTickMillis, EPOSController onlineClampController, NumericSensor lockSensor0, NumericSensor lockSensor1, NumericSensor unlockSensor0, NumericSensor unlockSensor1, int currentToLock, int currentToUnlock, int currentToClamp, Map<String, Integer> paramsForCurrentToLock, Map<String, Integer> paramsForCurrentToUnlock, int holdTime, int travelTime) {
        super(moduleName, aTickMillis);
        this.controller = onlineClampController;
        this.lockSensor = lockSensor0;
        this.lockSensorC = lockSensor1;
        this.unlockSensor = unlockSensor0;
        this.unlockSensorC = unlockSensor1;
        this.paramsForCurrentToLock = paramsForCurrentToLock;
        this.paramsForCurrentToUnlock = paramsForCurrentToUnlock;
        this.currentToLock = currentToLock;
        this.currentToUnlock = currentToUnlock;
        this.currentToClamp = currentToClamp;
        this.holdTime = holdTime;
        this.travelTime = travelTime;
    }

    public int getCurrentToLock() {
        return this.currentToLock;
    }

    @ConfigChanger
    public void setCurrentToLock(int currentToLock) {
        this.currentToLock = currentToLock;
    }

    public int getCurrentToUnlock() {
        return this.currentToUnlock;
    }

    @ConfigChanger
    public void setCurrentToUnlock(int currentToUnlock) {
        this.currentToUnlock = currentToUnlock;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    @ConfigChanger
    public void setCurrentToClamp(int currentToClamp) {
        this.currentToClamp = currentToClamp;
    }

    public int getHoldTime() {
        return this.holdTime;
    }

    @ConfigChanger
    public void setHoldTime(int holdTime) {
        this.holdTime = holdTime;
    }

    public int getTravelTime() {
        return this.travelTime;
    }

    @ConfigChanger
    public void setTravelTime(int travelTime) {
        this.travelTime = travelTime;
    }

    public EPOSController getController() {
        return this.controller;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public NumericSensor getLockSensor() {
        return this.lockSensor;
    }

    public NumericSensor getUnlockSensor() {
        return this.unlockSensor;
    }

    public NumericSensor getUnlockSensorC() {
        return this.unlockSensorC;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockSensor and lockSensorC retun the same value.")
    public boolean isLockSensorInError() {
        return this.lockSensorInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if unlockSensor and unlockSensorC retun the same value.")
    public boolean isUnlockSensorInError() {
        return this.unlockSensorInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that lockSensor or unlockSensor is in ERROR or thatunlockSensor and lockSensor return non consistant values.")
    public boolean isInError() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.ERROR);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED.")
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED.")
    public boolean isUnlocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=INTRAVEL.")
    public boolean isInTravel() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.INTRAVEL);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is in fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Override
    public String getControllerName() {
        return this.controller.getName();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)((Object)this.getComponentByName("autochanger"));
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        if (this.controller == null) {
            FCSLOG.error((Object)(this.name + "==>>> onlineController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.name + "==>>> null onlineClampController - fix groovy description file.");
        }
        if (this.controller instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.controller)});
        }
    }

    public void tick() {
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is initialized and configured.")
    public boolean isHardwareReady() {
        return ((MainModule)((Object)this.getComponentByName("main"))).isHardwareReady() && this.controller.isInitialized() && this.controllerConfigured;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionForUnlocking() throws FcsHardwareException {
        if (!this.isHardwareReady()) {
            throw new FcsHardwareException(this.name + ":controller not ready - can't be unlocked");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionForLocking() throws FcsHardwareException {
        if (!this.isHardwareReady()) {
            throw new FcsHardwareException(this.name + ":controller not ready - can't locked");
        }
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        FCSLOG.debug((Object)(this.name + " checking hardware."));
        try {
            this.controller.initializeAndCheckHardware();
            this.configureController();
            this.controller.writeParameters(EPOSEnumerations.EposMode.CURRENT);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        catch (ErrorInCommandExecutionException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read in the CPU of the controller parameters for mode CURRENT.If a parameter has a different value than in configuration, throws an exception.")
    public void checkControllerBeforeAction() throws HardwareException, FcsHardwareException {
        EPOSEnumerations.EposMode modeInCPU = this.controller.readMode();
        if (!modeInCPU.equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            String msg = this.name + " Controller is not in mode CURRENT";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        this.controller.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        this.controller.checkFault();
        if (!this.controller.isParametersOK()) {
            String msg = this.name + " Some parameter values are not" + " the same in CPU and configuration system.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        FCSLOG.debug((Object)(this.name + ":controller parameters are OK - ready for action."));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure controller.")
    public void configureController() throws SDORequestException, HardwareException, FcsHardwareException {
        try {
            this.controllerConfigured = false;
            this.controller.activateBrake();
            this.controller.shutdown();
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
            this.controllerConfigured = true;
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + (Object)((Object)ex)));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update latch state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.autochanger.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.lockSensor.updateValue(hexaValues);
            this.lockSensorC.updateValue(hexaValues);
            this.unlockSensor.updateValue(hexaValues);
            this.unlockSensorC.updateValue(hexaValues);
            this.locked = this.lockSensor.getDigitalValue() == 1 && this.lockSensorC.getDigitalValue() == 0;
            this.unlocked = this.unlockSensor.getDigitalValue() == 1 && this.unlockSensorC.getDigitalValue() == 0;
            this.inTravel = !this.locked && !this.unlocked;
            this.lockSensorInError = this.lockSensor.getDigitalValue() == this.lockSensorC.getDigitalValue();
            this.unlockSensorInError = this.unlockSensor.getDigitalValue() == this.unlockSensorC.getDigitalValue();
            boolean bl = this.inError = this.lockSensorInError || this.unlockSensorInError || this.locked && this.unlocked;
            if (this.inError) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            } else if (this.locked) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            } else if (this.unlocked) {
                this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
            } else if (this.inTravel) {
                this.lockStatus = FcsEnumerations.LockStatus.INTRAVEL;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case LOCK_ONLINECLAMP: {
                this.controller.enable();
                this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.controller.releaseBrake();
                this.controller.writeCurrent(this.currentToLock);
                break;
            }
            case UNLOCK_ONLINECLAMP: {
                this.controller.enable();
                this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.controller.writeCurrent(this.currentToClamp);
                this.controller.releaseBrake();
                this.slowDownCurrent();
                this.controller.writeCurrent(this.currentToUnlock);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock online clamp for CPPM test bench.")
    public String testLock() throws SDORequestException, ShortResponseToSDORequestException, BadCommandException, ErrorInCommandExecutionException, InterruptedException, FcsHardwareException, HardwareException {
        FCSLOG.debug((Object)(this.name + "BEGIN testLock"));
        this.checkConditionForLocking();
        FCSLOG.debug((Object)(this.name + ":condition for locking OK."));
        this.controller.enable();
        this.checkControllerBeforeAction();
        this.controller.releaseBrake();
        this.controller.writeCurrent(this.currentToLock);
        FCSLOG.debug((Object)(this.name + ": sent current to controller:" + this.currentToLock));
        FCSLOG.debug((Object)(this.name + ": sleeping for:" + this.travelTime));
        FCSLOG.debug((Object)(this.name + ":time=" + System.currentTimeMillis()));
        Thread.sleep(this.travelTime);
        FCSLOG.debug((Object)(this.name + ":time=" + System.currentTimeMillis()));
        this.controller.writeCurrent(this.currentToClamp);
        FCSLOG.debug((Object)(this.name + "==> current sent to controller=" + this.currentToClamp));
        FCSLOG.debug((Object)(this.name + ": sleeping for:" + this.holdTime));
        FCSLOG.debug((Object)(this.name + ":time=" + System.currentTimeMillis()));
        Thread.sleep(this.holdTime);
        FCSLOG.debug((Object)(this.name + ":time=" + System.currentTimeMillis()));
        this.controller.activateBrake();
        FCSLOG.debug((Object)(this.name + ": controller brake activated."));
        Thread.sleep(1000L);
        this.controller.writeCurrent(0);
        FCSLOG.debug((Object)(this.name + "==> current sent to controller=" + 0));
        this.controller.disable();
        FCSLOG.debug((Object)(this.name + "END testLock"));
        return this.name + " LOCKED";
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock online clamp for CPPM test bench.")
    public String testUnlock() throws SDORequestException, BadCommandException, ShortResponseToSDORequestException, ErrorInCommandExecutionException, InterruptedException, FcsHardwareException, HardwareException {
        FCSLOG.debug((Object)(this.name + "BEGIN testUnlock"));
        this.checkConditionForUnlocking();
        FCSLOG.debug((Object)(this.name + ":controller parameters are OK."));
        this.controller.enable();
        this.checkControllerBeforeAction();
        this.controller.writeCurrent(this.currentToClamp);
        this.controller.releaseBrake();
        Thread.sleep(1000L);
        this.slowDownCurrent();
        this.controller.writeCurrent(this.currentToUnlock);
        Thread.sleep(this.travelTime + 3000);
        this.controller.writeCurrent(0);
        Thread.sleep(10000L);
        this.controller.disable();
        FCSLOG.debug((Object)(this.name + "END testUnlock"));
        return this.name + " UNLOCKED";
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.controller.quickStop();
        this.controller.activateBrake();
        this.controller.disable();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case LOCK_ONLINECLAMP: {
                this.controller.writeCurrent(this.currentToClamp);
                try {
                    Thread.sleep(this.holdTime);
                }
                catch (InterruptedException ex) {
                    throw new ErrorInCommandExecutionException(this.name + " was interrupted during action " + action.toString());
                }
                this.controller.activateBrake();
                this.controller.writeCurrent(0);
                this.controller.disable();
                break;
            }
            case UNLOCK_ONLINECLAMP: {
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    public void slowDownCurrent() throws BadCommandException, SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        int step = this.currentToClamp / 5;
        for (int curr = this.currentToClamp - step; curr > 0; curr -= step) {
            FCSLOG.debug((Object)("current=" + curr));
            this.controller.writeCurrent(curr);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                throw new BadCommandException(this.name + " was interrupted during action testLock." + ex.getMessage());
            }
            int actualCurrent = this.controller.readCurrent();
            if (actualCurrent == curr) continue;
            FCSLOG.error((Object)(this.name + ": CURRENT ERROR in" + " slowDownCurrent actualCurrent=" + actualCurrent + ",curr=" + curr));
        }
        FCSLOG.debug((Object)"current=0");
        this.controller.writeCurrent(0);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() throws SDORequestException, FcsHardwareException {
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0005");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "C20");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() throws SDORequestException, FcsHardwareException {
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "0");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8001");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "8001");
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSLOG.debug((Object)(this.name + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (!(source instanceof EPOSController)) {
            return;
        }
        if (v.getValue() instanceof EmergencyMessage) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            FCSLOG.debug((Object)(this.name + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
            this.processEmergencyMessage(emcyMsg);
        } else if (v.getValue() instanceof String) {
            EPOSController ctrl = (EPOSController)((Object)source);
            String msgFromController = (String)v.getValue();
            if (ctrl.getName().equals(this.controller.getName()) && msgFromController.equals("faultReset")) {
                this.controllerInFault = false;
                this.publishData();
            }
        }
    }

    public StatusDataPublishedByAutochangerOnlineClamp getStatusData() {
        StatusDataPublishedByAutochangerOnlineClamp status = this.createStatusDataPublishedByOnlineClamp();
        return status;
    }

    public StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp() {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setName(this.name);
        status.setLockSensorValue(this.lockSensor.getDigitalValue());
        status.setUnlockSensorValue(this.unlockSensor.getDigitalValue());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorInError(this.lockSensorInError);
        status.setUnlockSensorInError(this.unlockSensorInError);
        status.setInError(this.inError);
        status.setControllerInFault(this.controllerInFault);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.getStatusData()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.controller.quickStop();
    }
}

