/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerLatchModule
extends MobileItemModule {
    private AutoChangerModule autochanger;
    private final EPOSController latchController;
    private final NumericSensor filterPresenceSensor;
    private final NumericSensor lockSensor;
    private final NumericSensor unlockSensor;
    private volatile boolean filterEngaged;
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private boolean inTravel;
    private int minCurrent;
    private int maxCurrent;
    private int currentToOpen;
    private int readCurrent;
    private FcsEnumerations.LockStatus lockStatus;
    private volatile boolean initialized;
    private final Condition stateUpdated;
    protected volatile boolean updatingState;
    private final long timeoutForOpening;
    private final long timeoutForClosing;
    private boolean controllerInFault;

    public AutochangerLatchModule(String moduleName, int aTickMillis, EPOSController latchController, long timeoutForClosing, long timeoutForOpening, NumericSensor lockSensor, NumericSensor unlockSensor, NumericSensor filterPresenceSensor, int minCurrent, int maxCurrent, int currentToOpen) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.filterEngaged = false;
        this.latchController = latchController;
        this.timeoutForClosing = timeoutForClosing;
        this.timeoutForOpening = timeoutForOpening;
        this.lockSensor = lockSensor;
        this.unlockSensor = unlockSensor;
        this.filterPresenceSensor = filterPresenceSensor;
        this.minCurrent = minCurrent;
        this.maxCurrent = maxCurrent;
        this.currentToOpen = currentToOpen;
    }

    public NumericSensor getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public NumericSensor getLockSensor() {
        return this.lockSensor;
    }

    public NumericSensor getUnlockSensor() {
        return this.unlockSensor;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this latch controller name.")
    public String getControllerName() {
        return this.latchController.getName();
    }

    public EPOSController getLatchController() {
        return this.latchController;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latchController is in Fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latch is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @ConfigChanger
    public void setMinCurrent(int minCurrent) {
        this.minCurrent = minCurrent;
    }

    @ConfigChanger
    public void setMaxCurrent(int maxCurrent) {
        this.maxCurrent = maxCurrent;
    }

    @ConfigChanger
    public void setCurrentToOpen(int currentToOpen) {
        this.currentToOpen = currentToOpen;
    }

    public int getMinCurrent() {
        return this.minCurrent;
    }

    public int getMaxCurrent() {
        return this.maxCurrent;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.name + ": interrupted in getLockStatus."));
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED")
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isUnlocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that unlockSensor and lockSensor return non consistant values.")
    public boolean isInError() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.ERROR);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger is empty.")
    public boolean isEmpty() {
        return !this.filterEngaged;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)((Object)this.getComponentByName("autochanger"));
        if (this.latchController == null) {
            FCSLOG.error((Object)(this.name + "==>>> latchController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.name + "==>>> null latchController - fix groovy description file.");
        }
        if (this.latchController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.latchController)});
        }
    }

    public void tick() {
        this.publishData();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.latchController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + ":" + (Object)((Object)ex)));
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        this.initialized = true;
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update latch state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.autochanger.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.filterPresenceSensor.updateValue(hexaValues);
            this.lockSensor.updateValue(hexaValues);
            this.unlockSensor.updateValue(hexaValues);
            this.filterEngaged = this.filterPresenceSensor.getDigitalValue() == 1;
            this.locked = this.lockSensor.getDigitalValue() == 1;
            this.unlocked = this.unlockSensor.getDigitalValue() == 1;
            this.inTravel = !this.locked && !this.unlocked;
            boolean bl = this.inError = this.locked && this.unlocked;
            if (this.inError) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            } else if (this.locked) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            } else if (this.unlocked) {
                this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
            } else if (this.inTravel) {
                this.lockStatus = FcsEnumerations.LockStatus.INTRAVEL;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update latch current in reading controller.")
    public void updateCurrent() throws BadCommandException, SDORequestException, FcsHardwareException {
        try {
            this.readCurrent = this.latchController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger hardware is connected and ready.")
    public boolean isHardwareReady() {
        return this.autochanger.isHardwareReady();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latch.")
    public String close() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.locked) {
            throw new BadCommandException(this.name + " is already LOCKED.");
        }
        this.autochanger.checkPreConditionsForClosingLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open latch.")
    public String open() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.unlocked) {
            throw new BadCommandException(this.name + " is already UNLOCKED.");
        }
        this.autochanger.checkPreConditionsForOpeningLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
            }
            case CLOSE: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED);
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case OPEN: {
                this.latchController.enable();
                this.latchController.writeCurrent(this.currentToOpen);
                break;
            }
            case CLOSE: {
                this.latchController.enable();
                this.latchController.writeCurrent(-this.currentToOpen);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.latchController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.abortAction(action, delay);
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.latchController.off();
        this.publishData();
        FCSLOG.info((Object)(this.name + ":" + action.toString() + " completed - doing postAction."));
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        String msgFromController;
        EPOSController ctrl;
        FCSLOG.debug((Object)(this.name + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (!(source instanceof EPOSController)) {
            return;
        }
        if (v.getValue() instanceof EmergencyMessage) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            FCSLOG.debug((Object)(this.name + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
            if (this.latchController.getName().equals(emcyMsg.getDeviceName())) {
                String errCode;
                switch (errCode = emcyMsg.getDeviceErrorCode()) {
                    case "00": {
                        FCSLOG.debug((Object)(this.name + ":faultReset ?=" + emcyMsg.toString()));
                        this.controllerInFault = false;
                        break;
                    }
                    default: {
                        FCSLOG.debug((Object)(this.name + ":EmergencyMessage received for " + "my controller from CanOpenProxy=" + emcyMsg.toString()));
                        this.controllerInFault = true;
                    }
                }
                this.publishData();
            }
        } else if (v.getValue() instanceof String && (ctrl = (EPOSController)((Object)source)).getName().equals(this.latchController.getName()) && (msgFromController = (String)v.getValue()).equals("faultReset")) {
            this.controllerInFault = false;
            this.publishData();
        }
    }

    public StatusDataPublishedByAutochangerLatch getStatusData() {
        StatusDataPublishedByAutochangerLatch status = this.createStatusDataPublishedByLatch();
        return status;
    }

    public StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch() {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setName(this.name);
        status.setLockSensorValue(this.lockSensor.getDigitalValue());
        status.setUnlockSensorValue(this.unlockSensor.getDigitalValue());
        status.setFilterPresenceSensorValue(this.filterPresenceSensor.getDigitalValue());
        status.setLockStatus(this.lockStatus);
        status.setControllerInFault(this.controllerInFault);
        return status;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish Data on the Status Bus.")
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.getStatusData();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)status));
    }
}

