/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutoChangerTrucksModule
extends MobileItemModule {
    protected NumericSensor handoffPositionSensor0;
    protected NumericSensor handoffPositionSensor1;
    protected NumericSensor onlinePositionSensor0;
    protected NumericSensor onlinePositionSensor1;
    protected NumericSensor standbyPositionSensor0;
    protected NumericSensor standbyPositionSensor1;
    private final int encoderRibbonMinValue;
    private final int encoderRibbonMaxValue;
    private final int minActualPositionValue;
    private final int maxActualPositionValue;
    private int position;
    private final int standbyPosition;
    private final int handoffPosition;
    private final int onlinePosition;
    private int current;
    private int speed;
    private int absoluteTargetPosition;
    private int relativeTargetPosition;
    private final long timeoutForTrucksMotion;
    private EPOSController linearRailMasterController;
    private EPOSController linearRailSlaveController;
    private AutoChangerModule autochanger;
    private final Condition stateUpdated;
    protected volatile boolean updatingState;
    private boolean masterControllerInFault;
    private boolean slaveControllerInFault;
    private boolean atHandoff;
    private boolean atOnline;
    private boolean atStandby;
    private boolean standbySensorsInError;
    private boolean handoffSensorsInError;
    private boolean onlineSensorsInError;
    private boolean homingDone;

    public AutoChangerTrucksModule(String moduleName, int aTickMillis, int encoderRibbonMinValue, int encoderRibbonMaxValue, int minActualValue, int maxActualValue, int standbyPosition, int handoffPosition, int onlinePosition, long timeoutForTrucksMotion, NumericSensor handoffPositionSensor0, NumericSensor handoffPositionSensor1, NumericSensor onlinePositionSensor0, NumericSensor onlinePositionSensor1, NumericSensor standbyPositionSensor0, NumericSensor standbyPositionSensor1) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.encoderRibbonMinValue = encoderRibbonMinValue;
        this.encoderRibbonMaxValue = encoderRibbonMaxValue;
        this.minActualPositionValue = minActualValue;
        this.maxActualPositionValue = maxActualValue;
        this.standbyPosition = standbyPosition;
        this.handoffPosition = handoffPosition;
        this.onlinePosition = onlinePosition;
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
        this.standbyPositionSensor0 = standbyPositionSensor0;
        this.handoffPositionSensor0 = handoffPositionSensor0;
        this.onlinePositionSensor0 = onlinePositionSensor0;
        this.standbyPositionSensor1 = standbyPositionSensor1;
        this.handoffPositionSensor1 = handoffPositionSensor1;
        this.onlinePositionSensor1 = onlinePositionSensor1;
        this.absoluteTargetPosition = 0;
        this.relativeTargetPosition = 0;
        this.masterControllerInFault = false;
        this.slaveControllerInFault = false;
        this.standbySensorsInError = false;
        this.onlineSensorsInError = false;
        this.handoffSensorsInError = false;
        this.atHandoff = false;
        this.atOnline = false;
        this.atStandby = false;
        this.homingDone = false;
        this.current = 0;
        this.speed = 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return actual trucks position. Doesn't read again the position on the controller.")
    public int getPosition() {
        return this.position;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return HANDOFF position.")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return STANDBY position.")
    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return ONLINE position.")
    public int getOnlinePosition() {
        return this.onlinePosition;
    }

    public int getEncoderRibbonMinValue() {
        return this.encoderRibbonMinValue;
    }

    public int getEncoderRibbonMaxValue() {
        return this.encoderRibbonMaxValue;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the master controller is in fault.")
    public boolean isMasterControllerInFault() {
        return this.masterControllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the slave controller is in fault.")
    public boolean isSlaveControllerInFault() {
        return this.slaveControllerInFault;
    }

    public EPOSController getLinearRailMasterController() {
        return this.linearRailMasterController;
    }

    public EPOSController getLinearRailSlaveController() {
        return this.linearRailSlaveController;
    }

    public NumericSensor getStandbyPositionSensor0() {
        return this.standbyPositionSensor0;
    }

    public NumericSensor getHandoffPositionSensor0() {
        return this.handoffPositionSensor0;
    }

    public NumericSensor getOnlinePositionSensor0() {
        return this.onlinePositionSensor0;
    }

    public NumericSensor getStandbyPositionSensor1() {
        return this.standbyPositionSensor1;
    }

    public NumericSensor getOnlinePositionSensor1() {
        return this.onlinePositionSensor1;
    }

    public NumericSensor getHandoffPositionSensor1() {
        return this.handoffPositionSensor1;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Standby are equal.")
    public boolean isStandbySensorsInError() {
        return this.standbySensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Handoff are equal.")
    public boolean isHandoffSensorsInError() {
        return this.handoffSensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Online are equal.")
    public boolean isOnlineSensorsInError() {
        return this.onlineSensorsInError;
    }

    public long getTimeoutForTrucksMotion() {
        return this.timeoutForTrucksMotion;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at handoff position. This command doesn't read again the sensors.")
    public boolean isAtHandoffPosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.atHandoff;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ONLINE position. This command doesn't read again the sensors.")
    public boolean isAtOnlinePosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.atOnline;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STANDBY position. This command doesn't read again the sensors.")
    public boolean isAtStandbyPosition() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.atStandby;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the homing of the trucks has been done.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)((Object)this.getComponentByName("autochanger"));
        this.linearRailMasterController = (EPOSController)this.getComponentByName("linearRailMasterController");
        this.linearRailSlaveController = (EPOSController)this.getComponentByName("linearRailSlaveController");
        if (this.linearRailMasterController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.linearRailMasterController)});
        }
        if (this.linearRailSlaveController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.linearRailSlaveController)});
        }
    }

    public void tick() {
        this.publishData();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        FCSLOG.debug((Object)(this.name + " checking hardware."));
        try {
            this.linearRailSlaveController.initializeAndCheckHardware();
            this.linearRailMasterController.initializeAndCheckHardware();
            this.configureControllers();
            this.homing();
            this.linearRailSlaveController.enable();
            this.linearRailMasterController.enable();
        }
        catch (SDORequestException ex) {
            FCSLOG.error((Object)(this.name + ":" + (Object)((Object)ex)));
        }
        catch (BadCommandException | ErrorInCommandExecutionException ex) {
            throw new HardwareException(true, ex);
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + ":" + (Object)((Object)ex)));
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure Autochanger trucks master and slave controllers.", alias="initControllers")
    public void configureControllers() throws SDORequestException, FcsHardwareException {
        FCSLOG.info((Object)(this.name + " Begin configuration of the controllers"));
        this.linearRailMasterController.shutdown();
        this.linearRailSlaveController.shutdown();
        AutoChangerTrucksModule.configureDigitalInputOfLinearRails(this.linearRailMasterController);
        AutoChangerTrucksModule.configureDigitalInputOfLinearRails(this.linearRailSlaveController);
        AutoChangerTrucksModule.configureDigitalOutputOfLinearRails(this.linearRailMasterController);
        AutoChangerTrucksModule.configureDigitalOutputOfLinearRails(this.linearRailSlaveController);
        FCSLOG.info((Object)(this.name + " End configuration of the controllers"));
    }

    public boolean isInitialized() {
        return this.linearRailMasterController.isInitialized() && this.linearRailSlaveController.isInitialized() && this.homingDone;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.", alias="goToHandoff")
    public void goToHandOff() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.atHandoff) {
            throw new BadCommandException(this.name + " already at Handoff Position.");
        }
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.atOnline) {
            throw new BadCommandException(this.name + " is already at Online Position.");
        }
        this.moveToAbsoluteTargetPosition(this.onlinePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.atStandby) {
            throw new BadCommandException(this.name + " is already at  Standby Position.");
        }
        this.moveToAbsoluteTargetPosition(this.standbyPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the absolute position given as argument.", alias="mobeABSPos")
    public void moveToAbsoluteTargetPosition(int targetPosition) throws BadCommandException, SDORequestException, ShortResponseToSDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        this.updatePosition();
        if (this.position == targetPosition) {
            throw new BadCommandException(this.name + " is already at target position=" + targetPosition);
        }
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            String msg = this.name + " cant' do homing because controllers are not both initialized:\n";
            msg = msg + this.name + this.linearRailSlaveController.toString();
            msg = msg + this.name + this.linearRailMasterController.toString();
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (!this.homingDone) {
            throw new FcsHardwareException(this.name + " can't be moved because the homing has not been done yet. ");
        }
        if (targetPosition < this.minActualPositionValue || targetPosition > this.maxActualPositionValue) {
            throw new IllegalArgumentException(this.name + "argument has to be between " + this.minActualPositionValue + " and " + this.maxActualPositionValue);
        }
        this.absoluteTargetPosition = targetPosition;
        FCSLOG.info((Object)(this.name + " going to absolute position: " + this.absoluteTargetPosition));
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION, this.timeoutForTrucksMotion);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the relative position given as argument.", alias="moveRELPos")
    public void moveToRelativeTargetPosition(int relativePosition) throws BadCommandException, SDORequestException, ShortResponseToSDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        if (relativePosition < -2000 || relativePosition > 2000) {
            throw new IllegalArgumentException("Relative position value has to be between -2000 and 2000");
        }
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            String msg = this.name + " cant' do homing because controllers are not both initialized:\n";
            msg = msg + this.name + this.linearRailSlaveController.toString();
            msg = msg + this.name + this.linearRailMasterController.toString();
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (!this.homingDone) {
            throw new BadCommandException(this.name + " can't be moved because the homing has not been done. ");
        }
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.updatePosition();
        if (this.position + relativePosition < this.minActualPositionValue || this.position + relativePosition > this.maxActualPositionValue) {
            throw new IllegalArgumentException(this.name + "actual position + argument has to be between " + this.minActualPositionValue + " and " + this.maxActualPositionValue);
        }
        this.relativeTargetPosition = this.position + relativePosition;
        FCSLOG.info((Object)(this.name + " going to relative position: " + this.relativeTargetPosition));
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_RELATIVE_POSITION, this.timeoutForTrucksMotion);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord("3F");
                break;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.relativeTargetPosition);
                this.linearRailMasterController.writeControlWord("7F");
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    private void enableControllersAndReleaseBrake() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        if (!this.linearRailMasterController.isEnabled()) {
            this.linearRailMasterController.enable();
        }
        if (!this.linearRailSlaveController.isEnabled()) {
            this.linearRailSlaveController.enable();
        }
        this.linearRailMasterController.releaseBrake();
        this.linearRailSlaveController.releaseBrake();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        FCSLOG.info((Object)("ABORTING action: " + action.toString()));
        this.linearRailMasterController.off();
        this.linearRailSlaveController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.linearRailMasterController.quickStop();
        this.linearRailSlaveController.quickStop();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.linearRailSlaveController.disable();
        this.linearRailMasterController.disable();
        FCSLOG.info((Object)(this.name + ":" + action.toString() + " completed - doing postAction."));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Read actual position and do the homing of the master controllerwith this actual position.")
    public void homing() throws SDORequestException, ErrorInCommandExecutionException, ShortResponseToSDORequestException, BadCommandException, FcsHardwareException {
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            FCSLOG.error((Object)(this.name + " cant' do homing because controllers are not both initialized:"));
            FCSLOG.info((Object)(this.name + this.linearRailSlaveController.toString()));
            FCSLOG.info((Object)(this.name + this.linearRailMasterController.toString()));
        }
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailMasterController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailMasterController.enable();
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        this.linearRailSlaveController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailSlaveController.enable();
        FCSLOG.debug((Object)(this.name + "==> BEGIN homing of the trucks"));
        int ssiPosition = this.linearRailMasterController.readSSIPosition();
        int offset = ssiPosition - this.encoderRibbonMinValue;
        FCSLOG.debug((Object)(this.name + " position=" + ssiPosition + ",offset=" + offset));
        this.linearRailMasterController.defineAbsolutePosition(offset);
        this.linearRailMasterController.off();
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.homingDone = true;
        FCSLOG.debug((Object)(this.name + " ==> END homing of the trucks"));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller.")
    public void updatePosition() throws BadCommandException, SDORequestException, FcsHardwareException {
        try {
            this.position = this.linearRailMasterController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller and return position.")
    public int readPosition() throws BadCommandException, SDORequestException, FcsHardwareException {
        this.updatePosition();
        return this.position;
    }

    @Override
    public boolean isHardwareReady() {
        return this.isInitialized();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                return this.position == this.absoluteTargetPosition;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                return this.position == this.relativeTargetPosition;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        try {
            this.linearRailMasterController.checkFault();
            this.linearRailSlaveController.checkFault();
            this.position = this.linearRailMasterController.readPosition();
            FCSLOG.debug((Object)(this.name + " position=" + this.position));
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> SDO ERROR IN READING CONTROLLER:" + (Object)((Object)ex)));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update Trucks state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.autochanger.updateStateWithSensors();
    }

    protected void updateStateWithSensors(String[] readHexaValues) throws FcsHardwareException {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.handoffPositionSensor0.updateValue(readHexaValues);
            this.handoffPositionSensor1.updateValue(readHexaValues);
            this.onlinePositionSensor0.updateValue(readHexaValues);
            this.onlinePositionSensor1.updateValue(readHexaValues);
            this.standbyPositionSensor0.updateValue(readHexaValues);
            this.standbyPositionSensor1.updateValue(readHexaValues);
            this.atHandoff = this.handoffPositionSensor0.getDigitalValue() == 1 && this.handoffPositionSensor1.getDigitalValue() == 1;
            this.atOnline = this.onlinePositionSensor0.getDigitalValue() == 1 && this.onlinePositionSensor1.getDigitalValue() == 1;
            this.atStandby = this.standbyPositionSensor0.getDigitalValue() == 1 && this.standbyPositionSensor1.getDigitalValue() == 1;
            this.handoffSensorsInError = this.handoffPositionSensor0.getDigitalValue() != this.handoffPositionSensor1.getDigitalValue();
            this.onlineSensorsInError = this.onlinePositionSensor0.getDigitalValue() != this.onlinePositionSensor1.getDigitalValue();
            this.standbySensorsInError = this.standbyPositionSensor0.getDigitalValue() != this.standbyPositionSensor1.getDigitalValue();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public static void configureDigitalInputOfLinearRails(EPOSController ctl) throws SDORequestException, FcsHardwareException {
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0004");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, "0005");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "30");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public static void configureDigitalOutputOfLinearRails(EPOSController ctl) throws SDORequestException, FcsHardwareException {
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "000F");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, "0002");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "0004");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8005");
    }

    public StatusDataPublishedByAutoChangerTrucks getStatusData() {
        return this.createStatusDataPublishedByAutoChangerTrucks();
    }

    public StatusDataPublishedByAutoChangerTrucks createStatusDataPublishedByAutoChangerTrucks() {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setName(this.name);
        s.setPosition(this.position);
        s.setMasterControllerInFault(this.isMasterControllerInFault());
        s.setSlaveControllerInFault(this.isSlaveControllerInFault());
        s.setCurrent(this.current);
        s.setSpeed(this.speed);
        s.setHandoffInError(this.handoffSensorsInError);
        s.setOnlineInError(this.onlineSensorsInError);
        s.setStandbyInError(this.standbySensorsInError);
        s.setHandoffSensorValue0(this.handoffPositionSensor0.getDigitalValue());
        s.setHandoffSensorValue1(this.handoffPositionSensor1.getDigitalValue());
        s.setOnlineSensorValue0(this.onlinePositionSensor0.getDigitalValue());
        s.setOnlineSensorValue1(this.onlinePositionSensor1.getDigitalValue());
        s.setStandbySensorValue0(this.standbyPositionSensor0.getDigitalValue());
        s.setStandbySensorValue1(this.standbyPositionSensor1.getDigitalValue());
        return s;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.getStatusData()));
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSLOG.debug((Object)(this.name + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (!(source instanceof EPOSController)) {
            return;
        }
        if (v.getValue() instanceof EmergencyMessage) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            FCSLOG.debug((Object)(this.name + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
            this.handleEmergencyMessageFromControllers(emcyMsg);
        } else if (v.getValue() instanceof String) {
            EPOSController ctrl = (EPOSController)((Object)source);
            String msgFromController = (String)v.getValue();
            this.handleStringMessageFromControllers(ctrl.getName(), msgFromController);
        }
    }

    private void handleEmergencyMessageFromControllers(EmergencyMessage emcyMsg) {
        if (this.linearRailMasterController.getName().equals(emcyMsg.getDeviceName())) {
            String errCode;
            switch (errCode = emcyMsg.getDeviceErrorCode()) {
                case "00": {
                    FCSLOG.debug((Object)(this.name + ":faultReset ?=" + emcyMsg.toString()));
                    this.masterControllerInFault = false;
                    break;
                }
                default: {
                    FCSLOG.debug((Object)(this.name + ":EmergencyMessage received for " + "master controller from CanOpenProxy=" + emcyMsg.toString()));
                    this.masterControllerInFault = true;
                }
            }
            this.publishData();
        } else if (this.linearRailSlaveController.getName().equals(emcyMsg.getDeviceName())) {
            String errCode;
            switch (errCode = emcyMsg.getDeviceErrorCode()) {
                case "00": {
                    FCSLOG.debug((Object)(this.name + ":faultReset ?=" + emcyMsg.toString()));
                    this.slaveControllerInFault = false;
                    break;
                }
                default: {
                    FCSLOG.debug((Object)(this.name + ":EmergencyMessage received for " + "slave controller from CanOpenProxy=" + emcyMsg.toString()));
                    this.slaveControllerInFault = true;
                }
            }
            this.publishData();
        }
    }

    private void handleStringMessageFromControllers(String controllerName, String msgFromController) {
        if (controllerName.equals(this.linearRailMasterController.getName())) {
            switch (msgFromController) {
                case "faultReset": {
                    this.masterControllerInFault = false;
                    this.publishData();
                    break;
                }
                case "checkFault": {
                    this.masterControllerInFault = this.linearRailMasterController.isInError();
                    break;
                }
                default: {
                    assert (false) : msgFromController;
                    {
                        break;
                    }
                }
            }
        } else if (controllerName.equals(this.linearRailSlaveController.getName())) {
            switch (msgFromController) {
                case "faultReset": {
                    this.slaveControllerInFault = false;
                    this.publishData();
                    break;
                }
                case "checkFault": {
                    this.slaveControllerInFault = this.linearRailSlaveController.isInError();
                    break;
                }
                default: {
                    assert (false) : msgFromController;
                    break;
                }
            }
        }
    }
}

