/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class AutoChangerModule
extends Module
implements HardwareController {
    private BridgeToHardware bridge;
    private final String plutoGatewayName;
    private PlutoGatewayModule plutoGateway;
    private final NumericSensor loaderConnectedSensor0;
    private final NumericSensor loaderConnectedSensor1;
    private final AutoChangerTrucksModule autochangerTrucks;
    private final AutochangerTwoLatches latches;
    private final AutochangerThreeOnlineClamps onlineClamps;
    private CarouselModule carousel;
    private LoaderModule loader;
    private boolean loaderConnectedSensorsInError;
    private boolean empty;
    private boolean loaderConnected;
    private final boolean standalone = true;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public AutoChangerModule(String name, int tickMillis, String plutoGatewayName, NumericSensor loaderConnectedSensor0, NumericSensor loaderConnectedSensor1, AutoChangerTrucksModule trucks, AutochangerTwoLatches latches, AutochangerThreeOnlineClamps onlineClamps) {
        super(name, tickMillis);
        this.plutoGatewayName = plutoGatewayName;
        this.loaderConnectedSensor0 = loaderConnectedSensor0;
        this.loaderConnectedSensor1 = loaderConnectedSensor1;
        this.autochangerTrucks = trucks;
        this.latches = latches;
        this.onlineClamps = onlineClamps;
        this.loaderConnected = false;
        this.loaderConnectedSensorsInError = false;
    }

    public NumericSensor getLoaderConnectedSensor0() {
        return this.loaderConnectedSensor0;
    }

    public NumericSensor getLoaderConnectedSensor1() {
        return this.loaderConnectedSensor1;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant loader sensors are equal.")
    public boolean isLoaderConnectedSensorsInError() {
        return this.loaderConnectedSensorsInError;
    }

    public int getHandoffPosition() {
        return this.autochangerTrucks.getHandoffPosition();
    }

    public int getOnlinePosition() {
        return this.autochangerTrucks.getOnlinePosition();
    }

    public int getStandbyPosition() {
        return this.autochangerTrucks.getStandbyPosition();
    }

    public AutochangerTwoLatches getLatches() {
        return this.latches;
    }

    public AutoChangerTrucksModule getTrucks() {
        return this.autochangerTrucks;
    }

    public AutochangerThreeOnlineClamps getOnlineClamps() {
        return this.onlineClamps;
    }

    public PlutoGatewayModule getPlutoGateway() {
        return this.plutoGateway;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected to the camera. This command doesn't read again the sensors.")
    public boolean isLoaderConnected() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.loaderConnected && !this.loaderConnectedSensorsInError;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCarouselHoldingFilterAtStandby() throws FcsHardwareException {
        return true;
    }

    public void initModule() {
        FCSCst.FCSLOG.info((Object)(this.name + ": init MODULE"));
        this.plutoGateway = (PlutoGatewayModule)this.getComponentByName(this.plutoGatewayName);
        this.bridge = (BridgeToHardware)this.getComponentByName("bridge");
        this.carousel = (CarouselModule)((Object)this.getComponentByName("carousel"));
        this.loader = (LoaderModule)((Object)this.getComponentByName("loader"));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger hardware is initialized and bridge is hardwareReady.")
    public boolean isHardwareReady() {
        return this.bridge.isHardwareReady() && this.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger hardware is initialized.")
    public boolean isInitialized() {
        return this.plutoGateway.isInitialized() && this.autochangerTrucks.isInitialized();
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        FCSCst.FCSLOG.debug((Object)(this.name + " checking hardware."));
        try {
            this.plutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.autochangerTrucks.checkHardware();
        this.latches.checkHardware();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void checkStarted() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN checkStarted"));
        this.bridge.getTcpProxy().checkNewHardware();
        try {
            this.plutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.autochangerTrucks.checkHardware();
    }

    public void checkStopped() throws HardwareException {
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the latches can be opened.")
    public boolean checkPreConditionsForOpeningLatches() throws SDORequestException, BadCommandException, FcsHardwareException, ErrorInCommandExecutionException {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for opening latches"));
        this.updateStateWithSensors();
        if (this.isEmpty()) {
            String msg = this.name + ": no filter in autochanger - can't open latches.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (!this.autochangerTrucks.isAtStandbyPosition() && !this.autochangerTrucks.isAtHandoffPosition()) {
            String msg = this.name + ": autochanger is loaded with a filter but is not " + "at handoff position neither at standby - can't open clamp.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new BadCommandException(msg);
        }
        if (this.autochangerTrucks.isAtStandbyPosition() && !this.isCarouselHoldingFilterAtStandby()) {
            String msg = this.name + ": autochanger is loaded with a filter and is  " + "at STANDBY position but carousel doesn't hold the filter " + "- can't open latches.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new BadCommandException(msg);
        }
        if (this.autochangerTrucks.isAtHandoffPosition() && !this.isLoaderHoldingFilterAtHandoff()) {
            String msg = this.name + ": autochanger is loaded with a filter and is  " + "at HANDOFF position but loader doesn't hold the filter " + "- can't open latches.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new BadCommandException(msg);
        }
        if (this.autochangerTrucks.isAtStandbyPosition() && this.isCarouselHoldingFilterAtStandby()) {
            return true;
        }
        return this.autochangerTrucks.isAtHandoffPosition() && this.isLoaderHoldingFilterAtHandoff();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the latches can be closed.")
    public boolean checkPreConditionsForClosingLatches() throws FcsHardwareException, BadCommandException {
        this.updateStateWithSensors();
        if (this.latches.isInError()) {
            String msg = this.name + ": latches are in ERROR state - can't close latches.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (this.isEmpty()) {
            String msg = this.name + ": no filter in autochanger - can't close latches.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (!this.autochangerTrucks.isAtStandbyPosition() && !this.autochangerTrucks.isAtHandoffPosition()) {
            String msg = this.name + ": autochanger is not " + "at handoff position neither at standby - can't close latches.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new BadCommandException(msg);
        }
        return true;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if loader is connected and holding a filter. This command doesn't read again the sensors.")
    boolean isLoaderHoldingFilterAtHandoff() throws BadCommandException, FcsHardwareException {
        if (this.loaderConnected) {
            return this.loader.isHoldingAFilter();
        }
        return false;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        if (!this.plutoGateway.isBooted()) {
            throw new FcsHardwareException(this.name + ": plutoGateway not booted - can't read sensors");
        }
        if (!this.plutoGateway.isInitialized()) {
            throw new FcsHardwareException(this.name + ": plutoGateway not initialized - can't read sensors");
        }
        this.lock.lock();
        try {
            this.updatingState = true;
            this.plutoGateway.updateValues();
            String[] readHexaValues = this.plutoGateway.getHexaValues();
            FCSCst.FCSLOG.finest((Object)("readHexaValues[0]=" + readHexaValues[0]));
            FCSCst.FCSLOG.finest((Object)("readHexaValues[1]=" + readHexaValues[1]));
            FCSCst.FCSLOG.finest((Object)("readHexaValues[2]=" + readHexaValues[2]));
            FCSCst.FCSLOG.finest((Object)("readHexaValues[3]=" + readHexaValues[3]));
            this.loaderConnectedSensor0.updateValue(readHexaValues);
            this.loaderConnectedSensor1.updateValue(readHexaValues);
            this.loaderConnected = this.loaderConnectedSensor0.getDigitalValue() == 1 && this.loaderConnectedSensor1.getDigitalValue() == 1;
            this.loaderConnectedSensorsInError = this.loaderConnectedSensor0.getDigitalValue() != this.loaderConnectedSensor1.getDigitalValue();
            this.autochangerTrucks.updateStateWithSensors(readHexaValues);
            this.latches.updateStateWithSensors(readHexaValues);
            this.onlineClamps.updateStateWithSensors(readHexaValues);
            this.empty = this.latches.getLatchXminus().isEmpty() && this.latches.getLatchXplus().isEmpty();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
            this.autochangerTrucks.publishData();
            this.latches.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at HANDOFF. This command doesn't read again the sensors.")
    boolean isAtHandoff() {
        return this.autochangerTrucks.isAtHandoffPosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the autochanger. This command doesn't read again the sensors.")
    boolean isEmpty() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.empty;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void goToHandOff() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.autochangerTrucks.goToHandOff();
    }

    void grabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void ungrabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void moveFilterToHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void grabFilterAtStandby(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void tick() {
        this.publishData();
    }

    public StatusDataPublishedByAutoChanger getStatusData() {
        StatusDataPublishedByAutoChanger status = this.createStatusDataPublishedByAutoChanger();
        return status;
    }

    public StatusDataPublishedByAutoChanger createStatusDataPublishedByAutoChanger() {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
        status.setName(this.name);
        status.setLoaderConnectedSensorValue0(this.loaderConnectedSensor0.getDigitalValue());
        status.setLoaderConnectedSensorValue1(this.loaderConnectedSensor1.getDigitalValue());
        status.setLoaderConnectedSensorsInError(this.isLoaderConnectedSensorsInError());
        return status;
    }

    public void publishData() {
        StatusDataPublishedByAutoChanger status = this.getStatusData();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerGeneral", (Serializable)status));
    }
}

