###############################################################
#Script to test the real hardware of autochanger online clamps
#on CPPM testbench executed in september 2015
###############################################################
from org.lsst.ccs.scripting import *
from java.lang import Exception
from java.lang import RuntimeException
from org.lsst.ccs.command import *
from time import sleep



 

CCS.setThrowExceptions(True)


cppm = CCS.attachSubsystem("testbenchCPPM")

print "Connected to testbenchCPPM=> ", cppm

ccsVersion= cppm.synchCommandLine(5,"getCCSVersions")
print "TESTS of autochanger trucks motion with CCS version number"
print ccsVersion.getResult()

#print "Date=", date

tcpProxy = CCS.attachSubsystem("testbenchCPPM/tcpProxy")

result = tcpProxy.synchCommandLine(5,"isHardwareReady")

print "isHardwareReady=", result.getResult()

clamp = CCS.attachSubsystem("testbenchCPPM/onlineClampXminus")
##################################INITIALIZATION


waitTime = int(1)



#Read the onlineController mode and check if it's in CURRENT mode.
ctl = CCS.attachSubsystem("testbenchCPPM/onlineClampController")
mode = ctl.synchCommandLine(5,"readMode")
print "Controller Mode=", mode.getResult()

if str(mode.getResult()) != 'CURRENT' :
   #  raise Exception("ERROR on Controller mode")
   print "ERROR on Controller mode - have to change it."
   result = ctl.synchCommandLine(5,"changeMode CURRENT")
else:
   print "controller is in mode", mode.getResult()


#loop to lock and unlock the online clamp
#

for i in range(5):
   print "begin ITERATION number", i
   print "LOCKING"
   resultMvt=clamp.synchCommandLine(10000,"testLock")
   #TODO test if execution is correct
   print "Sleeping", waitTime, "s....."
   sleep(waitTime)
   print "UNLOCKING"
   resultMvt=clamp.synchCommandLine(10000,"testUnlock")
   print "Sleeping", waitTime, "s....."
   sleep(waitTime)
   print "end ITERATION number", i

print "END LOOP"