#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import *
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from java.lang import RuntimeException
from org.lsst.ccs.command import *

#
CCS.setThrowExceptions(True);

loaderStandalone = CCS.attachSubsystem("loader-standalone");

print "Connected to loader-standalone ",loaderStandalone

#getting timeouts
loaderConfigFuture = loaderStandalone.asynchCommandLine("getConfigurationInfo");
print "getting loader configuration info";
loaderConfig = loaderConfigFuture.get();
timeoutHandoff = loaderConfig.getCurrentValueForParameter("carrier//timeoutForGoingToHandOff")
timeoutStorage = loaderConfig.getCurrentValueForParameter("carrier//timeoutForGoingToStorage")
timeoutToOpen = loaderConfig.getCurrentValueForParameter("clamp//timeoutForOpeningHooks")
#loaderClampConfig = loaderConfig.getLoaderClampConfig();

CCS.setThrowExceptions(False);

#Handle the thrown exceptions                                                                                                 
print "Trying opening Hooks....";
result = loaderStandalone.synchCommandLine(int(timeoutToOpen), "openHooks");

if not isinstance(result.getResult(), CommandInvocationException):
     raise Exception("Clamps must not open when carrier is loaded with a filter but is not at handoff position");

CCS.setThrowExceptions(True);
print "Loader going to HANDOFF....";
result = loaderStandalone.synchCommandLine(int(timeoutHandoff),"goToHandoff");
print "Gone to HANDOFF.";
print "Loader going to STORAGE....";
result = loaderStandalone.synchCommandLine(int(timeoutStorage), "goToStorage");
print "Gone to STORAGE."
