/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * To creates Objects for GUI and Status Bus.
 * @author turri
 */
public class FcsUtils {


    
    /**
     * The maximum value which a number coded on 2 bytes can reach.
     */
    public static final int MAX_VALUE_2BYTES = 65535;
    
    /**
     * The maximum number of CANopen devices which can be on a CANbus.
     * Also the maximum CANopen node ID a device can have.
     */
    public static final int MAX_NODE_ID = 127;

    /**
     ******************************************************************************
     * Methods to create Objects to publish data to be stored in the trending
     * database and update the GUI.
     * *****************************************************************************
     */


    /**
     * Creates an object to be published on the STATUS bus by a PieceOfHardware.
     * @param device
     * @return 
     */
    public static StatusDataPublishedByHardware createStatusDataPublishedByHardware(PieceOfHardware device) {
        StatusDataPublishedByHardware status = new StatusDataPublishedByHardware(device.getName(),
                device.isBooted(), device.isInitialized());
        return status;
    }

    /**
     * Creates an object to be published on the STATUS bus by an EPOSController.
     * @param ctlr
     * @return 
     */
    public static StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController(EPOSController ctlr) {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController();
        status.setName(ctlr.getName());
        status.setBooted(ctlr.isBooted());
        status.setInitialized(ctlr.isInitialized());
        status.setEnabled(ctlr.isEnabledToPublish());
        status.setInError(ctlr.isInError());
        status.setErrorRegister(ctlr.getErrorRegister());
        status.setErrorHistory(ctlr.getErrorHistory());
        status.setMode(ctlr.getModeInString());
        return status;
    }

    /**
     * *****************************************************************************
     ** end of Methods to create Objects to publish data.
     * *****************************************************************************
     */

    /**
     *
     * @param bin
     * @return
     */
    public static String binaryToHex(String bin) {
        int binaryToInt = Integer.parseInt(bin, 2);
        return Integer.toHexString(binaryToInt);
    }

    /**
     * The String argument represents an integer in hexa. This methods returns a
     * string representation of this integer argument as an unsigned integer in
     * base 2.
     *
     * @param Hex
     * @return the binary form of this integer with 8 digits examples :
     * HexToBinary(4) returns 00000100 HexToBinary(AA) returns 10101010
     * HexToBinary(FF) returns 11111111
     */
    public static String hexToBinary(String Hex) {
        int integer = Integer.parseInt(Hex, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%08d", Integer.parseInt(bin));
    }

    /**
     * The String argument represents an integer in hexa. This methods returns a
     * string representation of this integer argument as an unsigned integer in
     * base 2.
     *
     * @param twoBytesInHexa
     * @return the binary form of this integer with 16 digits examples :
     * twoBytesInHexaToBinary("4") returns 0000000000000100
     * twoBytesInHexaToBinary("AA") returns 0000000010101010
     * twoBytesInHexaToBinary("FFFF") returns 1111111111111111
     */
    public static String twoBytesInHexaToBinary(String twoBytesInHexa) {
        int integer = Integer.parseInt(twoBytesInHexa, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%016d", Long.parseLong(bin));
    }

    /**
     * Takes an integer represented by 2 bytes in hexa as argument, transforms
     * is its binary representation, replaconfigonfiges the bit at position
     * bitPosition by digit given as argument. and returns the new hexa value.
     *
     * @param twoBytesInHexa
     * @param bitPosition
     * @param digit
     * @return
     */
    public static String replaceDigit(String twoBytesInHexa, int bitPosition, String digit) {
        if (bitPosition < 0 || bitPosition > 15) {
            throw new IllegalArgumentException("replaceDigit:  bitPosition must be: 0< bitPosition <15");
        }
        if (!(digit.equals("0") || digit.equals("1"))) {
            throw new IllegalArgumentException("replaceDigit:  digit must 0 or 1");
        }
        StringBuilder bin = new StringBuilder(FcsUtils.twoBytesInHexaToBinary(twoBytesInHexa));
        bin.replace(15 - bitPosition, 15 - bitPosition + 1, digit);
        return Integer.toHexString(Integer.parseInt(bin.toString(), 2));
    }

    /**
     * Transforms a numericonfigonfig value given in hexa to binary and
     * replaconfigonfige the digit in position pos given as argument by 0.
     *
     * @param hexaVal
     * @param pos
     * @return
     */
    public static String force2zero(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        }
        int intVal = Integer.parseInt(hexaVal, 16);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; i++) {
            sb.append('1');
        }
        sb.setCharAt(16 - (pos + 1), '0');
        int mask = Integer.parseInt(sb.toString(), 2);

        int myNewVal = intVal & mask;
        return Integer.toHexString(myNewVal);
    }

    /**
     * Transforms a numericonfigonfig value given in hexa to binary and
     * replaconfigonfige the digit in position pos given as argument by 1.
     *
     * @param hexaVal
     * @param pos
     * @return
     */
    public static String force2one(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        }
        int intVal = Integer.parseInt(hexaVal, 16);

        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; i++) {
            sb.append('0');
        }
        sb.setCharAt(16 - (pos + 1), '1');
        int mask = Integer.parseInt(sb.toString(), 2);

        int myNewVal = intVal | mask;
        return Integer.toHexString(myNewVal);
    }

    /**
     * Transform an integer given in its deconfigonfigimal format to its binary
     * format, reverse it and returns the reversed binary at an array of int.
     * format.
     *
     * @param decimal
     * @return an array of int
     */
    public static int[] toReverseBinary(int decimal) {
        int[] tab = new int[16];

        for (int i = 0; i < 16; i++) {
            int bit = (decimal >> i) & 0x1;
            tab[i] = bit;
        }
        return tab;
    }

}
