package org.lsst.ccs.subsystems.fcs.testbench;

import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is the main module for the control software of the LPNHE test bench. The
 * LPNHE test bench consists on one PC104 which hosts a Canfestival C-Wrapper
 * and a Maxon Motor to unlock or release a carousel filter clamp. The C-Wrapper
 * starts a TCPIP client which connects to the TCPIP server started by the main
 * Module of the LPNHE test bench main Module.
 *
 * When the LPNHETestBenchMainModule starts, it starts a a TCP-IP server. the
 * can open wrapper software will connect. Then the LPNHETestBenchProxy and the
 * Wrapper will communicate over this TCP connection with a protocol to be
 * define. In a first version : 1- The TCP server is started and waits for a
 * client connection, 2- When the client connects, it sends first a key word
 * "APCTestBench". 3- When the server receives the key word "APCTestBench", it's
 * ready to boot the hardware and receive commands.
 *
 * @author virieux
 */
public class LPNHETestBenchMainModule extends Module {

    private BridgeToHardware bridge;
    private CarouselClampModule clampXminus;
    private AtomicBoolean haltRequired;

    //FOR SPRING
    public BridgeToHardware getBridge() {
        return bridge;
    }

    //FOR SPRING
    public void setBridge(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    public CarouselClampModule getClampXminus() {
        return clampXminus;
    }

    public void setClampXminus(CarouselClampModule clampXminus) {
        this.clampXminus = clampXminus;
    }

    /**
     * Read and return the temperature of the clampXminus. Just for the tests.
     *
     * @return
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    public double readTemperature() throws FcsHardwareException {
        return clampXminus.updateTemperature();
    }

    /**
     * This method returns true if the C-Wrapper is connected to the tcp proxy.
     * The C-Wrapper has to send the tcpProxy clientName as a keyword before any
     * communication can begin. So if the C-Wrapper doesn't send the good
     * keyword or if it doesn't connect to the tcp proxy, this method returns
     * false.
     *
     * @return
     */
    public boolean isHardwareConnected() {
        return bridge.isCWrapperConnected();
    }

    /**
     * returns true if the hardware is booted, identified and initialized.
     *
     * @return
     */
    public boolean isHardwareReady() {
        return bridge.isHardwareReady();
    }

    @Override
    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT:
                FCSLOG.debug("HALT required");
                this.haltRequired.set(true);
                break;
            case INTERRUPT1:
                break;
            case INTERRUPT2:
                break;
            case RE_START:
                this.haltRequired.set(false);
                break;
            default:
                assert false: signal.getLevel();
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

}
