/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.testbench.LPC;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is a model for the mobile part of the scale1 prototype test bench.
 * @author Virieux, Chassagny
 */
public class Scale1ProtoPivotingFrame extends MobileItemModule {
    
    private CanOpenDigitaxVariator variatorX;
    private CanOpenDigitaxVariator variatorZ;
    
    private double angleXToReach;
    private double angleZToReach;
    private double actualXAngle;
    private double actualZAngle;

    public Scale1ProtoPivotingFrame(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
    }
    
    @Override
    public void initModule() {
        this.variatorX = (CanOpenDigitaxVariator) this.getComponentByName("variatorX");
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, description="Returns true if hardware is connected and ready.")
    @Override
    public boolean isHardwareReady() {
        return ((MainModule) this.getComponentByName("main")).isHardwareReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        return Double.doubleToRawLongBits(this.actualXAngle) == 
                Double.doubleToRawLongBits(this.angleXToReach);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    public String goToHome() {
        //TODO
        return name + " is at Home Position.";
    }
    
    /**
     * to rotate around X axis
     * @param angle
     * @return 
     */
    public String rotateX(long angle) {
        //TODO
        //variatorX.executeAction(rotationX);
        return name + " has rotated at requested angle: " + angle;        
    }
    
    /**
     * to rotate around Z axis
     * @param angle
     * @return 
     */
    public String rotateCamera(long angle) {
        //TODO
        return name + " has rotated";
    }

    @Override
    public void publishData() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
}
