/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * Used in APC TEST BENCH only. This is to represent a very basic led which is
 * connected on the CAn Open device AI814
 *
 * @author virieux
 */
public class CanOpenLED extends Module implements Led {

    private CanOpenDAC dac;

    //for Groovy; used in initModule
    private String dacName;

    private int outputNumero;


    public CanOpenDAC getDac() {
        return dac;
    }

    public void setDac(CanOpenDAC dac) {
        this.dac = dac;
    }

    public String getDacName() {
        return dacName;
    }

    public void setDacName(String dacName) {
        this.dacName = dacName;
    }

    public int getOutputNumero() {
        return outputNumero;
    }

    public void setOutputNumero(int outputNumero) {
        this.outputNumero = outputNumero;
    }

    @Override
    public void initModule() {
        this.dac = (CanOpenDAC) this.getComponentByName(dacName);
    }

    @Override
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1,
            description = "Turn on LED to please Emmanuel.")
    public String turnON() throws SDORequestException, HardwareNotDetectedException, 
            FcsHardwareException {
        dac.writeAnalogOutput(outputNumero, 14000);
        return "LED is turn ON";
    }

    @Override
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1,
            description = "Turn off LED to please Emmanuel.")
    public String turnOFF() throws SDORequestException, HardwareNotDetectedException, 
            FcsHardwareException {
        dac.writeAnalogOutput(outputNumero, 0);
        return "LED is turn OFF";
    }

    /**
     * to sent a current to a led
     *
     * @param hexa (3000 par exemple)
     * @return
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     * @throws HardwareNotDetectedException
     */
    public String sentCurrent(String hexa) throws SDORequestException, 
            HardwareNotDetectedException,
            FcsHardwareException {
        dac.writeAnalogOutput(outputNumero, Integer.parseInt(hexa, 16));
        return "LED is turn ON";
    }

}
