/*
 * To change this template, choose Tools | Templates
 * and unlockClamps the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.InclinometerModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This subsystem is to read some sensors in CPPM through the pluto gateway.
 *
 * @author virieux
 */
public class CPPMTestBenchMainModule extends MainModule {

    private final InclinometerModule inclinometer;

//    private final AutoChangerModule autochanger;
    private final String plutoGatewayName;
    private PlutoGatewayModule plutoGateway;

    private final AutochangerOnlineClampModule onlineClampXminus;
    private final AutochangerLatchModule latchXminus;
    private final AutoChangerTrucksModule autochangerTrucks;

//        @ConstructorProperties({"name", "tickmillis", 
//        "bridge", 
//        "inclinometer",
//        "onlineClampXminus"})
    public CPPMTestBenchMainModule(String aName, int aTickMillis,
            BridgeToHardware aBridge,
            String plutoGatewayName,
            InclinometerModule inclinometer,
            AutochangerOnlineClampModule onlineClamp,
            AutochangerLatchModule latch,
            AutoChangerTrucksModule trucks
    ) {
        super(aName, aTickMillis, aBridge);
        this.plutoGatewayName = plutoGatewayName;
        this.inclinometer = inclinometer;
        this.onlineClampXminus = onlineClamp;
        this.latchXminus = latch;
        this.autochangerTrucks = trucks;

    }

    //for the GUI
//    public AutoChangerModule getAutochanger() {
//        return autochanger;
//    }
    public EPOSController getLinearRailMasterController() {
        return this.autochangerTrucks.getLinearRailMasterController();
    }

    public EPOSController getLinearRailSlaveController() {
        return this.autochangerTrucks.getLinearRailSlaveController();
    }

//    public EPOSController getOnlineClampXminusController() {
//        return onlineClampXminus.getController();
//    }
//    
//    public EPOSController getOnlineClampXplusController() {
//        return autochanger.getOnlineClamps().getOnlineClampXplusController();
//    }
//        
//    public EPOSController getOnlineClampZController() {
//        return autochanger.getOnlineClamps().getOnlineClampZController();
//    }
    public PlutoGatewayModule getPlutoGateway() {
        return plutoGateway;
    }

    public AutoChangerTrucksModule getAutochangerTrucks() {
//        return autochanger.getTrucks();
        return autochangerTrucks;
    }

//    public EPOSController getLatchXminusController() {
//        return autochanger.getLatches().getLatchXminusController();
//    }
//
//    public EPOSController getLatchXplusController() {
//        return autochanger.getLatches().getLatchXplusController();
//    }
    public AutochangerOnlineClampModule getOnlineClampXminus() {
        return onlineClampXminus;
    }

    public AutochangerLatchModule getLatchXminus() {
        return latchXminus;
    }

    public EPOSController getOnlineClampXminusController() {
        return onlineClampXminus.getController();
    }

    public EPOSController getLatchXminusController() {
        return latchXminus.getLatchController();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.plutoGateway = (PlutoGatewayModule) this.getComponentByName(plutoGatewayName);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
            description = "Update autochanger state in reading the sensors.")
    @Override
    public void updateStateWithSensors() throws FcsHardwareException,
            ErrorInCommandExecutionException, BadCommandException {
        super.updateStateWithSensors();
//        autochanger.updateStateWithSensors();

    }
}
